function fill_win_virtual_network_settings(ip_id){
	
	var unique_parent_id = '#hypervisor_win_content__incend__'+ ip_id+' .win_virtual_network_settings_tab';
	$(unique_parent_id+' .initializer').show();
	$(unique_parent_id+' .text').removeClass('error');
	
	var ip = replace_with(ip_id,'_','.');
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid='+sid+'&ip='+ip+'&type=desktop';
	
	//Generate Device number select box
	$(unique_parent_id + ' .refresh a').attr('onclick', 'fill_win_virtual_network_settings("' + ip_id + '")');
	$(unique_parent_id + ' .attach_wr').attr('onclick', 'wvns_attach("'+unique_parent_id+'", "' + getdata + '", "external_wr", "1")');
	$(unique_parent_id + ' .vm_dd').attr('onclick', 'load_vnic("'+unique_parent_id+'", "' + getdata + '")');
	load_wvns_data(unique_parent_id, getdata);
}

function load_vnic(unique_parent_id, getdata){
	var vm_guid = $.trim($(unique_parent_id+' .vm_dd option:selected').val());
	getdata += '&action=get_vnic';
	getdata += '&vm_guid='+vm_guid;
	$.ajax({
                url: '/python/win_virtual_network_settings.py',
                type: 'GET',
                dataType: 'json',
                cache: false,
                data: getdata,
                success: function(data){
                        //$(unique_parent_id+' .initializer').hide();
                        if ( data['vnic_status'] == '0' ) {
                                $(unique_parent_id+' .vnic_dd').html(data['vnic_html']);
                        }
                }
        });
}

function wvns_attach(unique_parent_id, getdata){
	getdata += '&action=attach';
	getdata += '&nw_id='+$(unique_parent_id+' .nw_dd select').val();
	getdata += '&vm_id='+$(unique_parent_id+' .vm_dd select').val();
	getdata += '&vnic_id='+$(unique_parent_id+' .vnic_dd select').val();
	$(unique_parent_id+' .initializer').show();
	$.ajax({
		url: '/python/win_virtual_network_settings.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			
			if ( data == '-2' ) {
				show_redirect_alert();
			}
			else if ( data == '0' ) {
				display_success(unique_parent_id);
			}
			else if ( data == '-1' ) {
				display_failed(unique_parent_id);
			}
		}
	});	
}

function load_wvns_data(unique_parent_id, getdata){
	 getdata += '&action=get';
	 $.ajax({
		url: '/python/win_virtual_network_settings.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			
			if ( data['nw_status'] == '-2' || data['vm_status'] == '-2' ) {
				show_redirect_alert();
			}
			
			if ( data['nw_status'] == '0' ) {
				$(unique_parent_id+' .nw_dd').html(data['nw_html']);
			}
			
			if ( data['vm_status'] == '0' ) {
				$(unique_parent_id+' .vm_dd').html(data['vm_html']);
			}
			
			if ( data['nw_status'] == '-1' || data['vm_status'] == '-1' ) {
				display_failed(unique_parent_id);
			}
		}
	});	
}
