$(document).ready(function(){
	$('.vm_tree_li a.tree_action').live('click',function(){
		$('.vm_tree_li a:not(.tree_action)').removeClass('selected');
		$(this).next().trigger('click');
	});
});

function fill_win_switch_conf(ip_id){	
	var unique_parent_id = '#hypervisor_win_content__incend__'+ ip_id+' .win_switch_conf_tab';
	$(unique_parent_id+' .initializer').show();
	$(unique_parent_id+' .win_tree_wr').html('');
	$(unique_parent_id+' .detail_wr').hide();
	$(unique_parent_id+' .detail_wr dd:not(.network_name_description_dd)').html('&nbsp;');
	$(unique_parent_id+' .detail_wr .network_name_description').html('&nbsp;');
	
	var ip = replace_with(ip_id,'_','.');
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid='+sid+'&ip='+ip+'&type=desktop';
	
	$(unique_parent_id + ' .refresh a').attr('onclick', '$("' + unique_parent_id + ' .win_tree_wr").html("");fill_win_switch_conf("' + ip_id + '")');
	$(unique_parent_id + ' .delete_switch').attr('onclick','win_delete_switch("'+ unique_parent_id +'", "'+ getdata +'", "'+ip_id+'" )');
	$(unique_parent_id + ' .delete_vif').attr('onclick','win_delete_vif("'+ unique_parent_id +'", "'+ getdata +'", "'+ip_id+'")');
	$(unique_parent_id + ' .detach_vm').attr('onclick','win_detach_vm("'+ unique_parent_id +'", "'+ getdata +'", "'+ip_id+'")');
	load_win_switch_conf(unique_parent_id, getdata);
}

function load_win_switch_conf(unique_parent_id, getdata){
	getdata += '&action=get';
	$.ajax({
		url: '/python/win_switch_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(html){
			$(unique_parent_id+' .initializer').hide();
			
			if ( html == '-2' ) {
				show_redirect_alert();
			}
			else if ( html != '-1' ) {
				$(unique_parent_id+' .win_tree_wr').html(html);
				$(unique_parent_id+' .win_tree_wr .tree_ul .vm_tree_li:first a:first').trigger('click');
			}
		}
	});	
}

function win_conf_select(unique_parent_id, element, c_type ){
	$(unique_parent_id+' .vm_tree_li a:not(.tree_action)').removeClass('selected');
	element.addClass('selected');
	$(unique_parent_id+' .detail_wr').hide();
	$(unique_parent_id+' .vnt_'+c_type+'_wr').fadeIn(300);
	if( c_type == 'switch' ){
		$(unique_parent_id+' .switchname').html(win_switch_check_value(element.children('.switchname').val()));
		$(unique_parent_id+' .guid').html(win_switch_check_value(element.children('.guid').val()));
		$(unique_parent_id+' .networkIntf').html(win_switch_check_value(element.children('.networkIntf').val()));
		$(unique_parent_id+' .portGUID').html(win_switch_check_value(element.children('.portGUID').val()));
		$(unique_parent_id+' .HealthState').html(win_switch_check_value(element.children('.HealthState').val()));
		$(unique_parent_id+' .EnabledState').html(win_switch_check_value(element.children('.EnabledState').val()));
		var port_type = win_switch_check_value(element.children('.PortType').val());
		var port_type_str = '';
		if( port_type == '0' ){
			port_type_str = 'Private';
		}
		else if( port_type == '1' ){
			port_type_str = 'External';
		}
		else if( port_type == '2' ){
			port_type_str = 'Internal';
		}
		$(unique_parent_id+' .PortType').html(port_type_str);
		$(unique_parent_id+' .PortName').html(win_switch_check_value(element.children('.PortName').val()));
	}
	else if( c_type == 'vm' ){
		$(unique_parent_id +' .vnt_'+c_type+'_wr' + ' .name_label').html(win_switch_check_value(element.children('.name_label').val()));
		$(unique_parent_id +' .vnt_'+c_type+'_wr' + ' .guid').html(win_switch_check_value(element.children('.guid').val()));
		$(unique_parent_id +' .vnt_'+c_type+'_wr' + ' .HealthState').html(win_switch_check_value(element.children('.HealthState').val()));
		$(unique_parent_id +' .vnt_'+c_type+'_wr' + ' .powerstate').html(win_switch_check_value(element.children('.powerstate').val()));
	}
}

function win_delete_switch( unique_parent_id, getdata, ip_id ){
	if( !$(unique_parent_id+' .tree_ul li a.selected').length ){
		return
	}
	getdata += '&action=del_switch&id='+$(unique_parent_id+' .tree_ul li a.selected').children('.switchname').val();
	$(unique_parent_id+' .initializer').show();
	$.ajax({
		url: '/python/win_switch_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			if ( data == '-2' ) {
				show_redirect_alert();
			}
			else if ( data == '0' ) {
				$(unique_parent_id+' .win_tree_wr').html('');
				fill_win_switch_conf(ip_id);
			}
			else{
				show_error_info(unique_parent_id, data);
			}
		}
	});		
}

function win_delete_vif( unique_parent_id, getdata, ip_id ){
	if( !$(unique_parent_id+' .tree_ul li a.selected').length ){
		return
	}
	getdata += '&action=del_vif&id='+$(unique_parent_id+' .tree_ul li a.selected').children('.vif_uuid').val();
	$(unique_parent_id+' .initializer').show();
	$.ajax({
		url: '/python/win_switch_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			if ( data == '-2' ) {
				show_redirect_alert();
			}
			else if ( data == '0' ) {
				$(unique_parent_id+' .win_tree_wr').html('');
				fill_win_switch_conf(ip_id);
			}
			else{
				show_error_info(unique_parent_id, data);
			}
		}
	});		
}

function win_detach_vm( unique_parent_id, getdata, ip_id ){
	
	if( !$(unique_parent_id+' .tree_ul li a.selected').length ){
		return
	}
	getdata += '&action=detach_vm&vmid='+$(unique_parent_id+' .tree_ul li a.selected').children('.guid').val();
	getdata += '&name_label='+$(unique_parent_id+' .tree_ul li a.selected').parent().parent().siblings('.switch').children('.guid').val();
	getdata += '&vnic_mac='+$(unique_parent_id+' .tree_ul li a.selected').children('.vnic_mac').val();
	$(unique_parent_id+' .initializer').show();
	$.ajax({
		url: '/python/win_switch_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			if ( data == '-2' ) {
				show_redirect_alert();
			}
			else if ( data == '0' ) {
				$(unique_parent_id+' .win_tree_wr').html('');
				fill_win_switch_conf(ip_id);
			}
			else{
				//show_error_info(unique_parent_id, data);
				display_failed(unique_parent_id);
			}
		}
	});		
}

function win_switch_check_value(value){
	if( $.trim(value) == '' ){
		return '-';
	}
	else{
		return value;
	}
}
