function fill_xen_vf_props(ip_id){
	var unique_parent_id = '#system_content__incend__'+ ip_id+' .system_xen_vf_props_tab';

	xen_vfp_discard_changes(unique_parent_id);
	$(unique_parent_id+' .initializer').show();
	var ip = replace_with(ip_id,'_','.');
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid='+sid+'&ip='+ip;
	
	$(unique_parent_id + ' .refresh a').attr('onclick', '$("' + unique_parent_id + ' .vm_wr").html("");fill_xen_vf_props("' + ip_id + '")');
	$(unique_parent_id + ' .vm_props_save_changes').attr('onclick','xen_assign_pci_to_vms("'+ unique_parent_id +'", "'+ getdata +'", "'+ip_id+'" )');
	$(unique_parent_id + ' .set_iommu').attr('onclick','xen_set_iommu("'+ unique_parent_id +'", "'+ getdata +'", "'+ip_id+'" )');
	$(unique_parent_id+' [name=iommu]').attr('onclick','xen_update_iommu_btn("'+ unique_parent_id +'")');
	$(unique_parent_id + ' .discard_changes').attr('onclick','xen_vfp_discard_changes("'+ unique_parent_id +'")');
	load_xen_vms_4vmprops(unique_parent_id, getdata);
}

function load_xen_vms_4vmprops(unique_parent_id, getdata){
	getdata += '&action=get'
	$.ajax({
		url: '/python/xen_vf_props.py',
		type: 'GET',
		cache: false,
		data: getdata,
		dataType: 'json',
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			if ( data.vm_html == '-2' || data.pci_html == '-2' ) {
				show_redirect_alert();
			}
			
			if ( data.vm_html != '-1' ) {
				$(unique_parent_id+' .vm_wr').html(data.vm_html);
			}
			
			if ( data.pci_html != '-1' ) {
				$(unique_parent_id+' .pci_wr').html(data.pci_html);
			}
			
			$(unique_parent_id+' [name=iommu]').removeAttr('checked');
			$(unique_parent_id+' [name=iommu][value='+data.iommu+']').attr('checked','checked');
			//Assigning the current value
			$(unique_parent_id+' [name=iommu]').removeAttr('class').addClass('val_'+data.iommu);
		}
	});	
}

function select_vm(unique_parent_id, element){
	$(unique_parent_id+' .vm_wr li').removeClass('selected');
	element.addClass('selected');
	toggle_button(unique_parent_id);
}

function toggle_button(unique_parent_id){
	if( $(unique_parent_id+' .vm_wr li.selected').length && $(unique_parent_id+' .pci_wr li.selected').length ){
		$(unique_parent_id+' .vfp_btn_wr .btn_wraper:not(.set_iommu) button').removeClass('disabled').addClass('blue').removeAttr('disabled');
	}
	else{
		$(unique_parent_id+' .vfp_btn_wr .btn_wraper:not(.set_iommu) button').removeClass('blue').addClass('disabled').attr('disabled','disabled');
	}
}

function select_vmpci(unique_parent_id, element){
	if( element.hasClass('selected') ){
		element.removeClass('selected');
	}
	else{
		element.addClass('selected');		
	}
	toggle_button(unique_parent_id);
}

function xen_vfp_discard_changes(unique_parent_id){
	$(unique_parent_id+' .pci_wr li').removeClass('selected');
	$(unique_parent_id+' .vm_wr li').removeClass('selected');
	$(unique_parent_id+' .vfp_btn_wr button').attr('disabled','disabled').removeClass('blue').addClass('disabled');
}

function xen_assign_pci_to_vms(unique_parent_id, getdata, ip_id){
	$(unique_parent_id+' .initializer').show();
	getdata += '&action=assign&uuid='+$(unique_parent_id+' .vm_wr li.selected').children('.uuid').val();
	var vfpci = '';
	$(unique_parent_id+' .pci_wr li.selected').each(function(i){
		vfpci += ','+i+'/0000:'+$(this).children('.vfpci').val()+',';
	});
	getdata += '&vfpci='+vfpci;
	
	$.ajax({
		url: '/python/xen_vf_props.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			if ( data.iommu_status == '-2' || data.assign_status == '-2' ) {
				show_redirect_alert();
			}
			else if ( data.assign_status != '-1' && data.assign_status != '-1' ) {
				xen_vfp_discard_changes(unique_parent_id);
				$(unique_parent_id+' .vm_wr').html('');
				fill_xen_vf_props(ip_id);
			}
		}
	});		
}

function xen_set_iommu(unique_parent_id, getdata, ip_id){
	getdata += '&action=set_iommu';
	
	//Iommu - Set only if altered
	var current_stats = $(unique_parent_id+' [name=iommu]').attr('class').split('val_')[1]
	if( $(unique_parent_id+' [name=iommu]:checked').val() != current_stats ){
		getdata += '&iommu_val='+$(unique_parent_id+' [name=iommu]:checked').val();
	}
	else{
		return
	}
	
	$(unique_parent_id+' .initializer').show();	
	$.ajax({
		url: '/python/xen_vf_props.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(status){
			$(unique_parent_id+' .initializer').hide();
			if ( status == '-2' ) {
				show_redirect_alert();
			}
			else if ( status == '0' ) {
				xen_vfp_discard_changes(unique_parent_id);
				$(unique_parent_id+' .vm_wr').html('');
				fill_xen_vf_props(ip_id);
				$('.dummy').chLightbox('alert', {
					alertTitle: 'IOMMU',
					alertMsg: 'Start / Re-Start the Host / VM machine for the changes to take effect.',
					alertOk: 'OK',
					lbWidth: 420,
					top_extra: 50
				});
			}
			else{
				$(unique_parent_id+' .global_error').show();
			}
		}
	});		
}

function xen_update_iommu_btn(unique_parent_id){
	var current_stats = $(unique_parent_id+' [name=iommu]').attr('class').split('val_')[1]
	if( $(unique_parent_id+' [name=iommu]:checked').val() != current_stats ){
		$(unique_parent_id + ' .set_iommu button').removeAttr('disabled').removeClass('disabled').addClass('blue');		
	}
	else{
		$(unique_parent_id + ' .set_iommu button').attr('disabled','disabled').removeClass('blue').addClass('disabled');		
	}	
}
