var UM_MSG = 'On successful installation of the UM Update, the connection with the machine will be lost and it will be disconnected. You have to reconnect it manually for further use.<div class="f_bold mgn_t10"> Are you sure you want to proceed with installation?</div>'; 
function initialize_system_um_update(ip_id){
	var unique_parent_id = '#system_content__incend__'+ ip_id+' .system_um_update_tab';
	$(unique_parent_id+' .initializer').hide();
	var ip = replace_with(ip_id, '_', '.');
	var loader_selector = unique_parent_id + ' .initializer';
	
	if( $.trim($(unique_parent_id +' .ostype_input').val()) != '' ){
		return
	}
	$(loader_selector).show();
	
	//initializing
	$(unique_parent_id +' .file_text').attr('onclick','update_sdi_trigger_fileinput("'+ unique_parent_id +'",$(this))');
	$(unique_parent_id +' .sl_file_input').attr('onchange','update_sdi_display_filepath("'+ unique_parent_id +'",$(this))');
	$(unique_parent_id +' .install_wr').attr('onclick','update_sdi_install("'+ unique_parent_id +'","'+ ip +'","'+ ip_id +'")');
	$(unique_parent_id +' .discard_wr').attr('onclick','update_sdi_discard("'+ unique_parent_id +'")');
	$(unique_parent_id +' .pg_close').attr('onclick','update_sdi_refresh("'+ unique_parent_id +'", $(this))');
	
	//Setting Id & name for UM Drivers file input's
	$(unique_parent_id +' .ump_content .ump_file').attr('id', 'umu_file'+ip_id ).attr('name','umu_file'+ip_id);
	
	//Get the ostype
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	$(unique_parent_id +' .ostype_input').val(ostype);
	$(loader_selector).hide();
}

function update_sdi_trigger_fileinput(unique_parent_id, element){
	$(element).removeClass('error');
	$(unique_parent_id+' .ump_file').trigger("click");
}

function update_sdi_display_filepath(unique_parent_id, element){
	$(unique_parent_id+' .ump_text').val($(element).val());
}

function update_sdi_install(unique_parent_id, ip, ip_id){
	var success = true;
	var drtype = '&drType=um';
	var driver_type = '&driver_type=um';
	//Linux and Freebsd
	if ($(unique_parent_id + ' .ostype_input').val() == '2' || $(unique_parent_id + ' .ostype_input').val() == '4' ) {
			if( $.trim($(unique_parent_id + ' .ump_content .ump_file').val()) == '' ){
				$(unique_parent_id + ' .ump_content .ump_text').addClass('error');
				success = false;
			}
			else{
				success = update_validation_file(unique_parent_id, $(unique_parent_id + ' .ump_content .ump_text'), $(unique_parent_id + ' .ostype_input').val());
			}
			if (success) {
				var file_id = $(unique_parent_id + ' .ump_content .ump_file').attr('id');
				$('.dummy').chLightbox('confirm', {
					cnfmTitle: 'Driver Installation',
		            cnfmMsg: UM_MSG,
		            cnfmOk: 'Yes',
					cnfmCancel: 'No',
					successfn:"update_sdi_upload_driver(\""+unique_parent_id+"\", \""+file_id+"\", \""+ip+"\", \""+drtype+"\", \""+driver_type+"\", 'single');",
		            lbWidth: 420,
		            top_extra: 50
				});
			}
			else{
				return false;
			}
	}
	//windows
	else if($(unique_parent_id + ' .ostype_input').val() == '1') {
			var success = true;
			var drtype = '&drType=um';
			var driver_type = '&driver_type=um';
			if( $.trim($(unique_parent_id + ' .ump_content .ump_file').val()) == '' ){
				$(unique_parent_id + ' .ump_content .ump_text').addClass('error');
				success = false;
			}
			else{
				success = update_validation_file(unique_parent_id, $(unique_parent_id + ' .ump_content .ump_text'), $(unique_parent_id + ' .ostype_input').val());
			}
			
			if (success) {
				var file_id = $(unique_parent_id + ' .ump_content .ump_file').attr('id');
				$('.dummy').chLightbox('confirm', {
					cnfmTitle: 'Driver Installation',
		            cnfmMsg: UM_MSG,
		            cnfmOk: 'Yes',
					cnfmCancel: 'No',
					successfn:"update_sdi_upload_driver(\""+unique_parent_id+"\", \""+file_id+"\", \""+ip+"\", \""+drtype+"\", \""+driver_type+"\", 'single');",
		            lbWidth: 420,
		            top_extra: 50
				});
				//sdi_upload_driver(unique_parent_id, file_id, ip, drtype, driver_type, 'single');
			}
			else{
				return false;
			}
	}
}

function update_sdi_upload_driver(unique_parent_id, file_id, ip, drtype, driver_type, upload_count){
	$('.dummy').chLightbox('destroy');
	var sid = GetCookie("chelsio_webgui_sid");
	var user = GetCookie("chelsio_webgui_user");
	var ip_id = replace_with(ip, '.', '_');
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	var getdata = '?sid='+sid+'&ip='+ip+'&file_id='+file_id+'&cardtype='+$(unique_parent_id+' .cardtype').val()+drtype+'&user='+user+driver_type;
	getdata += '&call_granted=yes&first_path='+$(unique_parent_id +' .chelsio_content .path').val()+'&upload_count='+upload_count+'&ostype='+ostype;
	$(unique_parent_id +' .sdi_loader').hide();
	
	if( upload_count != 'multiple' ){
		show_progressbar(unique_parent_id,0);		
	}

	jQuery.ajaxFileUpload({
		url: 'python/install_drivers.py'+getdata,
		secureuri: true,
		fileElementId: file_id,
		dataType: 'xml',
		success: function(xml){
			var status = String($.trim($('status', xml).text()));
			if (status == '-2') {
				$(unique_parent_id+' .progressbass-wr').hide();
				show_redirect_alert();
			}
			else if(status == '0') {
				progress_complete(unique_parent_id);
				//Remove the system if its "UM" installation
				if( drtype == '&drType=um' ){
					remove_system();
				}
			}
			else {
				//Clearing settimeout
				for( key in progress_timeOuts ){  
			    	clearTimeout(progress_timeOuts[key]);  
			   	}
				$(unique_parent_id+' .progressbass-wr').hide();
				$(unique_parent_id +' .global_error').show();
				display_failed(unique_parent_id);
			}
		}
	});
}

function update_sdi_discard(unique_parent_id){
	$(unique_parent_id + ' .cardtype').val('0');
	$(unique_parent_id + ' .ump_content .ump_file').val('');
	$(unique_parent_id + ' .ump_content .ump_text').val('').removeClass('error');
}

function update_validation_file(unique_parent_id, element, ostype){
	if( ostype == '1' ){
		var ext = element.val().toLowerCase().split('.exe');
	}
	else if (ostype == '2' || ostype == '3' || ostype == '4') {
		var ext = element.val().toLowerCase().split('.tar.gz');
	}
	else if( ostype == '5' ){
		var ext = element.val().toLowerCase().split('.iso');
	}
	else if( ostype == '6' ){
		var ext = element.val().toLowerCase().split('.dmg');
	}
	
	if(ext.length < 2){
		$(element).addClass('error');
		show_error_msg(unique_parent_id, 'Unsupported file type');
		return false;
	}
	else{
		return true;		
	}
	return false;
}

function update_sdi_refresh(unique_parent_id, element){
	$(element).parent().hide();
	$(element).parent().parent().parent().fadeOut(300);
	$('.dummy').chLightbox('alert', {
		alertTitle: 'Refresh',
		alertMsg: 'The system will be refreshed to complete the driver installation.',
		alertOk: 'OK',
		successfn: 'invoke_refresh()',
		lbWidth: 420,
		top_extra: 50
	});
}
