function fill_linux_kvm_conf(ip_id){
	var unique_parent_id = '#system_content__incend__'+ ip_id+' .system_linux_kvm_conf_tab';
	
	if( $(unique_parent_id+' .vm_div_wr ul').length ){
		return
	}
	
	$(unique_parent_id+' .initializer').show();
	var ip = replace_with(ip_id,'_','.');
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid='+sid+'&ip='+ip;
	
	$(unique_parent_id + ' .refresh a').attr('onclick', '$("' + unique_parent_id + ' .vm_div_wr").html("");fill_linux_kvm_conf("' + ip_id + '")');
	$(unique_parent_id + ' .btn_wraper').attr('onclick','lin_perform_vm_operation("'+ unique_parent_id +'", "'+ getdata +'", $(this), "'+ ip_id +'")');
	load_lin_vms(unique_parent_id, getdata);
}

function load_lin_vms(unique_parent_id, getdata){
	getdata += '&action=get'
	$.ajax({
		url: '/python/lin_kvm_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(html){
			$(unique_parent_id+' .initializer').hide();
			if (html == '-2') {
				show_redirect_alert();
			}
			else if (html != '-1') {
				$(unique_parent_id+' .vm_div_wr').html(html);
			}
		}
	});	
}

function display_lin_conf_data(unique_parent_id, element){
	
	if( $(element).hasClass('selected') ){
		$(element).removeClass('selected');		
	}
	else{
		$(element).addClass('selected');
		$(unique_parent_id + ' .vm_btn_wr button').removeClass('disabled').addClass('blue').removeAttr('disabled');
	}
	
	var len = $(unique_parent_id+' .vm_div_wr .selected').length ;
	if (len == 1) {
		$(unique_parent_id + ' .vm_multiple_wr').hide();
		$(unique_parent_id + ' .vm_single_wr').fadeIn(300);
		$(unique_parent_id + ' .vm_single_wr .uuid').html($(unique_parent_id + ' .vm_ul li.selected').children('.uuid').val());
		$(unique_parent_id + ' .vm_single_wr .domain_state').html($(unique_parent_id + ' .vm_ul li.selected').children('.domain_state').val());
	}
	else if(len == 0) {
		lin_kvm_conf_make_default(unique_parent_id);
	}
	else{
		$(unique_parent_id + ' .vm_single_wr').hide();
		$(unique_parent_id + ' .vm_multiple_wr').fadeIn(300);
		
		var html_content = '';
		$(unique_parent_id+' .vm_div_wr .selected').each(function(i){
			var class_str = 'class="clear_left"';
			if(!i){
				class_str = '';
			}
			
			var vm_name = 'Virtual Machine '+ (i+1);
			var ps = $(this).children('.domain_state').val();
			html_content += '<dl '+ class_str +'>\
				                <dt>\
				                    <label class="f_normal">\
				                        '+ vm_name +':\
				                    </label>\
				                </dt>\
				                <dd>'+ ps +'</dd>\
				            </dl>'
		});
		$(unique_parent_id + ' .vm_multiple_wr .vm_mul_content').html(html_content);
	}
}

function lin_kvm_conf_make_default(unique_parent_id){
	$(unique_parent_id+' .vm_multiple_wr').hide();
	$(unique_parent_id+' .vm_single_wr').fadeIn(300);
	$(unique_parent_id+' .vm_single_wr .uuid').html('&nbsp;');
	$(unique_parent_id+' .vm_single_wr .domain_state').html('&nbsp;');
	$(unique_parent_id + ' .vm_multiple_wr .vm_mul_content').html('');
	$(unique_parent_id + ' .vm_btn_wr button').addClass('disabled').removeClass('blue').attr('disabled','disabled');
}

function lin_perform_vm_operation(unique_parent_id, getdata, element, ip_id){
	var vm_uid = '';
	$(unique_parent_id+' .initializer').show();
	$(unique_parent_id+' .vm_div_wr .selected').each(function(){
			vm_uid += ','+ $(this).children('.uuid').val()+','	
	});
	
	getdata += '&action=operation&vm_uid='+vm_uid+'&operation='+element.attr('name');
	$.ajax({
		url: '/python/lin_kvm_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(status){
			$(unique_parent_id+' .initializer').hide();
			if (status == '-2') {
				show_redirect_alert();
			}
			else if (status == '0') {
				lin_kvm_conf_make_default(unique_parent_id);
				$(unique_parent_id+' .vm_div_wr').html('');
				fill_linux_kvm_conf(ip_id);
				display_success(unique_parent_id);
			}
			else{
				display_failed(unique_parent_id);
			}
		}
	});		
}