function fill_lin_kvm_conf(ip_id){
	var unique_parent_id = '#system_content__incend__'+ ip_id + ' .system_lin_kvm_conf_tab';
	var ip = replace_with(ip_id,'_','.');
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid='+sid+'&ip='+ip+'&type=desktop';
	
	var kvm_status = $.trim($('#ip_' + ip_id + ' .selected').children('.kvm_status').val());
	if( kvm_status == 'yes' ){
		$(unique_parent_id+' .kvm_status').html('Enabled').addClass('green_f');
		$(unique_parent_id+' .enable_wr button').removeClass('yellow').addClass('disabled').attr('disabled','disabled');
	}
	else{
		$(unique_parent_id+' .kvm_status').html('Disabled').addClass('red_f');
		$(unique_parent_id+' .disable_wr button').removeClass('yellow').addClass('disabled').attr('disabled','disabled');
	}
	
	$(unique_parent_id + ' .refresh a').attr('onclick', 'fill_lin_kvm_conf("' + ip_id + '")');
	$(unique_parent_id + ' .enable_wr').attr('onclick', 'lin_kvm_action_confirm("'+unique_parent_id+'", "' + getdata + '", "enable")');
	$(unique_parent_id + ' .disable_wr').attr('onclick', 'lin_kvm_action_confirm("'+unique_parent_id+'", "' + getdata + '", "disable")');
}

function lin_kvm_action_confirm(unique_parent_id, getdata, action){
	$('.dummy').chLightbox('confirm', {
		cnfmTitle: action.charAt(0).toUpperCase() + action.slice(1) +' KVM',
        cnfmMsg: 'The system will be refreshed on successful completion of this request. Are you sure you want to proceed?',
        cnfmOk: 'Yes',
		cnfmCancel: 'No',
		successfn:'lin_kvm_action("'+unique_parent_id+'", "' + getdata + '", "' + action + '")',
        lbWidth: 420,
        top_extra: 50
	});
}

function lin_kvm_action(unique_parent_id, getdata, action){
	$('.dummy').chLightbox('destroy');
	if(action == 'enable') {
		$(unique_parent_id).animate({
			'height' : '180px'
		},300);
		lin_kvm_enable_popup(unique_parent_id, getdata);
		return
	}
	else if(action == 'vf') {
		var vf_str = $(unique_parent_id+ ' .vf_port1').val()+','+$(unique_parent_id+ ' .vf_port2').val()+','+$(unique_parent_id+ ' .vf_port3').val()+','+$(unique_parent_id+ ' .vf_port4').val();
		getdata += '&action=enable&vf_str='+vf_str;
	}
	else if(action == 'disable') {
		getdata += '&action=disable';
	}
	else{
		return
	}
	
	$(unique_parent_id+' .overlay_disp_wr').html('');
	$(unique_parent_id + ' .initializer').show();
	$.ajax({
		url: '/python/linux_kvm_conf.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id + ' .initializer').hide();
			
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data == '64') {
				show_error_msg(unique_parent_id, 'KVM cannot be enabled since t4_tom is loaded.');
			}
			else if (data == '-1') {
					display_failed(unique_parent_id);
			}
			else {
				invoke_refresh();
			}
		}
	});
}

function lin_kvm_enable_popup(unique_parent_id, getdata){
	$('.dummy').chLightbox('destroy');
	var html = '<div>\
					<div class="center">\
						<p class="f_bold">Add Virtual Function\'s</p>\
						<p class="f_bold pdn_b10">( Number of VFs per port = 0-64 )</p>\
					</div>\
					<ul class="horizontal vf_port_ul">\
						<li class="pdn_115"><input type="text" class="text vf_port1" onkeyup="$(this).removeClass(\'error\')" /></li>\
						<li><input type="text" class="text vf_port2" onkeyup="$(this).removeClass(\'error\')" /></li>\
						<li><input type="text" class="text vf_port3" onkeyup="$(this).removeClass(\'error\')" /></li>\
						<li class="pdn_r0"><input type="text" class="text vf_port4" onkeyup="$(this).removeClass(\'error\')" /></li>\
					</ul>\
					<div class="btn_wraper rect_btn_wrapper clear_left" onclick="lin_kvm_action(\''+unique_parent_id+'\', \''+getdata+'\', \'vf\')">\
					    <button class="btn yellow" type="submit">\
					        <strong>OK</strong>\
					    </button>\
					</div>\
				</div>'
	show_error_msg(unique_parent_id, html);
}