function initialize_sl(ip_id){
	var unique_parent_id = '#system_content__incend__' + ip_id+' .system_licensing_tab';
	var loader_selector = '#system_content__incend__'+ ip_id +' .system_licensing_tab .initializer';
	ip = replace_with(ip_id,'_','.');
	var username = GetCookie("chelsio_webgui_user");
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid='+sid+'&ip='+ip+'&user='+username;
	var is_licensed = false;
	
	$(loader_selector+' .init_loader span').html('Loading..');
	$(loader_selector).show();
	
	//Fill Cards
	var card_option = '<select class="sl_card" onchange="sl_card_change(\''+ unique_parent_id +'\', $(this))"><option value="none" >Select One..</option>';
	$('#ip_'+ip_id+' .tree_cardname').each(function(i){
		card_option += '<option value="'+i+'">'+ $.trim($(this).html()) +'</option>'
	});
	card_option += '</select>';
	$('#sl_card_span').html(card_option);
	
	//Generate file input id
	var fileid =  'sl_file_input_'+ip_id;
	$(unique_parent_id +' .sl_file_input').attr('id', fileid);
	
	$(unique_parent_id +' .sl_file_input').attr('onchange','sl_file_input_change("'+ unique_parent_id +'", $(this))');
	$(unique_parent_id +' .sl_file_text_input').attr('onclick','$(\''+ unique_parent_id +' .sl_file_input\' ).trigger(\'click\');');
	$(unique_parent_id +' .sl_card_button button').attr('onclick','download_card_info("'+ unique_parent_id +'", "'+ getdata +'")');
	$(unique_parent_id +' .sl_card_key_upload button').attr('onclick','upload_key("'+ unique_parent_id +'", "'+ getdata +'", "'+ fileid +'")');
	
	//Check is licensed
	if($(unique_parent_id + ' .sys_sum_main #sys_sum_islicense').length){
		if( $.trim($(unique_parent_id + ' .sys_sum_main #sys_sum_islicense').html()) == 'Present' ){
			display_card_info_grid(getdata,unique_parent_id,loader_selector);
		}
	}
	else{
		$.ajax({
			url: '/python/py_get_sys_summary.py',
			type: 'GET',
			cache: false,
			data: getdata,
			success: function(xml){
				if (xml == '-2') {
					$(loader_selector).hide();
					show_redirect_alert();
				}
				else if (xml == '-1') {
					$(loader_selector).hide();
					show_error_msg(unique_parent_id, 'Could not retrieve License Information');
				}
				else {
					display_card_info_grid(getdata,unique_parent_id,loader_selector);
				}
			}	
		});
	}
	
}

function download_card_info(unique_parent_id, getdata){
	
	if( !$(unique_parent_id +' .sl_card_button button').hasClass('blue') ){
		return
	}
	
	$(unique_parent_id+' .sl_card_button').hide();
	$(unique_parent_id+' .sl_card_info_main .sl_downloading_status').show();
	$(unique_parent_id+' .sl_card').attr('disabled','disabled');
	var index = $(unique_parent_id+' .sl_card').val();
	getdata += '&index='+index;
	
	$.get('/python/get_system_infofile.py?action=copy&'+getdata, function(status) {
		$(unique_parent_id+' .sl_card').removeAttr('disabled');
		$(unique_parent_id+' .sl_card_info_main .sl_downloading_status').hide();
		$(unique_parent_id+' .sl_card_button').show();
		if( status == '0' ){
			window.location.href = '/python/get_system_infofile.py?action=download&'+getdata;		
		}
		else if( status == '-2' ){
			show_redirect_alert();
		}
		else if( status == '-1' ){
			show_error_msg(unique_parent_id, 'Failed to retrieve chinfofile');
		}
		
	});
}

function display_card_info_grid(getdata,unique_parent_id,loader_selector){
	//Retrieve Card info
	if ($.trim($(unique_parent_id+' .sl_lc_device').html()) == 'retrieving...' || $.trim($(unique_parent_id+' .sl_lc_device').html()) == 'Failed') {
		$.ajax({
			url: '/python/get_card_info.py',
			type: 'GET',
			cache: false,
			data: getdata,
			success: function(xml){
				$(loader_selector).hide();
				if (xml == '-2') {
					show_redirect_alert();
				}
				else if (xml != '-1') {
					$(unique_parent_id + ' .sl_lc_inst').html($.trim($('licinstalled', xml).text()) + '&nbsp;');
					$(unique_parent_id + ' .sl_lc_device').html($.trim($('licdevice', xml).text()) + '&nbsp;');
					$(unique_parent_id + ' .sl_lc_device_serial').html($.trim($('serialnum', xml).text()) + '&nbsp;');
					$(unique_parent_id + ' .sl_lc_to').html($.trim($('licto', xml).text()) + '&nbsp;');
					$(unique_parent_id).css('height','342px');
					$(unique_parent_id + ' .sl_card_info').fadeIn(300);
				}
				else {
					$(unique_parent_id + '.sl_card_info .bg_none').html('Failed');
					show_error_msg(unique_parent_id, 'Failed to retrieve Card Informations.');
				}
			}
		});
	}
	else {
		$(loader_selector).hide();
		$(unique_parent_id).css('height','342px');
		$(unique_parent_id + ' .sl_card_info').fadeIn(300);
	}
}

function upload_key(unique_parent_id, getdata, fileid){
	
	if( $.trim($(unique_parent_id+' .sl_file_text_input').val()).search(/.key/) == -1  ){
		$(unique_parent_id+' .sl_file_text_input').addClass('error');
		$(unique_parent_id+' .sl_file_text_input').val('');
		$(unique_parent_id+' .sl_file_input').val('');
		return false;
	}
		
	$(unique_parent_id+' .sl_card_key_upload').hide();
	$(unique_parent_id+' .sl_card_key_main .sl_downloading_status').show();
	
	jQuery.ajaxFileUpload({
		url: 'python/upload_license_key.py?'+getdata,
		secureuri: true,
		fileElementId: fileid,
		dataType: 'xml',
		success: function(xml){
			var status = $.trim($('status', xml).text());
			$(unique_parent_id+' .sl_card_key_main .sl_downloading_status').hide();
			$(unique_parent_id+' .sl_card_key_upload').show();
			if (status == '-2') {
				show_redirect_alert();
			}
			else if(status == '0'){
				$('.dummy').chLightbox('alert', {
					alertTitle: 'Success!',
					alertMsg: 'Successfully Installed the license Key . Click "Ok" to make the required changes.',
					alertOk: 'OK',
					successfn:'refresh_system("'+ ip +'")',
					lbWidth: 420,
					top_extra: 50
				});
			}
			else{
				show_error_msg(unique_parent_id, 'Invalid License Key.');
			}	
		}
	});
}

function sl_card_change(unique_parent_id, element){
	$(unique_parent_id+' .sl_card').removeClass('error');
	if( $(element).val() != 'none' ){
		$(unique_parent_id+' .sl_card_button button').removeAttr('class').addClass('btn blue');
	}
	else{
		$(unique_parent_id+' .sl_card_button button').removeAttr('class').addClass('btn disabled');
	}
}

function sl_file_input_change(unique_parent_id, element){
	if( $.trim($(element).val()) != ''  ){
		if( $.trim($(element).val()).search(/.key/) == -1  ){
			$(unique_parent_id+' .sl_file_text_input').addClass('error');
			$(unique_parent_id+' .sl_file_text_input').val('');
			$(unique_parent_id+' .sl_file_input').val('');
		}
		else{
			$(unique_parent_id+' .sl_file_text_input').removeClass('error');
			$(unique_parent_id+' .sl_file_text_input').val($(element).val());
			$(unique_parent_id+' .sl_card_key_upload button').removeAttr('class').addClass('btn blue');				
		}
	}
	else{
		$(unique_parent_id+' .sl_card_key_upload button').removeAttr('class').addClass('btn disabled');
	}
}
