var UM_MSG = 'On successful installation of the UM Update, the connection with the machine will be lost and it will be disconnected. You have to reconnect it manually for further use.<div class="f_bold mgn_t10"> Are you sure you want to proceed with installation?</div>'; 
var FREEBSD_ALERT = 'FreeBSD driver installation may take an hour or so to complete. <div class="f_bold mgn_t10"> Are you sure you want to proceed with installation?</div>';
function initialize_system_driver_install(ip_id){
	var unique_parent_id = '#system_content__incend__'+ ip_id+' .system_drivers_install_tab';
	$(unique_parent_id+' .initializer').hide();
	var ip = replace_with(ip_id, '_', '.');
	var loader_selector = unique_parent_id + ' .sdi_loader';
	if( $(unique_parent_id +' .sdi_loader').css('display') == 'block' || $.trim($(unique_parent_id +' .ostype_input').val()) != '' ){
		return
	}
	$(loader_selector).show();
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	
	//initializing
	$(unique_parent_id +' .tab_head li').attr('onclick','sdi_toggle_tab("'+ unique_parent_id +'",$(this))');
	$(unique_parent_id +' input[type=checkbox]').attr('onclick','sdi_chkbox_manipulation("'+ unique_parent_id +'",$(this))');
	//$(unique_parent_id +' .global_error .status_link').attr('onclick','$("'+unique_parent_id +' .global_error").hide();initialize_system_driver_install("'+ ip_id +'")');
	$(unique_parent_id +' .file_text').attr('onclick','sdi_trigger_fileinput("'+ unique_parent_id +'",$(this))');
	$(unique_parent_id +' .sl_file_input').attr('onchange','sdi_display_filepath("'+ unique_parent_id +'",$(this))');
	$(unique_parent_id +' .dr_ofed_pkg_type').attr('onchange','sdi_ofed_packge_type("'+ unique_parent_id +'",$(this))');
	$(unique_parent_id +' .install_wr').attr('onclick','sdi_install("'+ unique_parent_id +'","'+ ip +'","'+ ip_id +'")');
	$(unique_parent_id +' .discard_wr').attr('onclick','sdi_discard("'+ unique_parent_id +'")');
	
	/*
	//no need to refresh the system for a freebsd agent
	if (ostype == '4') {
		$(unique_parent_id + ' .pg_close').attr('onclick', '$("'+unique_parent_id+' .progressbass-wr").hide()');
	}
	else{
		$(unique_parent_id + ' .pg_close').attr('onclick', 'sdi_refresh("' + unique_parent_id + '", $(this))');
	}*/
	$(unique_parent_id + ' .pg_close').attr('onclick', 'sdi_refresh("' + unique_parent_id + '", $(this))');
	
	$(unique_parent_id +' .cardtype').attr('onchange','$("'+unique_parent_id + ' .chelsio_content input[type=checkbox]").removeAttr("checked");sdi_card_change("'+ unique_parent_id +'",$(this));');
	$(unique_parent_id +' .conftype').attr('onchange','sdi_confchange("'+ unique_parent_id +'", $(this))');
	
	//Setting Id for Chelsio Drivers file input's
	$(unique_parent_id +' .cxb3_file').attr('id', 'sdi_cxb3_file'+ip_id ).attr('name','sdi_cxb3_file'+ip_id);
	$(unique_parent_id +' .windows_file').attr('id', 'sdi_windows_file'+ip_id ).attr('name','sdi_windows_file'+ip_id);
	$(unique_parent_id +' .iscsi_file').attr('id', 'sdi_iscsi_file'+ip_id ).attr('name','sdi_iscsi_file'+ip_id);
	$(unique_parent_id +' .multiport_file').attr('id', 'sdi_multiport_file'+ip_id ).attr('name','sdi_multiport_file'+ip_id);
	
	//Setting Id for ofed Drivers file input's
	$(unique_parent_id +' .odt_file').attr('id', 'sdi_odt_file'+ip_id ).attr('name','sdi_odt_file'+ip_id);
	$(unique_parent_id +' .ocfp_file').attr('id', 'sdi_ocfp_file'+ip_id ).attr('name','sdi_ocfp_file'+ip_id);
	
	//Setting Id for ofed Drivers file input's
	//$(unique_parent_id +' .ump_content .ump_file').attr('id', 'sdi_ump_file'+ip_id ).attr('name','sdi_ump_file'+ip_id);
	
	//Get the ostype
	$(loader_selector).hide();
	$(unique_parent_id +' .ostype_input').val(ostype);
	sdi_os_manipulation(unique_parent_id, ostype, ip_id);				
}

function sdi_toggle_tab(unique_parent_id,element){
	if( $(element).hasClass('selected') ){
		return
	}
	var os_type = $(unique_parent_id +' .ostype_input').val();
	$(unique_parent_id+' .tab_head li').removeClass('selected');	
	$(element).addClass('selected');
	
	if($(element).hasClass('chelsio')){
		var tab_content = '.chelsio_content';
		height = '310px';
		if(os_type == '2'){
			var height = '330px';
			if( $(unique_parent_id+ ' .cardtype').val() == '1' ){
				height = '780px';
			}
			else{
				height = '330px';
			}
		}
		else if( os_type == '1' ){
			if( $(unique_parent_id+ ' .cardtype').val() == '1' ){
				height = '354px';
			}
			else{
				height = '347px';
			}
		}
		else if(os_type == '3' || os_type == '6' ){
			var height = '240px';
		}
		$(unique_parent_id).animate({
				'height':height
		},300);
	}
	else if($(element).hasClass('ofed')){
		var tab_content = '.ofed_content';
		$(unique_parent_id).animate({
				'height':'305px'
		},300);
	}
	else if($(element).hasClass('ump')){
		var tab_content = '.ump_content';
		$(unique_parent_id).animate({
				'height':'220px'
		},300);
	}
	else{
		return
	}
	$(unique_parent_id+' .tab_content,'+unique_parent_id+' .btn_wr').hide();
	$(unique_parent_id+' '+tab_content+','+unique_parent_id+' .btn_wr').fadeIn(300);
}

function sdi_os_manipulation(unique_parent_id, ostype, ip_id){
	$(unique_parent_id+ ' .os_specific').hide();
	$(unique_parent_id+ ' .os_'+ostype).show();
	//By default hide t4 data
	if (ostype == '1') {
		//windows
		$(unique_parent_id+ ' .win_t4').hide();
		$(unique_parent_id+ ' .win_t3').show();
		//$(unique_parent_id+' .ump').show();
		$(unique_parent_id+' .chelsio').css('width','250px');
		//$(unique_parent_id+' .ump').css('width','250px');
		$(unique_parent_id).animate({
			'height': '347px'
		}, 300);
		
		var osname = $.trim($('#ip_' + ip_id + ' .system_link').children('.osname').val());
		var is_two_eight_r2 = osname.search("2008 R2");
		if( is_two_eight_r2 == -1 ){
			$(unique_parent_id+' .team_win_li').remove();
		}
		
	}
	else if (ostype == '2') {
		//linux
		$(unique_parent_id+ ' .lin_t4').hide();
		$(unique_parent_id+ ' .lin_t3').show();
		$(unique_parent_id).animate({
			'height': '330px'
		}, 300);
		$(unique_parent_id+' .ofed').show();
		//$(unique_parent_id+' .ump').show();
	}
	else if(ostype == '3' || ostype == '6' ){
		//solaris and mac
		$(unique_parent_id).animate({
			'height': '265px'
		}, 300);
		$(unique_parent_id + ' .cxgb3_name').html('T3');
	}
	else if(ostype == '5' ){
		//esx
		$(unique_parent_id).animate({
			'height': '252px'
		}, 300);
	}
	else if(ostype == '4' ){
		//Freebsd
		$(unique_parent_id+' .os_4').show();
		$(unique_parent_id+' .nic_div_wr').hide();
		$(unique_parent_id+' .cardtype').val('1').attr('disabled','disabled');
		$(unique_parent_id + ' .cxgb3_name').html('T4');
		$(unique_parent_id).animate({
			'height': '225px'
		}, 300);
		enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
	}	
	else if(ostype == '8' ){
		//Xen
		$(unique_parent_id+' .os_8').show();
		$(unique_parent_id+' .nic_div_wr').hide();
		$(unique_parent_id).animate({
			'height': '265px'
		}, 300);
		enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
		
	}		
	else{
		$(unique_parent_id+' .chelsio').css('width','250px');
		//$(unique_parent_id+' .ump').css('width','250px')
	}
	
	if( $(unique_parent_id+' .cardtype').val() == '0' ){
		$(unique_parent_id+' .fcoe_ul').hide();	
	}
}

function sdi_chkbox_manipulation(unique_parent_id, element){
	//Only for chelsio drivers
	var ostype = $(unique_parent_id +' .ostype_input').val();
	$(unique_parent_id + ' .chelsio_content .file_text').removeClass('error');
	
	//T4 card
	if( $(unique_parent_id+' .cardtype').val() == '1' ){
		//To allow checkboxes to be unchecked for linux otherwise it wont allow user to uncheck

		
		if (ostype != '2') {
			sdi_card_change(unique_parent_id, $(unique_parent_id + ' .cardtype'));
		}
		if (ostype == '2') {
			
			var conftype = $(unique_parent_id+' .conftype').val()
			if(element.val() == 'wdtoe'){
				//disable everything and show only wdtoe_install, and .wdtoe_support
				if($(unique_parent_id+' .t4conftype_'+conftype+' .wdtoe').is(':checked')){
					$(unique_parent_id+' .t4conftype_'+conftype).show();
					$(unique_parent_id+' .t4conftype_'+conftype+' input[type=checkbox]').removeAttr('checked');
					$(unique_parent_id+' .t4conftype_'+conftype+'.wdtoe_support'+' input[type=checkbox]').attr('checked','checked');
				}else{
					$(unique_parent_id+' .t4conftype_'+conftype+'.wdtoe_support'+' input[type=checkbox]').removeAttr('checked');
				}
				
			}else if(element.val() == 'wdudp'){
				//disable everything and show only wdtoe_wdudp_install, and .wdtoe_wdudp_support
				if($(unique_parent_id+' .t4conftype_'+conftype+' .wdudp').is(':checked')){
					$(unique_parent_id+' .t4conftype_'+conftype).show();
					$(unique_parent_id+' .t4conftype_'+conftype+' input[type=checkbox]').removeAttr('checked');
					$(unique_parent_id+' .t4conftype_'+conftype +'.wdtoeudp_support' + ' input[type=checkbox]').attr('checked','checked');
				}else{
					$(unique_parent_id+' .t4conftype_'+conftype +'.wdtoeudp_support' + ' input[type=checkbox]').removeAttr('checked');
				}
				
			}else if(element.val() == 'bypass'){
				if($(unique_parent_id+' .t4conftype_'+conftype +' .bypass').is(':checked')){
					$(unique_parent_id+' .t4conftype_'+conftype).show();
					$(unique_parent_id+' .t4conftype_'+conftype+' input[type=checkbox]').removeAttr('checked');
					$(unique_parent_id+' .t4conftype_'+conftype +'.bypass_support' + ' input[type=checkbox]').attr('checked','checked');
				}else{
					$(unique_parent_id+' .t4conftype_'+conftype +'.bypass_support' + ' input[type=checkbox]').removeAttr('checked');
				}
			}else if($(element).hasClass('wdudp_optional') || ($(element).hasClass('wdtoe_optional'))){
				//pass
			}else {
				$(unique_parent_id+' .t4conftype_'+conftype+'_no_default'+' input[type=checkbox]').removeAttr('checked');
			}
		}
		//solaris
		if (ostype == '3') {
			if ($(unique_parent_id + ' .nic').is(':checked')) {
				enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
			}
			else {
				enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
			}
		}
		//windows
		else if (ostype == '1') {
			if ($(unique_parent_id + ' .win_t4_chk').is(':checked')) {
				enable_disable(unique_parent_id, 'enable', '.windowsdriver_file_li_wr');
			}
			else {
				enable_disable(unique_parent_id, 'disable', '.windowsdriver_file_li_wr');
			}
			
			//If any one of the widn_t4_pair_* chk is checked then uncheck the other pair chk
			if ( $(element).is(':checked') && $(element).hasClass('wind_t4_pair_1') ) {
				$(unique_parent_id+' .vnic,'+unique_parent_id+' .nd').removeAttr('checked');
			}
			else if ( $(element).is(':checked') && $(element).hasClass('vnic') ) {
				$(unique_parent_id+' .wind_t4_pair_1,'+unique_parent_id+' .nd').removeAttr('checked');
			}
			else if ( $(element).is(':checked') && $(element).hasClass('nd') ) {
				$(unique_parent_id+' .wind_t4_pair_1,'+unique_parent_id+' .vnic').removeAttr('checked');
			}
		}
		//Freebsd
		else if (ostype == '4') {
			if ($(unique_parent_id + ' .toe').is(':checked')) {
				$(unique_parent_id+' .nic').attr('checked','checked');
				enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
				return
			}
			
			if ($(unique_parent_id + ' .os_4_chk').is(':checked')) {
				enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
			}
			else{
				enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
			}
		}
		//esx
		else if (ostype == '5') {
			if( $(element).is(':checked') && $(element).hasClass('nic') ){
				enable_disable(unique_parent_id, 'enable', '.multiport_file_li_wr');
			}
			else{
				enable_disable(unique_parent_id, 'disable', '.multiport_file_li_wr');
			}
		}
		else if (ostype == '6') {
			if( $(element).is(':checked') && $(element).hasClass('nic') ){
				enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
			}
			else{
				enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
			}
		}
		else if (ostype == '8') {
			if( $(element).is(':checked') && $(element).hasClass('nic') ){
				enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
			}
			else{
				enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
			}
		}
		return 
	}
	
	//T3
	if( ostype == '1' ){
		if( $(unique_parent_id+ ' input[type=checkbox]').is(':checked') ){
			enable_disable(unique_parent_id, 'enable', '.windowsdriver_file_li_wr');						
		}
		else{
			enable_disable(unique_parent_id, 'disable', '.windowsdriver_file_li_wr');
		}
		
		/*if( $(element).hasClass('toe_chk') && $(element).is(':checked') ){
			$(unique_parent_id+' .toe_chk').attr('checked','checked');
		}*/
		return
	}
	else if( ostype == '3' || ostype == '6' ){
		if( $(unique_parent_id+ ' .nic').is(':checked') ){
			enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
		}
		else{
			enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
		}
		return
	}
	else if( ostype == '5' ){
		if( $(element).is(':checked') ){
			$(unique_parent_id+ ' .esx_input').removeAttr('checked');
			$(element).attr('checked','checked');
			enable_disable(unique_parent_id, 'enable', '.multiport_file_li_wr');
		}
		else{
			enable_disable(unique_parent_id, 'disable', '.multiport_file_li_wr');
		}
		return
	}
	
	//linux and t3
	var is_iscsi_checked = $(unique_parent_id+' input.iscsi').is(':checked');
	
	if (is_iscsi_checked) {
		enable_disable(unique_parent_id, 'enable', '.iscsi_file_li_wr');
		enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
	}
	else {
		enable_disable(unique_parent_id, 'disable', '.iscsi_file_li_wr');
	}
	
	if( !is_iscsi_checked && $(element).hasClass('iscsi') ){
		$(unique_parent_id+' input.cmn').removeAttr('checked');
		enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
		return
	}
	
	if( $(element).hasClass('cmn') && $(element).is(':checked') ){
		$(unique_parent_id+' input.cmn').removeAttr('checked');
		$(element).attr('checked','checked');
		enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
	}
	
	if ( $(element).hasClass('toe') && is_iscsi_checked && !$(element).is(':checked') ) {
		$(unique_parent_id+' input.cmn').removeAttr('checked');
		enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
		return		
	}
	
	if ( is_iscsi_checked && $(unique_parent_id+' input.cmn').is(':checked') ) {
		$(unique_parent_id+' .cmn').attr('checked','checked');
		enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
	}
	
	if ( $(element).hasClass('cmn') && !$(element).is(':checked') && !$(unique_parent_id+' .cmn').is(':checked') ) {
		enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
	}
}

function enable_disable(unique_parent_id, type, li_class){
	if( type == 'enable' ){
		$(unique_parent_id+' '+li_class+' input.text').removeAttr('disabled').removeClass('disabled');
		$(unique_parent_id+' '+li_class+' .file_input_wr').removeClass('disabled').addClass('yellow');
		$(unique_parent_id+' '+li_class+' .sl_file_input').removeAttr('disabled').addClass('file_enabled');
	}
	else{
		/*$(unique_parent_id+' '+li_class+' .iscsi_file').val('');
		$(unique_parent_id+' '+li_class+' .cxb3_file').val('');*/
		$(unique_parent_id+' '+li_class+' .iscsi_text').removeClass('error');
		$(unique_parent_id+' '+li_class+' .cxb3_text').removeClass('error');
		$(unique_parent_id+' '+li_class+' input.text').attr('disabled','disabled').addClass('disabled');
		$(unique_parent_id+' '+li_class+' .file_input_wr').addClass('disabled').removeClass('yellow');
		$(unique_parent_id+' '+li_class+' .sl_file_input').attr('disabled','disabled').removeClass('file_enabled');
	}
}

function sdi_trigger_fileinput(unique_parent_id, element){
	$(element).removeClass('error');
	if( $(element).hasClass('cxb3_text') ){
		$(unique_parent_id+' .cxb3_file').trigger("click");
	}
	else if( $(element).hasClass('windows_text') ){
		$(unique_parent_id+' .windows_file').trigger("click");
	}
	else if( $(element).hasClass('iscsi_text') ){
		$(unique_parent_id+' .iscsi_file').trigger("click");
	}
	else if( $(element).hasClass('multiport_text') ){
		$(unique_parent_id+' .multiport_file').trigger("click");
	}
	else if( $(element).hasClass('ump_text') ){
		$(unique_parent_id+' .ump_file').trigger("click");
	}
	else if( $(element).hasClass('ocfp_text') ){
		$(unique_parent_id+' .ocfp_file').trigger("click");
	}
	else if( $(element).hasClass('odt_text') ){
		$(unique_parent_id+' .odt_file').trigger("click");
	}
}

function sdi_display_filepath(unique_parent_id, element){
	if( $(element).hasClass('cxb3_file') ){
		$(unique_parent_id+' .cxb3_text').val($(element).val()); 
	}
	else if( $(element).hasClass('windows_file') ){
		$(unique_parent_id+' .windows_text').val($(element).val());
	}
	else if( $(element).hasClass('iscsi_file') ){
		$(unique_parent_id+' .iscsi_text').val($(element).val());
	}
	else if( $(element).hasClass('multiport_file') ){
		$(unique_parent_id+' .multiport_text').val($(element).val());
	}
	else if( $(element).hasClass('ump_file') ){
		$(unique_parent_id+' .ump_text').val($(element).val());
	}
	else if( $(element).hasClass('ocfp_file') ){
		$(unique_parent_id+' .ocfp_text').val($(element).val());
	}
	else if( $(element).hasClass('odt_file') ){
		$(unique_parent_id+' .odt_text').val($(element).val());
	}
}

function sdi_install(unique_parent_id, ip, ip_id){
	$(unique_parent_id +' .chelsio_content .path').val('');
	//Linux and Freebsd
	if ($(unique_parent_id + ' .ostype_input').val() == '2' || $(unique_parent_id + ' .ostype_input').val() == '4' ) {
		//Chelsio Drivers
		if ($(unique_parent_id + ' .tab_head li.selected').hasClass('chelsio')) {
			//Common for ( iscsi or iscsi and cxgb3 ) or ( cxgb3 driver alone )
			driver_type = '&driver_type=chelsio';
			var success = true;

			//iscsi or iscsi and cxgb3
			if ($(unique_parent_id + ' .chelsio_content .iscsi_file').hasClass('file_enabled')) {
				var drtype = '&drType=iscsi';
				var file_id = $(unique_parent_id + ' .chelsio_content .iscsi_file').attr('id');
				//iscsi - single driver
				if (!$(unique_parent_id + ' .chelsio_content .cmn').is(':checked')) {
					if( $.trim($(unique_parent_id + ' .chelsio_content .iscsi_text').val()) == '' ){
						$(unique_parent_id + ' .chelsio_content .iscsi_text').addClass('error');
						success = false;
					}
					else{
						success = validation_file(unique_parent_id, $(unique_parent_id + ' .chelsio_content .iscsi_text'), $(unique_parent_id + ' .ostype_input').val());
					}
					
					if (success) {
						sdi_upload_driver(unique_parent_id, file_id, ip, drtype, driver_type, 'single');
					}
				}
				//iscsi & cxgb3- multiple driver
				else {
					var cxgb3_file_id = $(unique_parent_id + ' .chelsio_content .cxb3_file').attr('id');
					var iscsi_file_id = file_id;
					var success1 = true;
					var success2 = true;
					
					if ($.trim($(unique_parent_id + ' .chelsio_content .cxb3_text').val()) == '') {
						$(unique_parent_id + ' .chelsio_content .cxb3_text').addClass('error');
						success1 = false;
					}
					else{
						success1 = validation_file(unique_parent_id, $(unique_parent_id + ' .chelsio_content .cxb3_text'), $(unique_parent_id + ' .ostype_input').val());
					}
					
					if ($.trim($(unique_parent_id + ' .chelsio_content .iscsi_text').val()) == '') {
						$(unique_parent_id + ' .chelsio_content .iscsi_text').addClass('error');
						success2 = false;
					}
					else{
						success2 = validation_file(unique_parent_id, $(unique_parent_id + ' .chelsio_content .iscsi_text'), $(unique_parent_id + ' .ostype_input').val());
					}
					
					// if all the validations are true 
					if(success1 && success2) {
						sdi_iscsi_mulitple_driver_upload(unique_parent_id, iscsi_file_id, cxgb3_file_id, ip, drtype, driver_type);
					}
				}
			}
			//Chelsio cxgb3 driver alone
			else {
				if ($(unique_parent_id + ' .cardtype').val() == '1') {
					//T4 card
					var chk_length = $(unique_parent_id + ' .chelsio_content .lin_t4 input:checked').length;
					
					if( chk_length == 0 && $(unique_parent_id + ' .ostype_input').val() == '2' ){
						show_error_msg(unique_parent_id, 'Please select atleast one driver.');
						return;
					}
					
					if (chk_length == 16){
						var drtype = '&drType=all';						
					}
					else{
						var drtype = '&drType=';
						var total_chk = chk_length - 1;
						$(unique_parent_id + ' .chelsio_content .lin_t4 input:checked').each(function(i){
							if (total_chk == i) {
								drtype += $(this).val();
							}
							else {
								drtype += $(this).val() + ',';
							}
						});
					}
					
					drtype += '&conftype='+$(unique_parent_id+' .conftype').val();
				}
				else {
					//T3 card
					var drtype = '&drType=' + $(unique_parent_id + ' .chelsio_content .cmn:checked').val();
				}
				
				if( $(unique_parent_id + ' .ostype_input').val() == '4' ){
					if( $(unique_parent_id+' .toe').is(':checked') ){
						var drtype = '&drType=nic,toe';
					}
					else{
						var drtype = '&drType=nic';
					}
				}
				
				if ( !$(unique_parent_id + ' .chelsio_content .cxb3_file_li_wr .file_input_wr').hasClass('disabled') ) {
					
					if ($.trim($(unique_parent_id + ' .chelsio_content .cxb3_text').val()) != '') {
						success = validation_file(unique_parent_id, $(unique_parent_id + ' .chelsio_content .cxb3_text'), $(unique_parent_id + ' .ostype_input').val());
					}
					
					if ($.trim($(unique_parent_id + ' .chelsio_content .cxb3_text').val()) == '') {
						$(unique_parent_id + ' .chelsio_content .cxb3_text').addClass('error');
						success = false;
					}
					//if even file type is correct
					else if(success) {
						var file_id = $(unique_parent_id + ' .chelsio_content .cxb3_file').attr('id');
						if ($(unique_parent_id + ' .ostype_input').val() == '4') {
							drtype = '&drType=all';
							$('.dummy').chLightbox('confirm', {
								cnfmTitle: 'Driver Installation',
								cnfmMsg: FREEBSD_ALERT,
								cnfmOk: 'Yes',
								cnfmCancel: 'No',
								successfn: "sdi_upload_driver(\"" + unique_parent_id + "\", \"" + file_id + "\", \"" + ip + "\", \"" + drtype + "\", \"" + driver_type + "\", 'single');",
								lbWidth: 420,
								top_extra: 50
							});
						}
						else {
							sdi_upload_driver(unique_parent_id, file_id, ip, drtype, driver_type, 'single');
						}
					}
				}
			}
			if( !success ){
				return;
			}
		}
		//OFED Drivers
		else if ($(unique_parent_id + ' .tab_head li.selected').hasClass('ofed')) {
			var success = true;
			var drtype = '&drType=ofed';
			var dr_ofed_pkg_type = $(unique_parent_id+' .dr_ofed_pkg_type').val();
			//driver_type & ofedpkg
			var driver_type = '&driver_type=ofed&ofed_pkg='+dr_ofed_pkg_type;
			if ( dr_ofed_pkg_type == 'conffile' ) {
				var success1 = true;
				var success2 = true;
				
				//multiple driver
				if( $.trim($(unique_parent_id + ' .ofed_content .odt_file').val()) == '' ){
					$(unique_parent_id + ' .ofed_content .odt_text').addClass('error');
					success1 = false;
				}
				else{
					success1 = validation_file(unique_parent_id, $(unique_parent_id + ' .ofed_content .odt_text'), $(unique_parent_id + ' .ostype_input').val());
				}
				
				if( $.trim($(unique_parent_id + ' .ofed_content .ocfp_file').val()) == '' ){
					$(unique_parent_id + ' .ofed_content .ocfp_text').addClass('error');
					success2 = false;
				}
				else{
					success2 = validation_file(unique_parent_id, $(unique_parent_id + ' .ofed_content .ocfp_text'), $(unique_parent_id + ' .ostype_input').val());
				}
				
				if( success1 && success2 ){
					var odt_file_id = $(unique_parent_id + ' .ofed_content .odt_file').attr('id');
					var ocfp_file_id = $(unique_parent_id + ' .ofed_content .ocfp_file').attr('id');
					sdi_iscsi_mulitple_driver_upload(unique_parent_id, odt_file_id, ocfp_file_id, ip, drtype, driver_type);					
				}
				else{
					return false;
				}
			}
			else{
				//single driver
				if( $.trim($(unique_parent_id + ' .ofed_content .odt_file').val()) == '' ){
					$(unique_parent_id + ' .ofed_content .odt_text').addClass('error');
					success = false;
				}
				else{
					success = validation_file(unique_parent_id, $(unique_parent_id + ' .ofed_content .odt_text'), $(unique_parent_id + ' .ostype_input').val());
				}
				
				if (success) {
					var file_id = $(unique_parent_id + ' .ofed_content .odt_file').attr('id');
					sdi_upload_driver(unique_parent_id, file_id, ip, drtype, driver_type, 'single');
				}
				else{
					return false;
				}
			}
		}
		else if ($(unique_parent_id + ' .tab_head li.selected').hasClass('ump')) {
			//single driver
			var success = true;
			var drtype = '&drType=um';
			var driver_type = '&driver_type=um';
			if( $.trim($(unique_parent_id + ' .ump_content .ump_file').val()) == '' ){
				$(unique_parent_id + ' .ump_content .ump_text').addClass('error');
				success = false;
			}
			else{
				success = validation_file(unique_parent_id, $(unique_parent_id + ' .ump_content .ump_text'), $(unique_parent_id + ' .ostype_input').val());
			}
			if (success) {
				var file_id = $(unique_parent_id + ' .ump_content .ump_file').attr('id');
				$('.dummy').chLightbox('confirm', {
					cnfmTitle: 'Driver Installation',
		            cnfmMsg: UM_MSG,
		            cnfmOk: 'Yes',
					cnfmCancel: 'No',
					successfn:"sdi_upload_driver(\""+unique_parent_id+"\", \""+file_id+"\", \""+ip+"\", \""+drtype+"\", \""+driver_type+"\", 'single');",
		            lbWidth: 420,
		            top_extra: 50
				});
				//sdi_upload_driver(unique_parent_id, file_id, ip, drtype, driver_type, 'single');
			}
			else{
				return false;
			}
		}
	}
	//windows
	else if($(unique_parent_id + ' .ostype_input').val() == '1') {
		if($(unique_parent_id + ' .tab_head li.selected').hasClass('chelsio')) {
			var return_flag = false;
			if( $.trim($(unique_parent_id + ' .chelsio_content .windows_file').val()) == '' ){
				$(unique_parent_id + ' .chelsio_content .windows_text').addClass('error');
				return_flag = true;
			}
			else{
				success = validation_file(unique_parent_id, $(unique_parent_id + ' .chelsio_content .windows_text'), $(unique_parent_id + ' .ostype_input').val());
				if(!success){
					return_flag = true;
				}
			}
			
			if(return_flag){
				return
			}
			
			var driver_type = '&driver_type=chelsio';
			var drtype_link = '&drType=';
			var drtype = '';
			//T3
			var chk_len = $(unique_parent_id + ' .chelsio_content .wind:checked').length;
			if( $(unique_parent_id+' .cardtype').val() == '0' ){
				if( chk_len == 5){
					drtype = 'all';
				}
				else{
					var total_chk = ($(unique_parent_id + ' .chelsio_content .wind:checked').length) - 1;
					$(unique_parent_id + ' .chelsio_content .wind:checked').each(function(i){
						if (total_chk == i) {
							drtype += $(this).val();
						}
						else {
							drtype += $(this).val() + ',';
						}
					});
				}
				drtype_link += drtype;
			}
			//T4
			else{
				if ($(unique_parent_id + ' .wind_t4_pair_1').is(':checked')) {
					var chk_len = $(unique_parent_id + ' .wind_t4_pair_1:checked').length;
					if (chk_len == 3) {
						drtype = 'all';
					}
					else {
						var total_chk = ($(unique_parent_id + ' .wind_t4_pair_1:checked').length) - 1;
						$(unique_parent_id + ' .wind_t4_pair_1:checked').each(function(i){
							if (total_chk == i) {
								drtype += $(this).val();
							}
							else {
								drtype += $(this).val() + ',';
							}
						});
					}
				}
				else if ($(unique_parent_id + ' .vnic').is(':checked')) {
					drtype = 'vnic';
				}
				else if ($(unique_parent_id + ' .nd').is(':checked')) {
					drtype = 'nd';
				}
				drtype_link += drtype;
			}
			
			var file_id = $(unique_parent_id + ' .chelsio_content .windows_file').attr('id');
			
			sdi_upload_driver(unique_parent_id, file_id, ip, drtype_link, driver_type, 'single');
		}
		else if ($(unique_parent_id + ' .tab_head li.selected').hasClass('ump')) {
			//single driver
			var success = true;
			var drtype = '&drType=um';
			var driver_type = '&driver_type=um';
			if( $.trim($(unique_parent_id + ' .ump_content .ump_file').val()) == '' ){
				$(unique_parent_id + ' .ump_content .ump_text').addClass('error');
				success = false;
			}
			else{
				success = validation_file(unique_parent_id, $(unique_parent_id + ' .ump_content .ump_text'), $(unique_parent_id + ' .ostype_input').val());
			}
			
			if (success) {
				var file_id = $(unique_parent_id + ' .ump_content .ump_file').attr('id');
				$('.dummy').chLightbox('confirm', {
					cnfmTitle: 'Driver Installation',
		            cnfmMsg: UM_MSG,
		            cnfmOk: 'Yes',
					cnfmCancel: 'No',
					successfn:"sdi_upload_driver(\""+unique_parent_id+"\", \""+file_id+"\", \""+ip+"\", \""+drtype+"\", \""+driver_type+"\", 'single');",
		            lbWidth: 420,
		            top_extra: 50
				});
				//sdi_upload_driver(unique_parent_id, file_id, ip, drtype, driver_type, 'single');
			}
			else{
				return false;
			}
		}
	}
	//solaris or Xen
	else if ($(unique_parent_id + ' .ostype_input').val() == '3' || $(unique_parent_id + ' .ostype_input').val() == '8') {
		if($(unique_parent_id + ' .tab_head li.selected').hasClass('chelsio')) {
			
			var return_flag = false; 
			if( $.trim($(unique_parent_id + ' .chelsio_content .cxb3_file').val()) == '' ){
				$(unique_parent_id + ' .chelsio_content .cxb3_text').addClass('error');
				return_flag = true;
			}
			else{
				success = validation_file(unique_parent_id, $(unique_parent_id + ' .chelsio_content .cxb3_text'), $(unique_parent_id + ' .ostype_input').val());
				if(!success){
					return_flag = true;
				}
			}
			
			if(return_flag){
				return;
			}
			
			var driver_type = '&driver_type=chelsio';
			//var drtype = '&drType=nic';
			var drtype = '&drType=all';
			var file_id = $(unique_parent_id + ' .chelsio_content .cxb3_file').attr('id');
			sdi_upload_driver(unique_parent_id, file_id, ip, drtype, driver_type, 'single');
		}
	}
	//esx
	else if ($(unique_parent_id + ' .ostype_input').val() == '5') {
		//For esx multiport file wr is used for both nic and multiport
		var return_flag = false;
		if ($.trim($(unique_parent_id + ' .chelsio_content .multiport_file').val()) == '') {
			$(unique_parent_id + ' .chelsio_content .multiport_text').addClass('error');
			return_flag = true;
		}
		else{
			success = validation_file(unique_parent_id, $(unique_parent_id + ' .chelsio_content .multiport_text'), $(unique_parent_id + ' .ostype_input').val());
			if(!success){
				return_flag = true;
			}
		}
		if(return_flag){
			return;
		}
		
		var drtype = '&drType=nic';
		var driver_type = '&driver_type=chelsio';
		var file_id = $(unique_parent_id + ' .chelsio_content .multiport_file').attr('id');
		sdi_upload_driver(unique_parent_id, file_id, ip, drtype, driver_type, 'single');
	}
	//mac
	else if ($(unique_parent_id + ' .ostype_input').val() == '6') {
		//only chelsio drivers
		var return_flag = false; 
		if( $.trim($(unique_parent_id + ' .chelsio_content .cxb3_file').val()) == '' ){
			$(unique_parent_id + ' .chelsio_content .cxb3_text').addClass('error');
			return_flag = true;
		}
		else{
			success = validation_file(unique_parent_id, $(unique_parent_id + ' .chelsio_content .cxb3_text'), $(unique_parent_id + ' .ostype_input').val());
			if(!success){
				return_flag = true;
			}
		}
		
		if(return_flag){
			return;
		}
		
		var driver_type = '&driver_type=chelsio';
		var drtype = '&drType=nic';
		var file_id = $(unique_parent_id + ' .chelsio_content .cxb3_file').attr('id');
		sdi_upload_driver(unique_parent_id, file_id, ip, drtype, driver_type, 'single');
	}
}

//To do - must change the arguments to a dict
function sdi_upload_driver(unique_parent_id, file_id, ip, drtype, driver_type, upload_count){
	$('.dummy').chLightbox('destroy');
	var sid = GetCookie("chelsio_webgui_sid");
	var user = GetCookie("chelsio_webgui_user");
	var ip_id = replace_with(ip, '.', '_');
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	var getdata = '?sid='+sid+'&ip='+ip+'&file_id='+file_id+'&cardtype='+$(unique_parent_id+' .cardtype').val()+drtype+'&user='+user+driver_type;
	getdata += '&call_granted=yes&first_path='+$(unique_parent_id +' .chelsio_content .path').val()+'&upload_count='+upload_count+'&ostype='+ostype;
	$(unique_parent_id +' .sdi_loader').hide();
	
	if( upload_count != 'multiple' ){
		show_progressbar(unique_parent_id,0);		
	}

	jQuery.ajaxFileUpload({
		url: 'python/install_drivers.py'+getdata,
		secureuri: true,
		fileElementId: file_id,
		dataType: 'xml',
		success: function(xml){
			var status = String($.trim($('status', xml).text()));
			if (status == '-2') {
				$(unique_parent_id+' .progressbass-wr').hide();
				show_redirect_alert();
			}
			else if(status == '4') {
				for( key in progress_timeOuts ){  
			    		clearTimeout(progress_timeOuts[key]);  
			   	}
				$(unique_parent_id+' .progressbass-wr').hide();
				show_error_msg(unique_parent_id, "Drivers already installed");
			}
			else if(status == '0') {
				progress_complete(unique_parent_id);
				//Remove the system if its "UM" installation
				if( drtype == '&drType=um' ){
					remove_system();
				}
			}
			else {
				//Clearing settimeout
				for( key in progress_timeOuts ){  
			    	clearTimeout(progress_timeOuts[key]);  
			   	}
				$(unique_parent_id+' .progressbass-wr').hide();
				$(unique_parent_id +' .global_error').show();
			}
		}
	});
}

function sdi_iscsi_mulitple_driver_upload(unique_parent_id, iscsi_file_id, cxgb3_file_id, ip, drtype, driver_type){
	var sid = GetCookie("chelsio_webgui_sid");
	var user = GetCookie("chelsio_webgui_user");
	var ip_id = replace_with(ip, '.', '_');
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	var getdata = '?sid='+sid+'&ip='+ip+'&file_id='+iscsi_file_id+'&cardtype='+$(unique_parent_id+' .cardtype').val()+drtype+'&user='+user+driver_type+'&upload_count=null&ostype='+ostype;
	getdata += '&call_granted=no&first_path=&';
	$(unique_parent_id +' .sdi_loader').hide();
	show_progressbar(unique_parent_id,0);
	jQuery.ajaxFileUpload({
		url: 'python/install_drivers.py'+getdata,
		secureuri: true,
		fileElementId: iscsi_file_id,
		dataType: 'xml',
		success: function(xml){
			var iscsi_path = $.trim($('status', xml).text());
			$(unique_parent_id +' .sdi_loader').hide();
			if (status == '-2') {
				$(unique_parent_id+' .progressbass-wr').hide();
				show_redirect_alert();
			}
			else if (status != '-1') {
				$(unique_parent_id +' .chelsio_content .path').val(iscsi_path);
				sdi_upload_driver(unique_parent_id, cxgb3_file_id, ip, drtype, driver_type, 'multiple');
			}
			else if(status == '4') {
				$(unique_parent_id+' .progressbass-wr').hide();
				show_error_msg(unique_parent_id, "Drivers already installed");
			}
			else {
				//Clearing settimeout
				for( key in progress_timeOuts ){  
			    	clearTimeout(progress_timeOuts[key]);  
			   	}
				$(unique_parent_id+' .progressbass-wr').hide();
				$(unique_parent_id +' .global_error').show();
			}
		}
	});
}

function sdi_card_change(unique_parent_id, element){
	$(unique_parent_id+' .file_text').val('');
	$(unique_parent_id+' input[type=file]').val('');
	var ostype = $(unique_parent_id + ' .ostype_input').val();
	if( $(element).val() == '1' ){
		
		if (ostype == '2') {
			//$(unique_parent_id + ' .conftype').trigger('change');
			$(unique_parent_id + ' .t4conftype_hide').hide();
			$(unique_parent_id + ' .t4conftype_' + $(unique_parent_id + ' .conftype').val()).show();
			//$(unique_parent_id + ' .t4conftype_' + $(unique_parent_id + ' .conftype').val()+'_no_default'+' input[type=checkbox]').removeAttr('checked');
		}
		
		$(unique_parent_id + ' .cxgb3_name').html('Unified');
		//linux
		if (ostype == '2') {
			$(unique_parent_id + ' .lin_t3').hide();
			$(unique_parent_id + ' .lin_t4').show();
			$(unique_parent_id + ' .conftype').trigger('change');
			$(unique_parent_id + ' .t4conftype_hide').hide();
			$(unique_parent_id + ' .t4conftype_' + $(unique_parent_id + ' .conftype').val()).show();
			
			$(unique_parent_id + ' .chelsio_content .cmn,' + unique_parent_id + ' .chelsio_content .iscsi').attr('checked', 'checked');
			$(unique_parent_id + ' .chelsio_content .fcoe').attr('checked', 'checked');
			enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
			enable_disable(unique_parent_id, 'disable', '.iscsi_file_li_wr');
			$(unique_parent_id +' .fcoe_ul').show();
			
			var height = '';
			if ($(unique_parent_id + ' .tab_head li.chelsio').hasClass('selected')) {
				height = '780px';
			}
			else if ($(unique_parent_id + ' .tab_head li.ofed').hasClass('selected')) {
				height = '305px';
			}
			else if ($(unique_parent_id + ' .tab_head li.ump').hasClass('selected')) {
				height = '220px';
			}
			$(unique_parent_id).animate({
					'height':height
			},300);
		}
		//windows
		else if(ostype == '1') {
			$(unique_parent_id + ' .win_t3').hide();
			$(unique_parent_id + ' .win_t4').show();
			$(unique_parent_id).animate({
					'height':'293px'
			},300);
		}
		else if(ostype == '5') {
			$(unique_parent_id+' .esx_t3').hide();
		}
		else if( ostype == '3' || ostype == '6' ) {
			//solaris and mac
			$(unique_parent_id + ' .cxgb3_name').html('T4');
		}
	}
	else{
		$(unique_parent_id + ' .cxgb3_name').html('cxgb3');
		//Linux
		if (ostype == '2') {
			$(unique_parent_id + ' .lin_t4').hide();
			$(unique_parent_id + ' .lin_t3').show();
			$(unique_parent_id + ' .chelsio_content .cmn,' + unique_parent_id + ' .chelsio_content .iscsi').removeAttr('checked');
			enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
			enable_disable(unique_parent_id, 'disable', '.iscsi_file_li_wr');
			$(unique_parent_id +' .fcoe_ul').hide();
			$(unique_parent_id +' .fcoe_ul input').removeAttr('checked');
			
			var height = '';
			if ($(unique_parent_id + ' .tab_head li.chelsio').hasClass('selected')) {
				height = '330px';
			}
			else if ($(unique_parent_id + ' .tab_head li.ofed').hasClass('selected')) {
				height = '305px';
			}
			else if ($(unique_parent_id + ' .tab_head li.ump').hasClass('selected')) {
				height = '220px';
			}
			$(unique_parent_id).animate({
					'height':height
			},300);
		}
		//windows
		else if(ostype == '1') {
			$(unique_parent_id+' .win_t4').hide();
			$(unique_parent_id+' .win_t3').show();
			var height = '';
			if ($(unique_parent_id + ' .tab_head li.chelsio').hasClass('selected')) {
				height = '347px';
			}
			else if ($(unique_parent_id + ' .tab_head li.ofed').hasClass('selected')) {
				height = '305px';
			}
			else if ($(unique_parent_id + ' .tab_head li.ump').hasClass('selected')) {
				height = '220px';
			}
			$(unique_parent_id).animate({
					'height':height
			},300);
		}
		else if(ostype == '5') {
			$(unique_parent_id+' .esx_t3').show();
		}
		else if(ostype == '3' || ostype == '6' ) {
			//solaris and mac
			$(unique_parent_id + ' .cxgb3_name').html('T3');
		}
	}
}
function sdi_discard(unique_parent_id){
	var ostype = $(unique_parent_id + ' .ostype_input').val();
	var card_val = '0';
	if( ostype == '4' ){
		card_val = '1';
	}

	if ($(unique_parent_id + ' .tab_widget li.selected').hasClass('chelsio')) {
		$(unique_parent_id + ' .chelsio_content input[type=checkbox]').removeAttr('checked');
		$(unique_parent_id + ' .chelsio_content .file_text').val('');
		$(unique_parent_id + ' .chelsio_content input[type=file]').val('');
		$(unique_parent_id + ' .cardtype').val(card_val).trigger('change');
		enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
		enable_disable(unique_parent_id, 'disable', '.iscsi_file_li_wr');
		enable_disable(unique_parent_id, 'disable', '.windowsdriver_file_li_wr');
		enable_disable(unique_parent_id, 'disable', '.multiport_file_li_wr');
		$(unique_parent_id + ' .chelsio_content .file_text').removeClass('error');
	}
	else if ($(unique_parent_id + ' .tab_widget li.selected').hasClass('ofed')) {
		$(unique_parent_id + ' .cardtype').val('0');
		$(unique_parent_id + ' .ofed_content .dr_ofed_pkg_type').val('all');
		$(unique_parent_id + ' .ofed_content .odt_text').val('');
		$(unique_parent_id + ' .ofed_content .ocfp_text').removeAttr('disabled').val('').attr('disabled','disabled');
		$(unique_parent_id + ' .ofed_content .ocfp_file').removeAttr('disabled').val('').attr('disabled','disabled');
		$(unique_parent_id + ' .ofed_content input[type=file]').val('');
		sdi_ofed_packge_type(unique_parent_id, $(unique_parent_id + ' .ofed_content .dr_ofed_pkg_type'));
	}
	else if ($(unique_parent_id + ' .tab_widget li.selected').hasClass('ump')) {
		$(unique_parent_id + ' .cardtype').val('0');
		$(unique_parent_id + ' .ump_content .ump_file').val('');
		$(unique_parent_id + ' .ump_content .ump_text').val('').removeClass('error');
	}
}

function sdi_ofed_packge_type(unique_parent_id, element){
	$(unique_parent_id+'  .file_text').removeClass('error');
	if( $(element).val() == 'conffile' ){
		$(unique_parent_id+' .ofed_conffile_wr .file_text').removeAttr('disabled').removeClass('disabled');
		$(unique_parent_id+' .ofed_conffile_wr .sl_file_input').removeAttr('disabled');
		$(unique_parent_id+' .ofed_conffile_wr .file_input_wr').removeClass('disabled').addClass('yellow');
	}
	else{
		$(unique_parent_id+' .ofed_conffile_wr .file_text').attr('disabled','disabled').addClass('disabled');
		$(unique_parent_id+' .ofed_conffile_wr .sl_file_input').attr('disabled','disabled');
		$(unique_parent_id+' .ofed_conffile_wr .file_input_wr').removeClass('yellow').addClass('disabled');
	}
}

function validation_file(unique_parent_id, element, ostype){
	if( ostype == '1' ){
		var ext = element.val().toLowerCase().split('.exe');
	}
	else if (ostype == '2' || ostype == '3' || ostype == '4') {
		if (ostype == '2') {
			if(  $(unique_parent_id+' .tab_widget .tab_head li.ump').hasClass('selected')  ){
				var ext = element.val().toLowerCase().split('.rpm');
			}
			else if ($(unique_parent_id + ' .tab_widget .tab_head li.ofed').hasClass('selected')) {
				var ext1 = element.val().toLowerCase().split('.tgz');
				var ext1_stats = ext1.length < 2;
				
				var ext2 = element.val().toLowerCase().split('.tar.gz');
				var ext2_stats = ext2.length < 2;
				
				if ( element.hasClass('ocfp_text') ) {
					var ext3 = element.val().toLowerCase().split('.conf');
					var ext3_stats = ext3.length < 2;
					if(ext3_stats == false){
						return true;
					}
					else{
						$(element).addClass('error');
						show_error_msg(unique_parent_id, 'Unsupported file type');
						return false;
					}
				}
				
				if(ext1_stats == false || ext2_stats  == false ){
					return true;
				}
				else{
					$(element).addClass('error');
					show_error_msg(unique_parent_id, 'Unsupported file type');
					return false;
				}
			}
			else {
				var ext = element.val().toLowerCase().split('.tar.gz');
			}
		}
		else{
			var ext = element.val().toLowerCase().split('.tar.gz');
		}		
	}
	else if( ostype == '5' || ostype == '8' ){
		var ext = element.val().toLowerCase().split('.iso');
	}
	else if( ostype == '6' ){
		var ext = element.val().toLowerCase().split('.dmg');
	}
	
	if(ext.length < 2){
		$(element).addClass('error');
		show_error_msg(unique_parent_id, 'Unsupported file type');
		return false;
	}
	else{
		return true;		
	}
	return false;
}

function sdi_refresh(unique_parent_id, element){
	$(element).parent().hide();
	$(element).parent().parent().parent().fadeOut(300);
	$('.dummy').chLightbox('alert', {
		alertTitle: 'Refresh',
		alertMsg: 'The system will be refreshed to complete the driver installation.',
		alertOk: 'OK',
		successfn: 'invoke_refresh()',
		lbWidth: 420,
		top_extra: 50
	});
}

function sdi_confchange(unique_parent_id, element){
	$(unique_parent_id + ' .chelsio_content input[type=checkbox]').removeAttr('checked');
	$(unique_parent_id + ' .chelsio_content .file_text').val('');
	$(unique_parent_id + ' .chelsio_content input[type=file]').val('');
	$(unique_parent_id+' .t4conftype_hide').hide();
	$(unique_parent_id+' .t4conftype_'+element.val()).show();
	$(unique_parent_id+' .t4conftype_'+element.val()+' input[type=checkbox]').attr('checked','checked');
	$(unique_parent_id+' .t4conftype_'+element.val()+'_no_default'+' input[type=checkbox]').removeAttr('checked');
	var height = '';
	
	if( element.val() == '0' ){
		height = '700px';
	}	
	else if( element.val() == '1' ){
		height = '470px';		
	}
	else if( element.val() == '2' || element.val() == '3' ){
		height = '560px';		
	}
	else if( element.val() == '4' ){
		height = '330px';		
	}		
	$(unique_parent_id).animate({
			'height':height
	},300);
	
}
