function fill_driver_details(ip_id){
	
	var unique_parent_id = '#system_content__incend__'+ ip_id+' .system_driver_details_tab';
	var loader_selector = unique_parent_id +' .initializer';
	$(loader_selector).show();
	
	var ip = replace_with(ip_id,'_','.');
	var sid = GetCookie("chelsio_webgui_sid");
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	var getdata = 'sid='+sid+'&ip='+ip+'&ostype='+ostype;
	
	if ($(unique_parent_id + ' .from_server').length) {
		$(loader_selector).hide();
		return
	}
	
	$(unique_parent_id +' .dd_update_driver_wr').attr('onclick','dd_update_driver("'+ unique_parent_id +'","'+ ip +'","'+ ip_id +'")');
	$(unique_parent_id +' .dd_discard_changes_wr').attr('onclick','dd_discard_changes("'+ unique_parent_id +'","'+ ip_id +'")');
	$(unique_parent_id +' .refresh a').attr('onclick','dd_discard_changes("'+ unique_parent_id +'","'+ ip_id +'")');
	$(unique_parent_id +' .dd_lk').attr('onclick','dd_hide_status("'+ unique_parent_id +'",$(this))');
	
	var ostype =  $.trim($('#ip_'+ ip_id +' a.selected').children('.ostype').val());
	if( ostype == '1' ){
		$(unique_parent_id +' .dd_update_driver_wr button').removeClass('blue').addClass('disabled').attr('disabled','disabled');
		$(unique_parent_id +' .dd_discard_changes_wr button').removeClass('blue').addClass('disabled').attr('disabled','disabled');
	}
	
	$.ajax({
		url: '/python/get_driver_details.py',
		type: 'GET',
		cache: false,
		data: getdata,
		dataType: 'json',
		success: function(data){
			$(loader_selector).hide();
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data != '-1') {
				$(unique_parent_id).css('height','auto');
				$(unique_parent_id+ ' .driver_details_main').html(data.html);
				
				//Disabling the dependency driver
				//t4_tom
				if( $(unique_parent_id+ ' .driver_details_main [name=t4_tom]').hasClass('loaded_0') ){
					$(unique_parent_id+ ' .driver_details_main [name=toecore]').attr('disabled','disabled');
					$(unique_parent_id+ ' .driver_details_main [name=cxgb4]').attr('disabled','disabled');
				}
				
				//t3_tom
				if( $(unique_parent_id+ ' .driver_details_main [name=t3_tom]').hasClass('loaded_0') ){
					//$(unique_parent_id+ ' .driver_details_main [name=t4_tom]').attr('disabled','disabled');
				}
				
				$(unique_parent_id+' .dd_wr .btn_wraper button').removeClass('disabled').addClass('blue').removeAttr('disabled');
				$(unique_parent_id+ ' .driver_details_main').fadeIn(300);
				if (ostype == '1') {
					$(unique_parent_id+ ' .driver_details_main select').attr('disabled','disabled').addClass('disabled');	
				}
				else if( ostype == '8' ){
					$(unique_parent_id+ ' .driver_details_main [name=bonding]').attr('disabled','disabled');
				}
			}
			else {
				$(unique_parent_id+' .dd_wr .btn_wraper button').removeClass('blue').addClass('disabled').attr('disabled','disabled');
				$(unique_parent_id).animate({
					'height':'55px'
				},300);
			}
		}
	});
}

function dd_update_driver(unique_parent_id,ip,ip_id){
	$(unique_parent_id+' .result,'+unique_parent_id+' .btn_wraper').hide();
	$(unique_parent_id+' .dd_action_status').fadeIn(300);
	var postdata = 'sid='+GetCookie("chelsio_webgui_sid")+'&ip='+ip;
	var driver_count = 0;
	$(unique_parent_id+' select').each(function(){
		if( $(this).attr('class').replace('loaded_','') != $(this).val() ){
			postdata += '&drivername='+$.trim($(this).parent().siblings('.driver').html());
			postdata += '&flag='+$(this).val();
			driver_count += 1;
		}
	});
	postdata += '&driver_count='+driver_count+'&vf_port='+$(unique_parent_id+' .xen_vf').val();
	
	if(!driver_count){
		$(unique_parent_id+' .result,'+unique_parent_id+' .btn_wraper').hide();
		$(unique_parent_id+' .dd_success_status').fadeIn(300);
		return
	}
	
	$.ajax({
		url: '/python/set_driver_details.py',
		type: 'POST',
		cache: false,
		data: postdata,
		success: function(status){
			if (status == '-2') {
				show_redirect_alert();
			}
			else {
				$(unique_parent_id + ' .result,' + unique_parent_id + ' .btn_wraper').hide();
				$(unique_parent_id + ' .dd_success_status').fadeIn(300);
				$(unique_parent_id + ' div').removeClass('from_server');
				fill_driver_details(ip_id);
			}
		}
	});	
}

function dd_discard_changes(unique_parent_id,ip_id){
	$(unique_parent_id+ ' div').removeClass('from_server');
	fill_driver_details(ip_id);
}

function dd_hide_status(unique_parent_id,element){
	$(unique_parent_id+ ' .result').hide();
	$(unique_parent_id+ ' .btn_wraper').fadeIn(300);
}

function driver_change(unique_parent_id, ip_id, element){
	var ostype =  $.trim($('#ip_'+ ip_id +' a.selected').children('.ostype').val());
	
	if ( element.val() == '0' || element.val() == '2' ){
		var condition1 = true;
	}
	else{
		var condition1 = false;
	}
	
	if( ostype == '8' && condition1 && $.trim(element.parent().prev().html()) == 'cxgb4' ){
		$('.dummy').chLightbox('confirm', {
			cnfmTitle: 'Driver Detials',
            cnfmMsg: 'Do you want to load Virtual Functions with cxgb4?',
            cnfmOk: 'Yes',
			cnfmCancel: 'No',
			successfn:'xen_popup("'+unique_parent_id+'")',
            lbWidth: 420,
            top_extra: 50
		});
	}
}

function xen_popup(unique_parent_id){
	$('.dummy').chLightbox('destroy');
	var html = '<div class="ch_popup">\
		<div class="overlay"></div>\
		<div class="pop_wr">\
			<div class="pop_cross" onclick="xen_vf_update(\'clear\', \''+unique_parent_id+'\')" ></div>\
			<div>\
				<div class="center">\
					<p class="f_bold">Add Virtual Function\'s</p>\
					<p class="f_bold pdn_b10">( Number of VFs per port = 0-64 )</p>\
				</div>\
				<ul class="horizontal vf_port_ul">\
					<li class="pdn_115"><input type="text" class="text vf_port1" onkeyup="$(this).removeClass(\'error\')" /></li>\
					<li><input type="text" class="text vf_port2" onkeyup="$(this).removeClass(\'error\')" /></li>\
					<li><input type="text" class="text vf_port3" onkeyup="$(this).removeClass(\'error\')" /></li>\
					<li class="pdn_r0"><input type="text" class="text vf_port4" onkeyup="$(this).removeClass(\'error\')" /></li>\
				</ul>\
				<div class="btn_wraper rect_btn_wrapper clear_left" onclick="xen_vf_update(\'set\', \''+unique_parent_id+'\')">\
				    <button class="btn yellow" type="submit">\
				        <strong>OK</strong>\
				    </button>\
				</div>\
			</div>    \
		</div>\
	</div>	'
	$(unique_parent_id+' .xen_pop_wr').html(html).show(300);
}

function xen_vf_update(action, unique_parent_id){
	if(action == 'set'){
		var success = true;
		if($.trim($(unique_parent_id+' .vf_port1').val()) == ''){
			success = false;
			$(unique_parent_id+' .vf_port1').addClass('error');
		}
		
		if( success ){
			$(unique_parent_id+' .vf_port_ul .text:not(.vf_port1)').each(function(){
				if( $.trim($(this).val()) == '' ){
					$(this).val('0');
				}
			});
			var vf_val = $(unique_parent_id+' .vf_port1').val()+','+$(unique_parent_id+' .vf_port2').val()+','+$(unique_parent_id+' .vf_port3').val()+','+$(unique_parent_id+' .vf_port4').val();
			$(unique_parent_id+' .xen_vf').val(vf_val);
			$(unique_parent_id+' .ch_popup').remove();
		}
	}
	else{
		$(unique_parent_id+' .xen_vf').val('');
		$(unique_parent_id+' .ch_popup').remove();
	}
}
