function fill_port_stats(ip_id){
	var menu_id = 'ip_'+ip_id;
	var index = parseInt($.trim($('#'+menu_id+' .menu_port_li a.selected').attr('class').replace('selected','').split('port_')[1]))+1;
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	
	if( ostype == '4' ){
		var freebds_port_index = $.trim($('#'+menu_id+' .menu_port_li a.selected').attr('rel').split('freebsd_p_idx_')[1]);
		index = freebds_port_index;
	}
	
	var unique_inc = $('#m_tree_wrap .tree .tree_ul a.selected').attr('name')+'end';
	var unique_parent_id = '#port0_content__'+ unique_inc + '__' + ip_id;
	var loader_selector = unique_parent_id +' .port_stats_tab .initializer';
	$(loader_selector).show();
	
	var ip = replace_with(ip_id,'_','.');
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid='+sid+'&ip='+ip+'&port_index='+index;
	
	var card_inc = $('#m_tree_wrap .tree .tree_ul a.selected').parent().parent().parent().parent().children().find('.card').attr('name');
	var unique_inc = card_inc+'end';
	var card_index = card_inc.replace('inc','');
	var unique_card_parentid = '#card_content__'+ unique_inc + '__' + ip_id;

	var pciloc = $.trim($('#m_tree_wrap .tree .tree_ul a.selected').parent().parent().siblings('.card').children('.pciloc').val());
	port_statistics(unique_parent_id, getdata, loader_selector, pciloc);
}

function port_statistics(unique_parent_id,getdata,loader_selector,pciloc){
	getdata += "&pciloc="+pciloc
	$.ajax({
		url: '/python/get_port_statistics.py',
		type: 'GET',
		cache: false,
		data: getdata,
		dataType: 'json',
		success: function(data){
			$(loader_selector).hide();
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data == '69') {
				show_error_msg(unique_parent_id+' .port_stats_tab', 'No stats found/available for this port');
			}
			else if (data != '-1') {
				$(unique_parent_id + ' .port_stats_tab').animate({
					'height': data.height + 'px'
				}, 300);
				$(unique_parent_id + ' .port_stats_main').html(data.html);
				$(unique_parent_id + ' .port_stats_main').fadeIn(300);
			}
			else {
				display_failed(unique_parent_id);
			}
		}
	});
}
