function fill_nw_snc_eth(ip_id){
	
	var unique_parent_id = '#network_content__incend__'+ ip_id+' .network_snc_tab';
	
	if ($(unique_parent_id + ' .interface_list li').length) {
		return
	}
	
	var ip = replace_with(ip_id, '_', '.');
	
	if( $(unique_parent_id +' .second_wr').css('display') == 'none' ){
		var chk_html = '<input type="checkbox" value = "" class="fl_left" onclick = \'show_additional_iptab("'+ unique_parent_id +'",$(this))\' >\
						<label>View/Set additional IP addresses</label>';
		$(unique_parent_id+' .add_ip_chk_dd').html(chk_html);
	}
	
	$(unique_parent_id +' .second_wr .tab_content_right .del_ip_btn_wr').attr('onclick','snc_delete_ip("'+ unique_parent_id +'","'+ ip +'",$(this))');

	$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_btn_wr').attr('onclick','snc_modify_ip("'+ unique_parent_id +'","'+ ip +'")');
	$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .snc_error_status .hide_lk').attr('onclick','snc_modip_hide_error("'+ unique_parent_id +'",$(this))');
	$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .snc_iperror_status .hide_lk').attr('onclick','snc_modip_hide_error("'+ unique_parent_id +'",$(this))');
	
	$(unique_parent_id +' .second_wr .tab_content_right .add_ip_btn_wr').attr('onclick','snc_add_ip("'+ unique_parent_id +'","'+ ip +'")');
	$(unique_parent_id +' .second_wr .tab_content_right .add_ip_fd .snc_error_status .hide_lk').attr('onclick','snc_addip_hide_error("'+ unique_parent_id +'",$(this))');
	$(unique_parent_id +' .second_wr .tab_content_right .add_ip_fd .snc_iperror_status .hide_lk').attr('onclick','snc_addip_hide_error("'+ unique_parent_id +'",$(this))');
	
	$(unique_parent_id +' .first_wr .tab_content_right .snc_error_status .hide_lk').attr('onclick','snc_hide_error("'+ unique_parent_id +'",$(this))');
	$(unique_parent_id +' .first_wr .btn_main_wr .save_changes').attr('onclick','snc_save_changes("'+ unique_parent_id +'","'+ ip +'","'+ ip_id +'",$(this))');
	$(unique_parent_id +' .first_wr .detail_ip_type').attr('onchange','change_iptype("'+ unique_parent_id +'",$(this))');
	$(unique_parent_id +' .first_wr .discard_changes').attr('onclick','discard_changes("'+ unique_parent_id +'",$(this))');
	$(unique_parent_id +' .first_wr .delete_team_wr').attr('onclick','snc_delete_team("'+ unique_parent_id +'","'+ ip +'","'+ ip_id +'", $(this))');
	
	$(unique_parent_id +' .first_wr .ifname_status_b').attr('onclick','update_adapter("'+ unique_parent_id +'","'+ ip +'","'+ ip_id +'")');
	$(unique_parent_id +' .first_wr .tab_content_right .text').attr('onkeyup','enable_button("'+ unique_parent_id +'",$(this))');
	
	$(unique_parent_id +' .first_wr .delete_vlan_wr').attr('onclick','delete_vlan("'+ unique_parent_id +'","'+ ip +'","'+ ip_id +'",$(this))');
	$(unique_parent_id +' .global_error .status_link').attr('onclick','$("'+unique_parent_id +' .global_error").hide();fill_nw_snc_eth("'+ ip_id +'")');
	
	var loader_selector = unique_parent_id + ' .initializer';
	$(loader_selector).show();
	
	var sid = GetCookie("chelsio_webgui_sid");
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	if( ostype == '5' ){
		$(unique_parent_id +' .add_ip_chk_dd').hide();
		$(unique_parent_id +' .esx').hide();
		$(unique_parent_id +' .first_wr .tab_content_right .fieldset').css('height','190px');
		$(unique_parent_id +' .first_wr .tab_content_left_main_list').css('height','200px');
		$(unique_parent_id +' .first_wr .tab_content_left_main').css('height','200px');
		$(unique_parent_id +' .first_wr').css('height','285px');
		$(unique_parent_id).animate({
			height: '290px'
		});
	}
	var getdata = 'sid=' + sid + '&ip=' + ip + '&ostype='+ostype;
	$.ajax({
		url: '/python/get_network_info.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(html){
			if (html == '-2') {
				show_redirect_alert();
			}
			else if (html == '-1') {
				$(unique_parent_id + ' .interface_list li').remove();
				$(unique_parent_id +' .global_error').fadeIn(300);
			}
			else {
				$(unique_parent_id + ' .interface_list').html(html);
				$(loader_selector).hide();
				$(unique_parent_id + ' .interface_list').fadeIn(300);
			}
		}
	});
}

function enable_button(unique_parent_id,element){
	$(element).removeClass('error'); 
	if( !$(unique_parent_id +' .first_wr .interface_list li.selected').length ){
		return
	}
	$(unique_parent_id +' .first_wr .tab_content_right button').removeClass('disabled').addClass('blue');
}

function snc_delete_team(unique_parent_id, ip, ip_id, element){
	
	$(unique_parent_id +' .first_wr .tab_content_left_main .snc_action_status .status_msg').html('Deleting Team...');
	$(unique_parent_id +' .first_wr .tab_content_left_main .btn_wraper').hide();
	$(unique_parent_id +' .first_wr .tab_content_left_main .snc_action_status').show();
	var sid = GetCookie("chelsio_webgui_sid");
	var ifName = $.trim(($(unique_parent_id +' .first_wr .interface_list li.selected').children('.sa').val()).split('[')[0]);
	var getdata = 'sid='+sid+'&umip='+ip+'&action=delete_team&ifName='+ifName;
	$.ajax({
		url: '/python/set_interface_values.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data == '0') {
				$(unique_parent_id +' .first_wr .tab_content_left_main .snc_success_status .status_msg').html('Deleted Team');
				$(unique_parent_id +' .first_wr .tab_content_left_main .snc_action_status').hide();
				$(unique_parent_id +' .first_wr .tab_content_left_main .snc_success_status').show();
				if ($('#network_content__incend__' + ip_id + ' .network_cntb_tab .interface_list li').length) {
					$('#network_content__incend__' + ip_id + ' .network_cntb_tab .interface_list').html('');
				}
				make_default(unique_parent_id);
				fill_nw_snc_eth(ip_id);
			}
			else{
				$(unique_parent_id +' .first_wr .tab_content_left_main .snc_error_status .status_msg').html('Error Deleting Team');
				$(unique_parent_id +' .first_wr .tab_content_left_main .snc_action_status').hide();
				$(unique_parent_id +' .first_wr .tab_content_left_main .snc_error_status').show();
			}
		}
	});
}

function fill_interface_details(element){
	var unique_parent_id = '#network_content__incend__' + $(element).children('.ipid').val() + ' .network_snc_tab';
	
	if($(unique_parent_id +' .first_wr .snc_action_status').css('display') != 'none'){
		return
	}
	
	if( $(element).hasClass('is_team') ){
		$(unique_parent_id +' .delete_team_wr button').removeAttr('Class').addClass('btn blue').removeAttr('disabled');
		$(unique_parent_id +' .delete_team_wr').show();
	}
	else{
		$(unique_parent_id +' .delete_team_wr').hide();
	}
	
	$(unique_parent_id +' .first_wr .tab_content_right .text').removeClass('error');
	$(element).siblings().removeClass('selected');
	$(element).addClass('selected');
	$(unique_parent_id +' .second_wr .tab_content_right .add_ip_btn_wr button').removeAttr('Class').addClass('btn blue');
	$(unique_parent_id +' .first_wr .tab_content_right .btn_wraper button').removeAttr('class').addClass('btn disabled');
	
	$(unique_parent_id +' .first_wr .tab_content_left_main .ifname_status_b button').removeAttr('Class').addClass('btn blue');
	if ($(element).children('.vlan').length){
		if( parseInt($.trim($(element).children('.vlan').val())) > 0){
			var ostype = $.trim($('#ip_' + $(element).children('.ipid').val() + ' .system_link').children('.ostype').val());
			if( ostype == '3' ){
				$(unique_parent_id +' .first_wr .tab_content_left_main .ifname_status_b button').removeClass('blue').addClass('disabled');	
			}
			$(unique_parent_id +' .first_wr .tab_content_left_main .delete_vlan_wr button').removeAttr('Class').addClass('btn blue');
		}
		else{
			$(unique_parent_id +' .first_wr .tab_content_left_main .delete_vlan_wr button').removeAttr('class').addClass('btn disabled');
		}
	}
	else{
		$(unique_parent_id +' .first_wr .tab_content_left_main .delete_vlan_wr button').removeAttr('class').addClass('btn disabled');
	}
		
	$(unique_parent_id +' .detail_ifname').html($(element).children('.sa').val());
	
	var desc = $.trim($(element).children('.desc').val());
	if( desc == '' ){
		desc = 'N/A';	
	}
	$(unique_parent_id +' .detail_desc').html(desc);
	$(unique_parent_id +' .detail_desc').attr('title',desc);
	
	var status = $.trim($(element).children('.status').val()).split('__')[1].split('**')[0];
	var link_status = $.trim($(element).children('.status').val()).split('__')[1].split('**')[1];
	var status_class = $.trim($(element).children('.status').val()).split('__')[0];
	var status_value = status+' '+link_status;
	
	if ( $.trim($(element).attr('name')) == 'disabled' ){
		$(unique_parent_id +' .first_wr .ifname_status_b strong').html('Enable interface');
		$(unique_parent_id +' .first_wr .ifname_status_b strong').removeAttr('class').addClass('enable');
		if ($(element).hasClass('is_team')) {
			$(unique_parent_id + ' .ifname_status_b button strong').html('Enable Team');
		}
	}
	else{
		$(unique_parent_id +' .first_wr .ifname_status_b strong').html('Disable interface');
		$(unique_parent_id +' .first_wr .ifname_status_b strong').removeAttr('class').addClass('disable');
		if ($(element).hasClass('is_team')) {
			$(unique_parent_id + ' .ifname_status_b button strong').html('Disable Team');
		}
	}
	
	$(unique_parent_id +' .detail_status').html(status_value);
	$(unique_parent_id +' .detail_status').removeAttr('class').addClass('detail_status '+status_class);
	$(unique_parent_id +' .detail_ip_type').val($(element).children('.ip_type').val());
	if( $(element).children('.ip_type').val() == 'dhcp' ){
		$(unique_parent_id +' .first_wr .detail_ipaddr').attr('disabled','disabled').addClass('disabled');
		$(unique_parent_id +' .first_wr .detail_mask').attr('disabled','disabled').addClass('disabled');
	}
	else{
		$(unique_parent_id +' .first_wr .detail_ipaddr').removeAttr('disabled').removeClass('disabled');
		$(unique_parent_id +' .first_wr .detail_mask').removeAttr('disabled').removeClass('disabled');
	}
	
	if ($(element).children('.ip_mask').length) {
		$(unique_parent_id + ' .detail_ipaddr').val($(element).children('.ip_mask').val().split('__')[0]);
		$(unique_parent_id + ' .detail_mask').val($(element).children('.ip_mask').val().split('__')[1]);
	}
	else{
		$(unique_parent_id + ' .detail_ipaddr').val('');
		$(unique_parent_id + ' .detail_mask').val('');
	}
	
	if( $(element).children('.mtu').length ){
		$(unique_parent_id +' .detail_mtu').val($(element).children('.mtu').val());
	}
	else{
		$(unique_parent_id +' .detail_mtu').val('');
	}
	
	if ($(element).children('.vlan').length) {
		$(unique_parent_id +' .detail_vlan').val($(element).children('.vlan').val());
	}
	else{
		$(unique_parent_id +' .detail_vlan').val('');
	}
	
	fill_additional_ipaddr(element,unique_parent_id);
	$(unique_parent_id +' .m_ip').val('');
	$(unique_parent_id +' .m_mask').val('');
}

function fill_additional_ipaddr(element,unique_parent_id){
	var iplist_html = '';
	
	if($(element).children('.ip_mask').length){
		$(element).children('.ip_mask').each(function(i){
			if (i > 0) {
				iplist_html += '<li class="ip_list_li" onclick = \'fill_modify_ip("' + unique_parent_id + '",$(this),"' + $(this).val().split('__')[0] + '","' + $(this).val().split('__')[1] + '")\'\
							>' +
				$(this).val().split('__')[0] +
				' / ' +
				$(this).val().split('__')[1] +
				'</li>';
			}
		});
	}
	
	if ( iplist_html == '' ){
		$(unique_parent_id +' .second_wr .modify_ip_btn_wr button').removeClass('blue').addClass('disabled');
		$(unique_parent_id +' .second_wr .del_ip_btn_wr button').removeClass('blue').addClass('disabled');
	}
	
	$(unique_parent_id+ ' .second_wr .ip_list_ul').html(iplist_html);
}

function show_additional_iptab(unique_parent_id,element){
	if( $(element).is(':checked') ){
		$(unique_parent_id).animate({
			'height':'652px'
		},300);
		$(unique_parent_id +' .second_wr').fadeIn(300);
	}
	else{
		$(unique_parent_id +' .second_wr').hide();
		$(unique_parent_id).animate({
			'height':'416px'
		},300);
	}
}

function fill_modify_ip(unique_parent_id,element,ip,mask){
	$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_btn_wr button').removeClass('disabled').addClass('blue');
	$(unique_parent_id +' .second_wr .del_ip_btn_wr button').removeClass('disabled').addClass('blue');
	$(unique_parent_id +' .ip_list_ul li').removeClass('selected');	
	$(element).addClass('selected');
	$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .result').hide();
	$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .text').removeClass('error');
	$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_btn_wr').show();
	$(unique_parent_id +' .m_ip').val(ip);
	$(unique_parent_id +' .m_mask').val(mask);
}

function update_adapter(unique_parent_id,ip,ip_id){
	
	if( $(unique_parent_id +' .first_wr .ifname_status_b button').hasClass('disabled') ){
		return;
	}
	
	var status_class = $.trim($(unique_parent_id +' .first_wr .ifname_status_b strong').attr('class'));
	var status_msg = '';
	
	if( status_class == 'enable' ){
		status_msg = 'Enabling interface';
	}
	else{
		status_msg = 'Disabling interface';
	}  
	
	$(unique_parent_id +' .first_wr .tab_content_left_main .snc_action_status .status_msg').html(status_msg);
	$(unique_parent_id +' .first_wr .tab_content_left_main .btn_wraper').hide();
	$(unique_parent_id +' .first_wr .tab_content_left_main .snc_action_status').show();
	var intfname = $.trim(($(unique_parent_id +' .first_wr .interface_list li.selected').children('.sa').val()).split('[')[0]);
	
	var getdata = 'sid='+GetCookie("chelsio_webgui_sid")+'&ip='+ip+'&action='+status_class+'&intfname='+intfname;
	
	$.ajax({
		url: '/python/update_adapter.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			
			var status_class = $.trim($(unique_parent_id +' .first_wr .ifname_status_b strong').attr('class'));
			if( status_class == 'enable' ){
				var error_msg = 'Enabling interface Failed.'
				var success_msg = 'Enabled interface';
				var button_msg = 'Disable interface';
				var new_status_class = 'disable';
			}
			else{
				var error_msg = 'Disabling interface Failed.'
				var success_msg = 'Disabled interface';
				var button_msg = 'Enable interface';
				var new_status_class = 'enable';
			} 
			
			
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data == '-1') {
				$(unique_parent_id +' .first_wr .tab_content_left_main .snc_error_status .status_msg').html(error_msg);
				$(unique_parent_id +' .first_wr .tab_content_left_main .snc_action_status').hide();
				$(unique_parent_id +' .first_wr .tab_content_left_main .snc_error_status').show();
			}
			else{
				$(unique_parent_id +' .first_wr .tab_content_left_main .snc_success_status .status_msg').html(success_msg);
				$(unique_parent_id +' .first_wr .tab_content_left_main .snc_action_status').hide();
				$(unique_parent_id +' .first_wr .tab_content_left_main .snc_success_status').show();
				$(unique_parent_id +' .first_wr .ifname_status_b strong').html(button_msg);
				$(unique_parent_id +' .first_wr .ifname_status_b strong').removeAttr('class').addClass(new_status_class);
				make_default(unique_parent_id);
				fill_nw_snc_eth(ip_id);
			}
		}			
	});
}

function change_iptype(unique_parent_id,element){
	
	if( !$(unique_parent_id +' .first_wr .interface_list li.selected').length ){
		return
	}
	
	$(element).removeClass('error');
	$(unique_parent_id +' .first_wr .tab_content_right .text').removeClass('error');
	$(unique_parent_id +' .first_wr .tab_content_right .btn_wraper button').removeClass('disabled').addClass('blue');
	
	if( $(element).val() == 'dhcp' ){
		$(unique_parent_id +' .first_wr .detail_ipaddr').attr('disabled','disabled').addClass('disabled');
		$(unique_parent_id +' .first_wr .detail_mask').attr('disabled','disabled').addClass('disabled');
	}
	else{
		$(unique_parent_id +' .first_wr .detail_ipaddr').removeClass('disabled').removeAttr('disabled');
		$(unique_parent_id +' .first_wr .detail_mask').removeClass('disabled').removeAttr('disabled');
	}	
}

function discard_changes(unique_parent_id,element){
	if($(element).children('button').hasClass('disabled')){
		return
	}
	$(unique_parent_id +' .first_wr .tab_content_right .text').removeClass('error');
	$(unique_parent_id +' .first_wr .tab_content_right .detail_ip_type').removeClass('error');
	fill_interface_details($(unique_parent_id +' .first_wr .interface_list li.selected'));
	$(unique_parent_id +' .first_wr .tab_content_right .btn_wraper button').removeAttr('class').addClass('btn disabled');	
}

function snc_save_changes(unique_parent_id,ip,ip_id,element){
	
	if($(element).children('button').hasClass('disabled')){
		return
	}
	
	var action = $.trim($(unique_parent_id+' .detail_ip_type').val());
	var success = true;
	$(unique_parent_id +' .first_wr .tab_content_right .'+action).each(function(){
		if($.trim($(this).val()) == '' ){
			success = false;
			$(this).addClass('error');
		}
	});
	
	if(!success){
		return
	}

	$(unique_parent_id +' .first_wr .tab_content_right .snc_action_status .status_msg').html('Saving Changes...');
	$(unique_parent_id +' .first_wr .tab_content_right .btn_wraper').hide();
	$(unique_parent_id +' .first_wr .tab_content_right .snc_action_status').show();
	
	var ifName = $.trim(($(unique_parent_id +' .first_wr .interface_list li.selected').children('.sa').val()).split('[')[0]);
	var sid = GetCookie("chelsio_webgui_sid");
	var value_changed = false;
	
	//Set MTU
	var current_mtu = $.trim($(unique_parent_id+' .first_wr .detail_mtu').val());
	var existing_mtu = '';
	if ($(unique_parent_id + ' .first_wr .interface_list li.selected').children('.mtu').length) {
		existing_mtu = $(unique_parent_id + ' .first_wr .interface_list li.selected').children('.mtu').val();
	}
	if( current_mtu != existing_mtu  ){
		value_changed = true;
		set_mtu(unique_parent_id,ip_id,sid,ip,ifName,current_mtu);
	}
	
	//Set VLAN
	var current_vlan = $.trim($(unique_parent_id+' .first_wr .detail_vlan').val());
	var existing_vlan = '';
	if($(unique_parent_id +' .first_wr .interface_list li.selected').children('.vlan').length){
		var existing_vlan = $(unique_parent_id +' .first_wr .interface_list li.selected').children('.vlan').val();		
	}
	if( current_vlan != existing_vlan  ){
		value_changed = true;
		set_vlan(unique_parent_id,ip_id,sid,ip,ifName,current_vlan);
	}
	
	//Set , Add , Modify IP Addresses
	var existing_ip = ''; 
	if ($(unique_parent_id + ' .first_wr .interface_list li.selected').children('.ip_mask:first').length) {
		existing_ip = $.trim($(unique_parent_id + ' .first_wr .interface_list li.selected').children('.ip_mask:first').val().split('__')[0]);
	}
	var setip = $.trim($(unique_parent_id+' .first_wr .detail_ipaddr').val());
	
	var existing_mask = '';
	if($(unique_parent_id +' .first_wr .interface_list li.selected').children('.ip_mask:first').length){
		existing_mask = $.trim($(unique_parent_id +' .first_wr .interface_list li.selected').children('.ip_mask:first').val().split('__')[1]);
	}
	var mask  =  $.trim($(unique_parent_id+' .first_wr .detail_mask').val());
	var existing_ip_type = $.trim($(unique_parent_id +' .first_wr .interface_list li.selected').children('.ip_type').val());
	
	if( existing_ip != setip || existing_mask != mask || existing_ip_type != action){
		value_changed = true;
		set_ip_addr(unique_parent_id,ip_id,sid,ip,action,ifName,setip,mask)		
	}
	
	if( !value_changed ){
		$(unique_parent_id +' .first_wr .tab_content_right .result').hide();
		$(unique_parent_id +' .first_wr .tab_content_right .btn_wraper button').removeClass('blue').addClass('disabled');
		$(unique_parent_id +' .first_wr .tab_content_right .btn_wraper').show();
	}
}

function set_ip_addr(unique_parent_id,ip_id,sid,ip,action,ifName,setip,mask){
	
	var getdata = 'sid='+sid+'&umip='+ip+'&action='+action+'&ifName='+ifName+'&setip='+setip+'&mask='+mask;
	$.ajax({
		url: '/python/set_interface_values.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data == '0') {
				make_default(unique_parent_id);
				snc_ajax_response(unique_parent_id, ip_id);
				fill_nw_snc_eth(ip_id);
			}
			else{
				if( action == 'dhcp' ){
					$(unique_parent_id+' .detail_ip_type').addClass('error');
				}
				else{
					$(unique_parent_id+' .detail_ip_type').addClass('error');
					$(unique_parent_id+' .detail_ipaddr').addClass('error');
					$(unique_parent_id+' .detail_mask').addClass('error');						
				}
				snc_show_error_alert(unique_parent_id);
			}
		}
	});	
}

function set_mtu(unique_parent_id,ip_id,sid,ip,ifName,current_mtu){
	
	var getdata = 'sid='+sid+'&umip='+ip+'&action=setmtu&ifName='+ifName+'&mtu='+current_mtu;
	$.ajax({
		url: '/python/set_interface_values.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data == '0') {
				$(unique_parent_id +' .first_wr .interface_list li.selected').children('.mtu').val(current_mtu);
				snc_ajax_response(unique_parent_id, ip_id);
			}
			else{
				$(unique_parent_id+' .first_wr .detail_mtu').addClass('error');
				snc_show_error_alert(unique_parent_id);
			}
		}
	});	
}

function set_vlan(unique_parent_id,ip_id,sid,ip,ifName,current_vlan){
	var getdata = 'sid='+sid+'&umip='+ip+'&action=setvlan&ifName='+ifName+'&vlan='+current_vlan;
	$.ajax({
		url: '/python/set_interface_values.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data == '0') {
				make_default(unique_parent_id);
				snc_ajax_response(unique_parent_id, ip_id);
				fill_nw_snc_eth(ip_id);
			}
			else{
				$(unique_parent_id+' .first_wr .detail_vlan').addClass('error');
				snc_show_error_alert(unique_parent_id);
			}
		}
	});
}


function snc_ajax_response(unique_parent_id,ip_id){
	if($(unique_parent_id +' .first_wr .tab_content_right .snc_error_status').css('display') != 'none' ){
		return
	}
	$(unique_parent_id +' .first_wr .tab_content_right .snc_success_status .status_msg').html('Changes Saved');
	$(unique_parent_id +' .first_wr .tab_content_right .result').hide();
	$(unique_parent_id +' .first_wr .tab_content_right .snc_success_status').show();
}

function snc_show_error_alert(unique_parent_id){
	$(unique_parent_id +' .first_wr .tab_content_right .snc_error_status .status_msg').html('Could not set the highlighted fields.');
	$(unique_parent_id +' .first_wr .tab_content_right .result').hide();
	$(unique_parent_id +' .first_wr .tab_content_right .snc_error_status').show();
}

function snc_hide_error(unique_parent_id,element){
	$(element).parent().parent().hide()
	$(unique_parent_id +' .first_wr .tab_content_right .btn_wraper').fadeIn(300);
	$(unique_parent_id +' .first_wr .tab_content_right .text').removeClass('error');
	$(unique_parent_id +' .first_wr .tab_content_right .detail_ip_type').removeClass('error');
}

function snc_add_ip(unique_parent_id,ip){
	
	if( $(unique_parent_id +' .second_wr .tab_content_right .add_ip_btn_wr button').hasClass('disabled') ){
		return	
	}
	
	var success = true;
	$(unique_parent_id +' .second_wr .tab_content_right .add_ip_fd .text').each(function(){
		if($.trim($(this).val()) == '' ){
			success = false;
			$(this).addClass('error');
		}
	});
	
	if(!success){
		return
	}
	
	$(unique_parent_id +' .second_wr .tab_content_right .add_ip_fd .text').removeClass('error');
	$(unique_parent_id +' .second_wr .tab_content_right .add_ip_btn_wr').hide();
	$(unique_parent_id +' .second_wr .tab_content_right .add_ip_fd .snc_action_status').show();
	
	var sid = GetCookie("chelsio_webgui_sid");
	var ifName = $.trim(($(unique_parent_id +' .first_wr .interface_list li.selected').children('.sa').val()).split('[')[0]);
	var setip = $(unique_parent_id +' .second_wr .tab_content_right .add_ip').val();
	var mask =  $(unique_parent_id +' .second_wr .tab_content_right .add_mask').val();
	var getdata = 'sid='+sid+'&umip='+ip+'&action=AdditionalIp&ifName='+ifName+'&setip='+setip+'&mask='+mask;
	
	$.ajax({
		url: '/python/set_interface_values.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data == '0') {
				$(unique_parent_id +' .second_wr .tab_content_right .add_ip_fd .result').hide();
				$(unique_parent_id +' .second_wr .tab_content_right .add_ip_fd .snc_success_status').show();
				var ip_mask_disp = '<li onclick=\'fill_modify_ip("'+ unique_parent_id +'",$(this),"'+ setip +'","'+ mask +'")\' class="ip_list_li">'+ setip+' / '+mask; +'</li>';
				$(unique_parent_id +' .second_wr .tab_content_left_main .ip_list_ul ').append(ip_mask_disp);
				var hidden_input = '<input type="hidden" value="'+ setip +'__'+ mask +'" class="ip_mask">';
				$(unique_parent_id +' .first_wr .interface_list li.selected').append(hidden_input);
				$(unique_parent_id +' .second_wr .tab_content_right .add_ip').val('');
				$(unique_parent_id +' .second_wr .tab_content_right .add_mask').val('');
			}
			else{
				$(unique_parent_id +' .second_wr .tab_content_right .add_ip_fd .result').hide();
				if( $.trim(data) == 'Invalid IP' || $.trim(data) == 'Invalid Mask' ){
					$(unique_parent_id +' .second_wr .tab_content_right .add_ip_fd .snc_iperror_status .status_msg').html(data);
					$(unique_parent_id +' .second_wr .tab_content_right .add_ip_fd .snc_iperror_status').show();
					if ( $.trim(data) == 'Invalid IP' ) {
						$(unique_parent_id + ' .second_wr .tab_content_right .add_ip').addClass('error');
					}
					else if( $.trim(data) == 'Invalid Mask' ){
						$(unique_parent_id + ' .second_wr .tab_content_right .add_mask').addClass('error');						
					}
				}
				else{
					$(unique_parent_id +' .second_wr .tab_content_right .add_ip_fd .snc_error_status').show();
					$(unique_parent_id +' .second_wr .tab_content_right .add_ip').addClass('error');
					$(unique_parent_id +' .second_wr .tab_content_right .add_mask').addClass('error');
				}
			}
		}
	});	
}

function snc_addip_hide_error(unique_parent_id,element){
	$(element).parent().parent().hide();
	$(element).parent().parent().siblings('.add_ip_btn_wr').fadeIn(300);
}

function snc_modip_hide_error(unique_parent_id,element){
	$(element).parent().parent().hide();
	$(element).parent().parent().siblings('.modify_ip_btn_wr').fadeIn(300);
}

function snc_modify_ip(unique_parent_id,ip){
	
	if( $(unique_parent_id +' .second_wr .tab_content_right .modify_ip_btn_wr button').hasClass('disabled') ){
		return	
	}
	
	var success = true;
	$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .text').each(function(){
		if($.trim($(this).val()) == '' ){
			success = false;
			$(this).addClass('error');
		}
	});
	
	if(!success){
		return
	}
	if($(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .snc_action_status').css('display') != 'none'){
		return
	}
	
	$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .text').removeClass('error');
	$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_btn_wr').hide();
	$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .snc_action_status').show();
	
	var sid = GetCookie("chelsio_webgui_sid");
	var ifName = $.trim(($(unique_parent_id +' .first_wr .interface_list li.selected').children('.sa').val()).split('[')[0]);
	var current_ip = $.trim(($(unique_parent_id +' .second_wr .ip_list_ul li.selected').html().split('/')[0]));
	var newip =  $(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .m_ip').val();
	var mask =  $(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .m_mask').val();
	var getdata = 'sid='+sid+'&umip='+ip+'&action=ModifyIp&ifName='+ifName+'&ip='+current_ip+'&newip='+newip+'&mask='+mask;
	
	$.ajax({
		url: '/python/set_interface_values.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data == '0') {
				$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .result').hide();
				$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .snc_success_status').show();
				var ip_mask_disp = '<li onclick=\'fill_modify_ip("'+ unique_parent_id +'",$(this),"'+ newip +'","'+ mask +'")\' class="ip_list_li">'+ newip+' / '+mask; +'</li>';
				$(unique_parent_id +' .second_wr .tab_content_left_main .ip_list_ul li.selected').remove();
				$(unique_parent_id +' .second_wr .tab_content_left_main .ip_list_ul ').append(ip_mask_disp);
				var hidden_input = '<input type="hidden" value="'+ newip +'__'+ mask +'" class="ip_mask">';
				$(unique_parent_id +' .first_wr .interface_list li.selected').children('.ip_mask[value="'+current_ip+'__'+mask+'"]').remove();
				$(unique_parent_id +' .first_wr .interface_list li.selected').append(hidden_input);
				$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .m_ip').val('');
				$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .m_mask').val('');
			}
			else{
				$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .result').hide();
				if( $.trim(data) == 'Invalid IP' || $.trim(data) == 'Invalid Mask' ){
					$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .snc_iperror_status .status_msg').html(data);
					$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .snc_iperror_status').show();
					if ( $.trim(data) == 'Invalid IP' ) {
						$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .m_ip').addClass('error');
					}
					else if( $.trim(data) == 'Invalid Mask' ){
						$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .m_mask').addClass('error');					
					}
				}
				else{
					$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .snc_error_status').show();
					$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .m_ip').addClass('error');
					$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .m_mask').addClass('error');
				}
			}
		}
	});	
}

function snc_delete_ip(unique_parent_id,ip,element){
	
	if( $(element).children('button').hasClass('disabled') || $(unique_parent_id +' .second_wr .tab_content_right .snc_del_wr .snc_action_status').css('display') != 'none' ){
		return
	}
	
	$(unique_parent_id +' .second_wr .tab_content_right .del_ip_btn_wr').hide();
	$(unique_parent_id +' .second_wr .tab_content_right .snc_del_wr .snc_action_status').show();
	
	var sid = GetCookie("chelsio_webgui_sid");
	var ifName = $.trim(($(unique_parent_id +' .first_wr .interface_list li.selected').children('.sa').val()).split('[')[0]);
	var delip =  $.trim(($(unique_parent_id +' .second_wr .ip_list_ul li.selected').html().split('/')[0]));
	var mask =  $.trim(($(unique_parent_id +' .second_wr .ip_list_ul li.selected').html().split('/')[1]));
	var getdata = 'sid='+sid+'&umip='+ip+'&action=DeleteIp&ifName='+ifName+'&ip='+delip;
	
	$.ajax({
		url: '/python/set_interface_values.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data == '0'){
				$(unique_parent_id +' .second_wr .tab_content_right .snc_del_wr .result').hide();
				$(unique_parent_id +' .second_wr .tab_content_right .snc_del_wr .snc_success_status').show();
				$(unique_parent_id +' .second_wr .tab_content_left_main .ip_list_ul li.selected').remove();
				$(unique_parent_id +' .first_wr .interface_list li.selected').children('.ip_mask[value="'+delip+'__'+mask+'"]').remove();
				$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .m_ip').val('');
				$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_fd .m_mask').val('');
				$(unique_parent_id +' .second_wr .tab_content_right .modify_ip_btn_wr button').removeClass('blue').addClass('disabled');
			}
			else{
				$(unique_parent_id +' .second_wr .tab_content_right .snc_del_wr .result').hide();
				$(unique_parent_id +' .second_wr .tab_content_right .snc_del_wr .snc_error_status').show();
			}
		}
	});	
}

//Delete Vlan
function delete_vlan(unique_parent_id,ip,ip_id,element){
	
	if(!$(unique_parent_id +' .first_wr .tab_content_left_main .delete_vlan_wr button.blue').length){
		return
	}
	
	$(unique_parent_id +' .first_wr .tab_content_left_main .snc_action_status .status_msg').html('Deleting Vlan...');
	$(unique_parent_id +' .first_wr .tab_content_left_main .btn_wraper').hide();
	$(unique_parent_id +' .first_wr .tab_content_left_main .snc_action_status').show();
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	var vlan_id = $.trim(($(unique_parent_id +' .first_wr .interface_list li.selected').children('.vlan').val()));
	var sid = GetCookie("chelsio_webgui_sid");
	var ifName = $.trim(($(unique_parent_id +' .first_wr .interface_list li.selected').children('.sa').val()).split('[')[0]);
	var getdata = 'sid='+sid+'&umip='+ip+'&action=deletevlan&ifName='+ifName+'&vlan_id='+vlan_id+'&ostype='+ostype;
	$.ajax({
		url: '/python/set_interface_values.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data == '0') {
				$(unique_parent_id +' .first_wr .tab_content_left_main .snc_success_status .status_msg').html('Deleted Vlan');
				$(unique_parent_id +' .first_wr .tab_content_left_main .snc_action_status').hide();
				$(unique_parent_id +' .first_wr .tab_content_left_main .snc_success_status').show();
				make_default(unique_parent_id);
				fill_nw_snc_eth(ip_id);
			}
			else{
				$(unique_parent_id +' .first_wr .tab_content_left_main .snc_error_status .status_msg').html('Error Deleting Vlan');
				$(unique_parent_id +' .first_wr .tab_content_left_main .snc_action_status').hide();
				$(unique_parent_id +' .first_wr .tab_content_left_main .snc_error_status').show();
			}
		}
	});
}

function make_default(unique_parent_id){
	$(unique_parent_id +' .first_wr .tab_content_right .detail_ip_type').val('static');
	$(unique_parent_id +' .first_wr .detail_status').html('');
	$(unique_parent_id +' .first_wr .detail_desc').html('');
	$(unique_parent_id +' .first_wr .detail_ifname').html('');
	$(unique_parent_id +' .text').val('');
	$(unique_parent_id +' .text').removeAttr('disabled').removeClass('disabled');
	$(unique_parent_id +' .first_wr .interface_list').html('');
	$(unique_parent_id +' .second_wr .ip_list_ul').html('');
	$(unique_parent_id +' .first_wr .tab_content_right button').removeClass('blue').addClass('disabled');
	$(unique_parent_id +' .first_wr .tab_content_left_main .btn_wraper button').removeClass('blue').addClass('disabled');
	$(unique_parent_id +' .first_wr .tab_content_left_main .ifname_status_b button strong').html('Disable interface');
	$(unique_parent_id +' .second_wr  button').removeClass('blue').addClass('disabled');
	$(unique_parent_id +' .delete_team_wr').hide();
	$(unique_parent_id +' .delete_team_wr button').removeAttr('class').addClass('btn disabled');
}