var cntb_success = 0;
function initialize_cntb(ip_id){
	var unique_parent_id = '#network_content__incend__'+ ip_id+' .network_cntb_tab';
	var loader_selector = unique_parent_id + ' .initializer';
	$(loader_selector).hide();

	if ($(unique_parent_id + ' .tab_content_left_main .interface_list li').length || $(unique_parent_id + ' .initializer').css('display') == 'block' ) {
		return
	}
	
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	var ip = replace_with(ip_id, '_', '.');
	$(unique_parent_id + ' .refresh a').attr('onclick', 'cntb_make_default("'+unique_parent_id+'");initialize_cntb("' + ip_id + '")');
	$(unique_parent_id +' .create_team_wr').attr('onclick','create_team("'+ unique_parent_id +'","'+ ip +'","'+ ip_id +'")');
	$(unique_parent_id +' .iptype').attr('onchange','cntb_ip_change("'+ unique_parent_id +'",$(this).val())');
	$(unique_parent_id +' .cntb_loader .status_link').attr('onclick','initialize_cntb("'+ip_id+'")');
	
	if( ostype == '4' ||  ostype == '3' ){
		$(unique_parent_id +' .teamname').attr('onkeyup','$(this).removeClass("error");digit_validate($(this))');	
	}
	
	// Get Interface List
	$(unique_parent_id+ ' .cntb_loader').hide();
	$(loader_selector).show();
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid='+sid+'&ip='+ip;
	
	get_interface_list(getdata, loader_selector, unique_parent_id, ostype);
	
	//ostype manipulation
	cntb_ostype_manipulation(ostype, loader_selector, unique_parent_id);
}

function get_interface_list(getdata, loader_selector, unique_parent_id, ostype){
	getdata += '&action=interfacelist&ostype='+ostype;
	$.ajax({
		url: '/python/network_teaming.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			init_loader_hide(loader_selector);
			if (data.status == '-2') {
				show_redirect_alert();
			}
			else if (data.status == '0') {
				$(unique_parent_id + ' .tab_content_left_main .interface_list').html(data.html);
				$(unique_parent_id + ' .tab_content_left_main .interface_list').fadeIn(300);
				if( ostype == '4' ){
					$(unique_parent_id + ' .os_4_teamname').html(data.next_team_name).show();
					$(unique_parent_id + ' .team_key').val(data.next_team_key);
				}
			}
			else {
				$(unique_parent_id + ' .global_error').fadeIn(300);
			}
		}
	});
}

function init_loader_hide(loader_selector){
	if ( cntb_success > 0) {
		$(loader_selector).hide();
		cntb_success = 0;
	}
	else{
		cntb_success += 1;
	}
}

function cntb_eth_prioritise(unique_parent_id,interface_name,element){
	
	if( $(unique_parent_id + ' .tab_content_left_main .interface_list li.selected').length == 8 && !$(element).hasClass('selected') ){
		return;
	}
	
	$(element).toggleClass('selected');
	if($(unique_parent_id + ' .tab_content_left_main .interface_list li.selected').length){
		$(unique_parent_id +' .create_team_wr button').removeClass('disabled').addClass('blue');
		$(unique_parent_id +' .priority_wr .content').removeClass('error');
	}
	else{
		$(unique_parent_id +' .create_team_wr button').removeClass('blue').addClass('disabled');
	}
	if($(element).hasClass('selected')){
		$(unique_parent_id +' .priority_wr .content ul').append('<li class="eth as_hide class_'+interface_name.split(" ").join("_")+ '" >' + interface_name +'</li>');
		$(unique_parent_id +  ' .priority_wr .class_'+interface_name.split(' ').join('_')).slideDown(300);
	}
	else{
		$(unique_parent_id +  ' .priority_wr .class_'+interface_name.split(' ').join('_')).slideUp(300,function(){
			$(unique_parent_id +  ' .priority_wr .class_'+interface_name.split(' ').join('_')).remove();
		});
	}
}

function cntb_ostype_manipulation(ostype, loader_selector, unique_parent_id){
	/* Windows = 1
	 * Linux = 2 
	 * Solaris = 3
	 * Freebsd = 4
	 */
	init_loader_hide(loader_selector);
	$(unique_parent_id + ' .fd_wr2 .linux_h').removeAttr('disabled').removeClass('disabled no_validate');
	$(unique_parent_id + ' .team_policy').removeClass('no_validate');
	$(unique_parent_id +' .solaris_team_policy_dl').hide();
	$(unique_parent_id +' .team_name_dl').show();
	if (ostype == '2') {
		$(unique_parent_id + ' .fd_wr2 .linux_h').addClass('no_validate');
		$(unique_parent_id + ' .fd_wr2 .linux_h').attr('disabled', 'disabled').addClass('disabled');
		var team_mode_html = '<option value="0">Round-Robin</option>\
							  <option value="1">Active-Backup</option>\
							  <option value="2">Balance XOR</option>\
							  <option value="3">Broadcast</option>\
							  <option value="4">802.3ad / LACP</option>\
							  <option value="5">Transmit Load Balancing (TLB)</option>\
							  <option value="6">Adaptive Load Balancing (ALB)</option>';
		$(unique_parent_id + ' .team_mode_select').html(team_mode_html);
		$(unique_parent_id + ' .team_status').html('Teaming/bonding driver is offload-capable');
	}
	else if( ostype == '3' ){
			var team_mode_html = '<option value="0">LINK_AGGREGATION - off</option>\
							  <option value="1">LINK_AGGREGATION - active</option>\
							  <option value="2">LINK_AGGREGATION - passive</option>';
			$(unique_parent_id +' .team_mode_select').html(team_mode_html);
			$(unique_parent_id +' .solaris_team_policy_dl').slideDown(300);
			$(unique_parent_id).animate({
				'height': '542px'
			},300);
			$(unique_parent_id +' .solaris_tip').show();
			$(unique_parent_id +' .tab_content_left_main').css('height','452px');
			$(unique_parent_id +' .initializer .overlay').css('height','98%');
			$(unique_parent_id + ' .team_status').html('Teaming/bonding driver is not offload-capable');
	}
	else if( ostype == '1' ){
		var team_mode_html =  '<option value="1">Active-Backup</option>\
							  <option value="2">Transmit Load Balancing (TLB)</option>\
							  <option value="3">802.3ad / LACP</option>\
							  <option value="4">Active-Backup with Failback</option>'
		$(unique_parent_id +' .team_mode_select').html(team_mode_html);
		$(unique_parent_id +' .iptype').val('1').attr('disabled','disabled').addClass('disabled');
		$(unique_parent_id +' .iptype').trigger('change');
		$(unique_parent_id + ' .team_status').html('Teaming/bonding driver is offload-capable');
		$(unique_parent_id +' .win_tip').show();
	}
	else if( ostype == '4' ){
		var team_mode_html =  '<option value="0">None / Default</option>\
							  <option value="1">Simple Round Robin</option>\
							  <option value="2">Active Failover</option>\
							  <option value="3">Load Balance</option>\
							  <option value="4">802.3AD LACP</option>\
							  <option value="5">Ether Channel</option>'
		$(unique_parent_id +' .team_mode_select').html(team_mode_html);
		$(unique_parent_id +' .iptype').trigger('change');
		$(unique_parent_id + ' .team_status').html('Teaming/bonding driver is not offload-capable');
		$(unique_parent_id +' .os_4_remove').remove();
		$(unique_parent_id +' .os_4').show();
	}
	else if( ostype == '5' || ostype == '6' ){
		$(unique_parent_id + ' .team_status').html('Teaming/bonding driver is not offload-capable');
	}
}

//Create Team
function create_team(unique_parent_id, ip, ipid){
	
	if( $(unique_parent_id+' .create_team_wr button').hasClass('disabled') ){
		return
	}
	
	var success = true;
	var postdata = 'sid='+GetCookie("chelsio_webgui_sid")+'&ip='+ip;
	
	$(unique_parent_id +' input.text:not(.no_validate)').each(function(){
		if( $.trim($(this).val()) == '' ){
			$(this).addClass('error');
			success = false;
		}
		else{
			$(this).removeClass('error');
			postdata+= '&'+$(this).attr('name')+'='+$(this).val();
		}
	});
	
	if( !$(unique_parent_id +' .priority_wr .content ul li').length ){
		$(unique_parent_id +' .priority_wr .content').addClass('error');
		success = false;	
	}
	else{
		var iflist_li_len = ($(unique_parent_id +' .priority_wr .content ul li').length)-1;
		var ifnamelist = '';
		$(unique_parent_id +' .priority_wr .content ul li').each(function(i){
			if (iflist_li_len == i) {
				ifnamelist += $.trim($(this).html());
			}
			else {
				ifnamelist += $.trim($(this).html()) + ',';
			}
		});
		postdata += '&ifname='+ifnamelist;
	}
	
	var ostype = $.trim($('#ip_' + ipid + ' .system_link').children('.ostype').val());
	if( ostype == '3' ){
		postdata += '&teampolicy='+$(unique_parent_id+' .team_policy').val();		
	}
	
	if( !success ){
		return
	}
	
	if( ostype == '4' ){
		postdata += '&teamname='+$(unique_parent_id+' .team_key').val();
	}
	
	postdata += '&mode='+$(unique_parent_id +' .team_mode_select').val()+'&action=create_team&iptype='+$(unique_parent_id + ' .iptype').val()+'&ostype='+ostype;
	$(unique_parent_id+ ' .btn_wraper ,'+ unique_parent_id +' .result').hide();
	$(unique_parent_id+ ' .team_action_status').fadeIn(300);
	$.ajax({
		url: '/python/network_teaming.py',
		type: 'POST',
		cache: false,
		data: postdata,
		success: function(status){
			$(unique_parent_id + ' .btn_wraper ,' + unique_parent_id + ' .result').hide();
			if (status == '-2') {
				show_redirect_alert();
			}
			else if (status == '0'){
				$(unique_parent_id + ' .team_success_status').fadeIn(300);
				$(unique_parent_id + ' .tab_content_left_main .interface_list').html('');
				$(unique_parent_id + ' .initializer').hide();
				if ($('#network_content__incend__' + ipid + ' .network_snc_tab .tab_content_left_main_list .interface_list li').length) {
					$('#network_content__incend__' + ipid + ' .network_snc_tab .tab_content_left_main_list .interface_list').html('');
				}
				initialize_cntb(ipid);
				cntb_make_default(unique_parent_id);
			}
			else if( status == 'Invalid IP' || status == 'Invalid Mask' ){
				$(unique_parent_id +' .team_iperror_status .status_msg').html(status);
				$(unique_parent_id + ' .team_iperror_status').fadeIn(300);
				if ( $.trim(status) == 'Invalid IP' ) {
					$(unique_parent_id +' .teamip').addClass('error');
				}
				else if( $.trim(status) == 'Invalid Mask' ){
					$(unique_parent_id +' .mask').addClass('error');					
				}
			}
			else{
				$(unique_parent_id + ' .team_error_status').fadeIn(300);
			}
		}
	});
}

function cntb_ip_change(unique_parent_id, iptype){
	if( iptype == '1' ){
		$(unique_parent_id +' .teamip, '+unique_parent_id +' .mask').addClass('disabled no_validate').attr('disabled','disabled').removeClass('error');
	}
	else{
		$(unique_parent_id +' .teamip, '+unique_parent_id +' .mask').removeClass('disabled no_validate').removeAttr('disabled');
	}	
}

function cntb_make_default(unique_parent_id){
	$(unique_parent_id + ' .tab_content_left_main .interface_list').html('');
	$(unique_parent_id +' .priority_wr .content ul').html('');
	$(unique_parent_id +' .iptype').trigger('change');
	//$(unique_parent_id +' .ip, '+unique_parent_id +' .mask').removeClass('disabled').removeAttr('disabled');
	$(unique_parent_id +' .text').val('');
	$(unique_parent_id +' .team_key').val('');
	$(unique_parent_id +' .os_4_teamname').html('');
	$(unique_parent_id +' .priority_wr .content ul').html('');
}
