$(document).ready(function(){
	var cookie_sid = GetCookie("chelsio_webgui_sid");
	if( cookie_sid ){
		window.location.replace('home.html');
	}
	else{
		$('.initializer').hide();
		page_init();
	}
	
	$('#login_form .validate').keyup(function(){
		$(this).removeClass('error');
	});
	
	$('#login_form').submit(function(event){
		event.preventDefault();
		validate();
	});
	
	$('#suser').click(function(){
		$('#status').hide();
	});
});

var timeOuts= new Array(); 

function validate(){
	var success = true;
	$('#login_form .validate').each(function(){
		if( $.trim($(this).val()) == '' ){
			$(this).addClass('error');
			success = false
		}
		else{
			$(this).removeClass('error');
		}
	});
	
	if(!success){
		return false;
	}
	
	var pass = $("#Password").val();
	var usr = $("#Username").val();
	var link = 'python/py_check_login.py';
	var ajax_status;
	var postdata = 'user='+usr+'&password='+pass;
	
	$('#login_btn').hide();
	$('#loading').show();
	
	$.ajax({
		url: link,
		type: 'POST',
		cache: false,
		data:postdata+'&action=login',
		success: function(success){
			$('#loading').hide();
			$('#login_btn').show();
			if (success == '-12'){
				display_login_error('Management Station is not licensed. <a href="javascript:void(0)" class="f_bold" onclick="show_mgmt_license_popup(\''+usr+'\')" >License It</a>');
			} 
			else if (success == '-3') {
				display_login_error('Internal Server Error');
			}
			else if (success == '-7'){
				display_login_error('Management Station is not running');
			}
			else if (success == '-11'){
				//display_login_error('Another session already exists for the '+usr+' user');
				//display_login_error('"'+usr+'" user is already in use by another session');
				$('.dummy').chLightbox('confirm', {
					cnfmTitle: 'Login',
		            cnfmMsg: '<span class="f_bold black_f">"'+usr+'"</span> user is already in use by another session. Do you want to perform force logout of the existing session?\
							 <p class="ch_msg">The existing session user may be connected to multiple machines and force logout will clear his existing session and allows you to login to the UM.</p>',
		            cnfmOk: 'Yes',
					cnfmCancel: 'No',
					successfn:'forceful_login("'+postdata+'")',
		            lbWidth: 420,
		            top_extra: 50
				});
			}	
			else if (success != '-1'){
				SetCookie("chelsio_webgui_sid", success.split('___')[0] , "2000", "/", "", "");
				SetCookie("chelsio_webgui_user", success.split('___')[1] , "2000", "/", "", "");
				window.location.replace('home.html');
			}else{
				display_login_error('Invalid Username or Password');
			}	
		}
	});	
}

function display_login_error(msg){
	$('#status').html(msg);
	$('#status').slideDown(300);
	clearAllTimeouts();
	timeOuts['login_error'] = setTimeout("$('#status').slideUp(300);",5000)
}

function forceful_login(postdata){
	$('.dummy').chLightbox('destroy');
	$('#login_btn').hide();
	$('#loading').show();
	postdata += '&action=f_logout';
	$.ajax({
		url: 'python/py_check_login.py',
		type: 'POST',
		cache: false,
		data: postdata,
		success: function(success){
			$('#loading').hide();
			$('#login_btn').show();
			if (success == '-3') {
				display_login_error('Internal Server Error');
			}
			else if (success == '-7'){
				display_login_error('Management Station is not running');
			}
			else if (success != '-1'){
				SetCookie("chelsio_webgui_sid", success.split('___')[0] , "2000", "/", "", "");
				SetCookie("chelsio_webgui_user", success.split('___')[1] , "2000", "/", "", "");
				window.location.replace('home.html');
			}else{
				display_login_error('Invalid Username or Password');
			}	
		}
	});
}

function show_mgmt_license_popup(user){
	$('.initializer span').html('Loading...');
	$('.initializer').show();
	$.get('license_mgmt.html', function(html){
		$('.initializer').hide();
		$('.initializer span').html('Initializing....');
		$('.dummy').chLightbox('ajax', {
			lbTitle: 'License the Management Station',
			lbOk: 'Close',
			ajaxHtml: html,
			successfn: "upload_license_file('"+user+"')",
			lbWidth: '665',
			top_extra: 50
		});
		$('#modalogBox .as_form_action').hide();
	});
}

function chk_caps_lock(e){
	if(capLock(e)){
		display_login_error('Caps Lock is on.');
	}
	else{
		$('#status').slideUp(300);
	}
}
