$(document).ready(function(){
	
	$('#home_content .service_disc .sd_main .result').click(function(){
		if( !$(this).hasClass('sd_tip') ){
			$(this).fadeOut(300);
		}
	});
	
	$('.sd_list ul li').live('dblclick',function(event){
		$('.sd_list ul li').removeClass('selected');		
		$(this).addClass('selected');
		add_agents_tofav();
		$('#sd_add_agent button').removeAttr('class').addClass('btn blue').removeAttr('disabled');
		event.stopPropagation();
	});
	
	$('.sd_list ul li').live('click',function(){
		$(this).toggleClass('selected');
		if( $('.sd_list ul li.selected').length ){
			$('#sd_add_agent button').removeAttr('class').addClass('btn blue').removeAttr('disabled');
		}
		else{
			$('#sd_add_agent button').removeAttr('class').addClass('btn disabled').attr('disabled','disabled');
		}
		
		if ($('.sd_list ul li.selected').length == 1) {
			$('#sd_connect button').removeAttr('class').addClass('btn blue').removeAttr('disabled');
		}
		else{
			$('#sd_connect button').removeAttr('class').addClass('btn disabled').attr('disabled','disabled');
		}		
	});
	
	$('#sd_connect button').click(function(){
		add_system_popup();
		$('#as_ch_lb_form #b_ip').val($.trim($('.sd_list ul li.selected').children('.ip').html()));
	});
	
	$('#os_type').change(function(){
		if( $(this).val() == 'all' ){
			$('#sd_hostip').show();
			$('#sd_search_ip_type').show();
		}
		else{
			$('#sd_hostip').hide();
			$('#hostip').val('');
			$('#sd_search_ip_type').hide();
		}
	});
	
	$('#sd_clear_agents').click(function(){
		if( $('#sd_clear_agents button').hasClass('disabled') ){
			return
		}
		
		$('#sd_systems').html('').hide();;
		$('.sd_main .btn_wraper button').removeAttr('class').addClass('btn disabled').attr('disabled','disabled');
		$('.sd_main .result').hide();
		$('.sd_main .sd_tip').html('Click Discover Agents to get the list of Agents').removeClass('ul_success').addClass('sd_tip').fadeIn(300);
	});
	
	$('#sd_add_agent').click(function(){
		add_agents_tofav();
	});
	
	$('#connected_agents_select').live('change',function(){
		$('#os_type').trigger('change');		
		$('#hostip').val('');
	});
	
	$('#home_content .service_disc .initializer').hide();
});

function fill_services_disc(){
	$('#subnet_dl,#os_type_dl,#sd_hostip').show();
	//If atleast one system is connected
	/*if( $('#m_tree_wrap .menu_status_wrapper').css('display') == 'none' ){
		var html = '<select id="connected_agents_select">\
						<option value="">Default</option>';
		$('#m_tree_wrap .system h1').each(function(){
			var ip_id = $(this).attr('id').replace('rm_pc_','');
			var ip = replace_with(ip_id, '_', '.');
			var hostname = $.trim($(this).html());
			html += '<option value="'+ip+'">'+hostname+'</option>';
		});
		html += '</select>';
		$('#connected_agents dd').html(html);
		$('#connected_agents').show();
	}
	else{
		$('#connected_agents').hide();
	}*/
	
	var html = '<select id="connected_agents_select">\
					<option value="">Default</option>';
	$('#m_tree_wrap .system h1').each(function(){
		var ip_id = $(this).attr('id').replace('rm_pc_','');
		var ip = replace_with(ip_id, '_', '.');
		var hostname = $.trim($(this).html());
		html += '<option value="'+ip+'">'+hostname+'</option>';
	});
	html += '</select>';
	$('#connected_agents dd').html(html);
	$('#connected_agents').show();
}

//var SdtimeOuts = new Array();
function add_agents_tofav(){
	
	if (!$('.sd_list ul li.selected').length) {
		return
	}

	$('.sd_main .result').hide();
	$('.sd_main .sd_action_status').fadeIn(300);
			
	var agents_count = 0;
	var postdata = 'sid='+GetCookie("chelsio_webgui_sid");
	$('.sd_list ul li.selected').each(function(){
		postdata += '&ip='+$.trim($(this).children('.ip').html());
		var hostname = $.trim($(this).children('.hostname').html());
		//Removing version from hostname, while adding to bookmarks list
		var ext = hostname.toLowerCase().split(':');
		if (ext.length == 2) {
			hostname = $.trim(hostname.split(':')[0]);
		}
		postdata += '&hostname='+hostname;
		postdata += '&ostype='+$.trim($(this).children('.ostype').val());	
		agents_count +=1 ;
	});
	
	postdata += '&total_agents='+agents_count;
	
	$.ajax({
		url: '/python/set_bookmarks.py',
		type: 'POST',
		cache: false,
		data: postdata,
		success: function(success){
			if (success == '-2') {
				show_redirect_alert();
			}
			else if (success == '0') {
				$('.sd_main  .sd_success_status .agent_count').html(String(agents_count));
				$('.sd_main .result').hide();
				$('.sd_main .sd_success_status').fadeIn(300);
			}
			else{
				$('.sd_main .result').hide();
				$('.sd_main .sd_error_status').fadeIn(300);
			}			
		}
	});
}

function service_discovery() {
	
	$('.service_disc .initializer .init_loader span').html('Loading..');
	$('.service_disc .initializer').show();
	
	var postdata = 'sid='+GetCookie("chelsio_webgui_sid");

	if( $('#os_type').val() != 'all' ){
		postdata += "&ostype="+$('#os_type').val();
	}
	
	
	if( $.trim($('#connected_agents_select').val()) != '' ){
		postdata += '&discover_through_agent=yes&agent_ip='+$.trim($('#connected_agents_select').val());
		var search_type = $('.sd_search_ip_type:checked').val();
		if ($.trim($('#hostip').val()) != '') {
			if (search_type == 'hostname') {
				postdata += '&dta_search_hostname=' + $.trim($('#hostip').val());
				postdata += '&dta_search_ip=';
			}
			else {
				postdata += '&dta_search_ip=' + $.trim($('#hostip').val());
				postdata += '&dta_search_hostname=';
				postdata += "&hostip="+$.trim($('#hostip').val());
			}
		}
		else{
			postdata += '&dta_search_hostname=';
			postdata += '&dta_search_ip=';
		}
	}
	else{
		postdata += '&discover_through_agent=no';
		var search_type = $('.sd_search_ip_type:checked').val();
		if ($.trim($('#hostip').val()) != '') {
			if (search_type == 'hostname') {
				postdata += '&dta_search_hostname=' + $.trim($('#hostip').val());
				postdata += '&dta_search_ip=';
			}
			else {
				postdata += '&dta_search_ip=' + $.trim($('#hostip').val());
				postdata += '&dta_search_hostname=';
				postdata += "&hostip="+$.trim($('#hostip').val());
			}
		}
		else{
			postdata += '&dta_search_hostname=';
			postdata += '&dta_search_ip=';
		}
	}
	
	$.ajax({
		url: 'python/py_service_discovery.py',
		type: 'GET',
		cache: false,
		data: postdata,
		success: function(xml){
			$('.service_disc .initializer').hide();
			if( xml == 'Invalid IP' ){
				show_error_msg('.service_disc', 'Invalid IP');
			}
			else if (xml == '-2') {
				show_redirect_alert();
			}
			else if ( xml != '-1') {
				$('#sd_systems').html('');
				
				$('host', xml).each(function(){
					var ip = $(this).find('ip').text();
					var ip_class = replace_with(ip,'.','_');
					
					var system = '<span class="ip">' + ip + "</span>&nbsp;:&nbsp;\
									<span class='hostname'>" +$(this).find('hostname').text() +'</span>\
									<input type="hidden" class="ostype" value="' +$(this).find('ostype').text()+ '" />';
					$('#sd_systems').append('<li class="' + $(this).find('ostype').text().toLowerCase() + ip_class +' ">' + system + '\
									<input type="hidden" class="port" value = "' +$(this).find('port').text() + '" /> </li>');
				});
				
				if ($('#sd_systems li').length) {
					$('#sd_clear_agents button').removeAttr('class').addClass('btn blue').removeAttr('disabled');
					$('.sd_main  .result').hide();
					$('#sd_systems').fadeIn(300);
				}
				else {
					//clearAllTimeouts();
					$('.sd_main  .sd_tip').html('No Agents found! Try again later').removeClass('ul_success').addClass('sd_tip').show();
				}
				$('.service_disc .initializer').hide();
			}
			else{
				$('.service_disc .initializer').hide();
				$('#sd_systems').chLightbox('destroy'); 
				show_error_msg('.service_disc', 'Service Discovery failed.');
			}
		}
	});
}