function fill_foiscsi_initiator_ports(ip_id){
	var unique_parent_id = '#foiscsi_initiator_content__incend__'+ ip_id+' .foiscsi_initiator_ports_tab';
	fo_ports_make_default(unique_parent_id);
	var sid = GetCookie("chelsio_webgui_sid");
	var ip = replace_with(ip_id, '_', '.');
	var getdata = 'sid='+sid+'&ip='+ip+'&req_type=desktop';
	$(unique_parent_id + ' .refresh a').attr('onclick', 'fill_foiscsi_initiator_ports("' + ip_id + '")');
	$(unique_parent_id + ' .discard_wr').attr('onclick', 'fill_foiscsi_initiator_ports("' + ip_id + '")');
	$(unique_parent_id + ' .set_btn_wr').attr('onclick','fo_ports_save_changes("'+ unique_parent_id +'","'+ getdata +'")');
	$(unique_parent_id + ' .port_up_btn_wr').attr('onclick','fo_ports_updown("'+ unique_parent_id +'","'+ getdata +'","up")');
	$(unique_parent_id + ' .port_down_btn_wr').attr('onclick','fo_ports_updown("'+ unique_parent_id +'","'+ getdata +'","down")');
	$(unique_parent_id + ' .clear_btn_wr').attr('onclick','fo_ports_clear("'+ unique_parent_id +'","'+ getdata +'")');
	$(unique_parent_id + ' .type_dd select').attr('onchange','fo_ports_get_ifconfig_values($(this), "'+ unique_parent_id +'", "'+ getdata +'")');
	
	//Generate t4 card select box
	var card_list = '';
	var total_cards = $('#ip_' + ip_id + ' .card').length-1;
	var serial_input = '';
	var card_list = '<select onchange="fo_get_t4_ports($(this), \''+getdata+'\', \''+unique_parent_id+'\')"><option value="null">Select One..</option>';
	$('#ip_' + ip_id + ' .card').each(function(i){
		var chiptype = $.trim($(this).children('.chiptype').val());
		if( chiptype == 'T4' ){
			var port_count = $(this).next().find('.menu_port_li').length;
			card_list += '<option value="'+i+'__'+port_count+'" >'+$(this).children('.tree_cardname').html()+'</option>';
		}
		
		if( i == total_cards ){
			card_list += '</select>';
			$(unique_parent_id+' .card_dd').html(card_list);
		}
	
	});
	$(unique_parent_id+' .initializer').hide();
}

function fo_get_t4_ports(element, getdata, unique_parent_id){
	fo_ports_enable_btn(unique_parent_id);
	$(unique_parent_id+' .type_dd select').val('null').trigger('change');
	if( $(element).val() == 'null' ){
		$(unique_parent_id+' [type=text]').val('');
		$(unique_parent_id+' select').val('null');
	}
	var ports_html = '<select onchange="fo_get_intial_data($(this), \''+unique_parent_id+'\', \''+getdata+'\')"><option value="null">Select One..</option>';
	var ports_count = parseInt($(element).val().split('__')[1]);
	for( i=0; i<ports_count; i++ ){
		ports_html += '<option value="'+i+'">Ports #'+i+'</option>';
	}
	ports_html += '</select>';
	$(unique_parent_id+' .ports_dd').html(ports_html);
}

function fo_get_intial_data(element, unique_parent_id, getdata){
	fo_ports_enable_btn(unique_parent_id);
	$(unique_parent_id+' .type_dd select').val('null').trigger('change');
	if( $(element).val() == 'null' ){
		$(unique_parent_id+' [type=text]').val('');
		$(unique_parent_id+' .port_val_text').val('');
		return;
	}
	$(unique_parent_id+' .initializer').show();
	var devno = $(unique_parent_id+' .card_dd select').val().split('__')[0];
	var ifid = $(unique_parent_id+' .ports_dd select').val();
	getdata += '&action=get&devno='+devno+'&ifid='+ifid;
	$.ajax({
		url: '/python/foiscsi_initiator_ports.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			if (data['status'] == '-2') {
				show_redirect_alert();
			}
			else if (data['status'] == '0') {
				var vlanid = $.trim(data.vlanid);
				if( vlanid == '0' ){
					vlanid = '';
				}
				$(unique_parent_id+' .vlan').val(vlanid).attr('name','value_'+vlanid);
				$(unique_parent_id+' .mtu').val(data.mtu).attr('name','value_'+data.mtu);
			}
			else if (data.status == '6') {
				show_error_msg(unique_parent_id, data.msg);
			}
			else{
				display_failed(unique_parent_id);
			}
		}
	});
}

function fo_ports_save_changes(unique_parent_id, getdata ){
	$(unique_parent_id+' .initializer').show();
	var devno = $(unique_parent_id+' .card_dd select').val().split('__')[0];
	var ifid = $(unique_parent_id+' .ports_dd select').val();
	var success = true;
	if( $.trim($(unique_parent_id+' .vlan').val()) == ''  ){
		/*$(unique_parent_id+' .vlan').addClass('error');
		success = false;*/
		var vlan = 'NIL';
	}
	else{
		var vlan = $(unique_parent_id+' .vlan').val();
	}
	
	if( $.trim($(unique_parent_id+' .mtu').val()) == ''  ){
		$(unique_parent_id+' .mtu').addClass('error');
		success = false;
	}
	else{
		var mtu = $(unique_parent_id+' .mtu').val();
	}
	
	getdata += '&action=set&devno='+devno+'&ifid='+ifid+'&vlan='+vlan+'&mtu='+mtu;
	
	var ntype = '';
	var sip = '';
	var mask = '';
	var gw = '';
	var setboth_flag = 'no';
	if( $(unique_parent_id+' .type_dd select').val() != 'null' ){
		ntype = $(unique_parent_id+' .type_dd select').val();
		if( ntype == 'ipv4' ){
			if( $.trim($(unique_parent_id+' .sip').val()) == ''  ){
				$(unique_parent_id+' .sip').addClass('error');
				success = false;
			}
			else{
				sip = $(unique_parent_id+' .sip').val();
			}
			
			if( $.trim($(unique_parent_id+' .mask').val()) == ''  ){
				$(unique_parent_id+' .mask').addClass('error');
				success = false;
			}
			else{
				mask = $(unique_parent_id+' .mask').val();
			}
			
			if( $.trim($(unique_parent_id+' .gw').val()) == ''  ){
				$(unique_parent_id+' .gw').addClass('error');
				success = false;
			}
			else{
				gw = $(unique_parent_id+' .gw').val();
			}
		}
		setboth_flag = 'yes';
	}
	
	if( !success ){
		$(unique_parent_id+' .initializer').hide();
		return
	}
	
	$(unique_parent_id+' [type=text]').removeClass('error');	
	getdata += '&ntype='+ntype+'&sip='+sip+'&mask='+mask+'&gw='+gw+'&setboth_flag='+setboth_flag;
	
	$.ajax({
		url: '/python/foiscsi_initiator_ports.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			var status = data.status
			$(unique_parent_id+' .initializer').hide();
			if (status == '-2') {
				show_redirect_alert();
			}
			else if (status == '0') {
				display_success(unique_parent_id);
				fo_ports_make_default(unique_parent_id);
			}
			else if (status == '6') {
				show_error_msg(unique_parent_id, data.msg);
			}
			else{
				display_failed(unique_parent_id);
			}
		}
	});	
}

function fo_ports_updown(unique_parent_id, getdata, action ){
	$(unique_parent_id+' .initializer').show();
	var devno = $(unique_parent_id+' .card_dd select').val().split('__')[0];
	var ifid = $(unique_parent_id+' .ports_dd select').val();
	getdata += '&action='+action+'&devno='+devno+'&ifid='+ifid;
	$.ajax({
		url: '/python/foiscsi_initiator_ports.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			var status = data.status;
			$(unique_parent_id+' .initializer').hide();
			if (status == '-2') {
				show_redirect_alert();
			}
			else if (status == '0') {
				display_success(unique_parent_id);
				fo_ports_make_default(unique_parent_id);
			}
			else if (status == '6') {
				show_error_msg(unique_parent_id, data.msg);
			}
			else{
				display_failed(unique_parent_id);
			}
		}
	});	
}

function fo_ports_clear(unique_parent_id, getdata){
	$(unique_parent_id+' .initializer').show();
	var devno = $(unique_parent_id+' .card_dd select').val().split('__')[0];
	var ifid = $(unique_parent_id+' .ports_dd select').val();
	var ntype = $(unique_parent_id+' .type_dd select').val();
	getdata += '&action=clear&devno='+devno+'&ifid='+ifid+'&ntype='+ntype;
	$.ajax({
		url: '/python/foiscsi_initiator_ports.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			var status = data.status;
			$(unique_parent_id+' .initializer').hide();
			if (status == '-2') {
				show_redirect_alert();
			}
			else if (status == '0') {
				display_success(unique_parent_id);
				fo_ports_make_default(unique_parent_id);
			}
			else if (status == '6') {
				show_error_msg(unique_parent_id, data.msg);
			}
			else{
				display_failed(unique_parent_id);
			}
		}
	});	
}

function fo_ports_make_default(unique_parent_id){
	$(unique_parent_id+' [type=text]').val('');
	$(unique_parent_id+' select').val('null');	
	$(unique_parent_id+' .type_dd select').val('null').trigger('change');
	$(unique_parent_id+' [type=text]').removeClass('error');
	enable_disable_btn(unique_parent_id+' .set_btn_wr button', 'blue', 'disable');
	enable_disable_btn(unique_parent_id+' .port_up_btn_wr button', 'blue', 'disable');
	enable_disable_btn(unique_parent_id+' .port_down_btn_wr button', 'blue', 'disable');
	enable_disable_btn(unique_parent_id+' .clear_btn_wr button', 'blue', 'disable');
}

function fo_ports_get_ifconfig_values(element, unique_parent_id, getdata, ip_id){
	
	if( $(element).val() == 'null' || $(unique_parent_id+' .card_dd select').val() == 'null' || $(unique_parent_id+' .ports_dd select').val() == 'null' ){
		enable_disable_btn(unique_parent_id+' .clear_btn_wr button', 'blue', 'disable');
	}
	else{
		enable_disable_btn(unique_parent_id+' .clear_btn_wr button', 'blue', 'enable');
	}
	
	if( $(element).val() != 'null' && $(element).val() != 'dhcp' ){
		$(unique_parent_id+' .ntype_v').removeAttr('disabled').removeClass('disabled');
	}
	else{
		$(unique_parent_id+' .ntype_v').val('').attr('disabled','disabled').addClass('disabled');
	}
	
	if( $(element).val() == 'null' || $(unique_parent_id+' .card_dd select').val() == 'null' || $(unique_parent_id+' .ports_dd select').val() == 'null' || $(element).val() == 'dhcp'  ){
		$(unique_parent_id+' .ntype_v').val('');
		return;
	}
	
	$(unique_parent_id+' .initializer').show();
	var devno = $(unique_parent_id+' .card_dd select').val().split('__')[0];
	var ifid = $(unique_parent_id+' .ports_dd select').val();
	getdata += '&action=get_ifconfig_values&devno='+devno+'&ifid='+ifid+'&ntype='+$(unique_parent_id+' .type_dd select').val();
	$.ajax({
		url: '/python/foiscsi_initiator_ports.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			if (data['status'] == '-2') {
				show_redirect_alert();
			}
			else if (data['status'] == '0') {
				$(unique_parent_id+' .sip').val(data.sip);
				$(unique_parent_id+' .mask').val(data.mask);
				$(unique_parent_id+' .gw').val(data.gw);
			}
			else{
				display_failed(unique_parent_id);
			}
		}
	});	
}

function fo_ports_enable_btn(unique_parent_id){
	if( $(unique_parent_id+' .card_dd select').val() != 'null' && $(unique_parent_id+' .ports_dd select').val() != 'null' ){
		enable_disable_btn(unique_parent_id+' .set_btn_wr button', 'blue', 'enable');
		enable_disable_btn(unique_parent_id+' .port_up_btn_wr button', 'blue', 'enable');
		enable_disable_btn(unique_parent_id+' .port_down_btn_wr button', 'blue', 'enable');
	}
	else{
		enable_disable_btn(unique_parent_id+' .set_btn_wr button', 'blue', 'disable');
		enable_disable_btn(unique_parent_id+' .port_up_btn_wr button', 'blue', 'disable');
		enable_disable_btn(unique_parent_id+' .port_down_btn_wr button', 'blue', 'disable');
	}
}
