function fill_egress_queue_map(ip_id){
	var unique_parent_id = '#egress_content__incend__' + ip_id+' .egress_queue_map_tab';
	$(unique_parent_id+' .initializer').show();
	
	//Reset
	$(unique_parent_id + ' .third_wr').html('');
	$(unique_parent_id+' .qid_li').html('');
	$(unique_parent_id+' .ifname_li').html('');
	enable_disable_btn(unique_parent_id+' .epc_map_wr button', 'yellow', 'disable');

	var sid = GetCookie("chelsio_webgui_sid");
	var ip = replace_with(ip_id, '_', '.');
	var getdata = 'sid='+sid+'&ip='+ip+'&req_type=desktop';
	
	$(unique_parent_id + ' .refresh a').attr('onclick', 'fill_egress_queue_map("' + ip_id + '")');
	$(unique_parent_id + ' .epc_map_wr button').attr('onclick', 'epm_map("' + unique_parent_id + '", "'+getdata+'", "'+ip_id+'")');

	eqm_get_initial_data(unique_parent_id, getdata);	
}

function eqm_get_initial_data(unique_parent_id, getdata){
	getdata += '&action=get_initial_data';
	$.ajax({
		url: '/python/egress_queue_map.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id + ' .initializer').hide();
			var error_msg = '';
			var enable_btn = true;
			
			if ( data.map_status == '-2' || data.qid_status == '-2' || data.ifstatus == '-2' ) {
				show_redirect_alert();
				enable_btn = false;
			}
			
			if (data.map_status == '0') {
				$(unique_parent_id + ' .third_wr').html(data.map_html);
			}
			else if (data.map_status == '1') {
				$(unique_parent_id + ' .third_wr').html('<p class="result">No <span class="green_f f_bold">Tx Queue to Scheduler class</span> Mapping present</p>');
			}
			else{
				error_msg += 'Failed to fetch the Queue Class list. <br>';
			} 
			
			if ( data.qid_status == '0' ) {
				$(unique_parent_id+' .qid_li').html(data.qid_html);
			}
			else{
				error_msg += "Failed to fetch the QId's.  <br>";
				enable_btn = false;
			}
			
			if ( data.ifstatus == '0' ) {
				$(unique_parent_id+' .ifname_li').html(data.ifname_html);
			}
			else{
				error_msg += 'Failed to fetch the interface list.';
				enable_btn = false;
			}
			
			if (error_msg != '') {
				show_error_msg(unique_parent_id, error_msg);
			}			
			
			if(enable_btn){
				enable_disable_btn(unique_parent_id+' .epc_map_wr button', 'yellow', 'enable');
			}
			else{
				enable_disable_btn(unique_parent_id+' .epc_map_wr button', 'yellow', 'disable');
			}
		}
	});
}

function epm_map(unique_parent_id, getdata, ip_id){
	$(unique_parent_id + ' .initializer').show();
	getdata += '&action=map';
	getdata += '&iff_name='+$(unique_parent_id+' .ifname_li select').val()+'&schedType='+$(unique_parent_id+' .class_li select').val();
	getdata += '&queueId='+$(unique_parent_id+' .qid_li select').val()+'&classId='+$(unique_parent_id+' .class_li select').val();
	$.ajax({
		url: '/python/egress_queue_map.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(status){
			$(unique_parent_id + ' .initializer').hide();
			if (status == '0') {
				fill_egress_queue_map(ip_id);
			}
			else if (status == '-2') {
				show_redirect_alert();
			}
			else {
				display_failed(unique_parent_id);
			}
		}
	});
}