var progress_timeOuts = new Array();
var progress_val;
var progress_flag = false;

$(document).ready(function(){
	
	adjustStyle(false,$(this).width());
    $(window).resize(function() {
        adjustStyle(true, $(this).width());
    });
	
	//help
	$('.um_about').click(function(){
		$('.um_about').chLightbox('destroy');
		$('.um_about').chLightbox('alert', {
			alertTitle: 'About',
			alertMsg: 'Chelsio Unified Wire Manager. Version 2.4',
			alertOk: 'OK',
			lbWidth: 420,
			top_extra: 50
		});
	});
	
 	$('a.effect').live('mouseenter',function(){
		$(this).animate({
			opacity : 0.3
		},500,function(){
			$(this).animate({
				opacity : 1
			},500);
		});
	});
	
	/*$(window).load( function(){
		layout_adjust();
	});*/
	
});

function is_authenticated(){
	
	/*$.get('python/is_authenticated',{},function(data){
		alert(data)
	});*/
	var cookie_sid = GetCookie("chelsio_webgui_sid");
	if( cookie_sid == null || cookie_sid == '' ){
		window.location.replace('index.html');
	}
	else{
		$('#username').html(GetCookie("chelsio_webgui_user"));
	}
}

function clearAllTimeouts(){  
   for( key in timeOuts ){  
     clearTimeout(timeOuts[key]);  
   }  
}

function clearSpecificTimeouts(tm_array){  
   for( key in tm_array ){  
     clearTimeout(tm_array[key]);  
   }  
}

function replace_with( variable , from , to ){
	// converting all '.' in ip to '_'
	while (variable.indexOf(from) != -1) {
		variable = variable.replace(from, to)
	}
	return variable
}

//Controls
function number_editor(element,max,min,inc,mode){
	var input = $(element).parent().parent().siblings('.input_wr').children('input.text');
	if( mode == 'inc' ){
		if (parseInt(input.val()) < min) {
			input.val(min);
		}
		if( parseInt(input.val()) < max ){
			input.val(parseInt(input.val())+inc);
			if (parseInt(input.val()) == max) {
				$(element).attr('src','/images/black/up_arrow_disabled.png').css('cursor','default');
				$(element).parent().next().children().attr('src','/images/black/down_arrow_hover.png').css('cursor','pointer');
			}
			else if( parseInt( input.val() ) > min ){
				$(element).parent().next().children().attr('src','/images/black/down_arrow_hover.png').css('cursor','pointer');
			}
			else{
				$(element).attr('src','/images/black/up_arrow_hover.png').css('cursor','pointer');
				$(element).parent().next().children().attr('src','/images/black/down_arrow_hover.png').css('cursor','pointer');
			}
		}
		else{
			input.val(max);
			$(element).attr('src','/images/black/up_arrow_disabled.png').css('cursor','default');
		}
	}
	else if( mode == 'dec' ){
		if (parseInt(input.val()) > max) {
			input.val(max);
		}
		if( parseInt(input.val()) > min ){
			input.val(parseInt(input.val())-inc);
			if (parseInt(input.val()) == min ) {
				$(element).attr('src','/images/black/down_arrow_disabled.png').css('cursor','default');
				$(element).parent().prev().children().attr('src','/images/black/up_arrow_hover.png').css('cursor','pointer');
			}
			else if( parseInt(input.val() ) > max ){
				$(element).parent().prev().children().attr('src','/images/black/up_arrow_hover.png').css('cursor','pointer');
			}
			else{
				$(element).attr('src','/images/black/down_arrow_hover.png').css('cursor','pointer');
				$(element).parent().prev().children().attr('src','/images/black/up_arrow_hover.png').css('cursor','pointer');
			}
		}
		else{
			input.val(min);
			$(element).attr('src','/images/black/down_arrow_disabled.png').css('cursor','default');
		}
	}
	else if(mode == 'blur') {
		if( parseInt($(element).val()) > max || parseInt($(element).val()) < min || $.trim($(element).val()) == '' ){
			$(element).val($(element).attr('name').replace('value_',''));
			if (parseInt($(element).val()) > max) {
				$(element).parent().next().children('.up_arrow_wr').children('img').attr('src', '/images/black/up_arrow_disabled.png').css('cursor', 'default');
				$(element).parent().next().children('.down_arrow_wr').children('img').attr('src', '/images/black/down_arrow_hover.png').css('cursor', 'pointer');
				$(element).addClass('focus');
				setTimeout(function(){
					$(element).removeClass('focus');
				}, 5000)
			}
			else if( parseInt($(element).val()) < min ){
				$(element).parent().next().children('.down_arrow_wr').children('img').attr('src','/images/black/down_arrow_disabled.png').css('cursor','default');
				$(element).parent().next().children('.up_arrow_wr').children('img').attr('src','/images/black/up_arrow_hover.png').css('cursor','pointer');
				$(element).addClass('focus');
				setTimeout(function() {
				   $(element).removeClass('focus');
				}, 5000)
			}
		}
	}
	else if(mode == 'validate') {
		$(element).removeClass('focus');
		var is_digit = /^\d+$/;	
		if (!is_digit.test($(element).val())) {
			$(element).val($(element).val().substring(0,$(element).val().length-1));
		}	
	}
}

function show_redirect_alert(){
	setTimeout('session_redirect()', 5000);
	$('.dummy').chLightbox('destroy');
	$('.dummy').chLightbox('alert', {
		alertTitle: 'Error!',
		alertMsg: 'Your login session has expired. You will be redirected to the login page in 5 seconds.',
		alertOk: 'OK',
		successfn: 'session_redirect()',
		lbWidth: 420,
		top_extra: 50
	});
}

function session_redirect(){
	$('.dummy').chLightbox('destroy');
	$('#global_loader .init_loader span').html('Redirecting..');
	$('#global_loader').show();
	DeleteCookie( 'chelsio_webgui_sid' , "/", '' );
	DeleteCookie( 'chelsio_webgui_user' , "/", '' );
	window.location.replace('index.html');	
}

function show_socket_timeout_msg(error_code){
	if( error_code == '283' ){
		var msg = 'There was a timeout reading from the socket.This could be because the command took longer than the timeout, or the network connection to the managed system was lost.Remove the managed system and reconnect to get correct data.' 
	}
	else if( error_code == '284' ){
		var msg = "There was a timeout writing to the socket.This could be because the network connection to the managed system was lost.Refresh the system's data after a short delay, and check if any changes made were applied\nor remove and re-add the system after checking network connectivity to the managed system." 
	}
	$('.dummy').chLightbox('destroy');
	$('.dummy').chLightbox('alert', {
		alertTitle: 'Error!',
		alertMsg: msg,
		alertOk: 'OK',
		lbWidth: 420,
		top_extra: 50
	});
}

function adjustStyle(is_resize, width) {
    width = parseInt(width);
    if (width < 1152) {
		$("#size-stylesheet").attr("href", "css/fixed.css");
	}
	else{
		$("#size-stylesheet").attr("href", "css/elastic.css");
	}
	
	if(is_resize){
		layout_adjust();
	}
}

function show_loading(unique_parent_id, message){
	$(unique_parent_id + ' .default_loader span').html(message);
	$(unique_parent_id + ' .default_loader').show();
}

function hide_loading(unique_parent_id){
	$(unique_parent_id + ' .default_loader').hide();
}

function show_progressbar(unique_parent_id, value){
	$(unique_parent_id + ' .progressbass-wr').show();
	$(unique_parent_id + ' .ui-progress').css('width', value+'%');
	$(unique_parent_id + ' .ui-label .msg').html('Installing');
	$(unique_parent_id + ' .ui-label .value').html(value+'%');
	$(unique_parent_id + ' .progressbass-wr .ui-close').hide();
	progress_val = value
	
	//Change the color of the progress bar
	if( value == 20 ){
		$(unique_parent_id + ' .progressbass-wr .ui-progress-bar').removeClass('turq').addClass('vista');
	}
	else if( value == 50 ){
		$(unique_parent_id + ' .progressbass-wr .ui-progress-bar').removeClass('vista').addClass('warning');
	}
	
	//Stop recursion when 90
	if (value == 90 && !progress_flag){
		$(unique_parent_id + ' .progress_bar').removeClass().addClass('progress_bar ui-progress-bar ui-container transition');
		return;
	}
	
	//Stop recursion when 100
	if (value == 100) {
		$(unique_parent_id + ' .progress_bar').removeClass().addClass('progress_bar ui-progress-bar ui-container transition');
		$(unique_parent_id + ' .ui-progress').css('width', '100%');
		$(unique_parent_id + ' .ui-label .msg').html('Completed');
		$(unique_parent_id + ' .ui-label .value').html('100%');
		for( key in progress_timeOuts ){  
	     clearTimeout(progress_timeOuts[key]);  
	   	}
		progress_flag = false;
		$(unique_parent_id + ' .progressbass-wr .ui-close').fadeIn(300);
		return;
	}
	
	//speed manipulation
	if( value >= 0 && value < 15 ){
		$(unique_parent_id + ' .ui-label .msg').html('');
		$(unique_parent_id + ' .ui-label').show();
		var progress_sec = 50;
	}
	else if (value == 15 ) {
		$(unique_parent_id + ' .ui-label .msg').html('');
		var progress_sec = 5000;
	}
	else if (value >= 16 && value < 30 ) {
		var progress_sec = 50;
	}
	else if (value == 30 ) {
		var progress_sec = 5000;
	}
	else if (value >= 31 && value <= 60 ) {
		var progress_sec = 50;
	}
	else if (value >= 91 ) {
		for( key in progress_timeOuts ){  
	     clearTimeout(progress_timeOuts[key]);  
	   	}
		var progress_sec = 50;
	}
	else{
		var progress_sec = 500;
	}
	
	if( progress_flag ){
		var progress_sec = 50;
	}
	
	progress_timeOuts['progress_'+unique_parent_id] = setTimeout(function() {
	    show_progressbar(unique_parent_id,value+1);
	}, progress_sec);
}

function progress_complete(unique_parent_id){
	progress_flag = true;
	if( progress_val == 90 ){
		progress_val = 91;
	}
	
	for( key in progress_timeOuts ){  
    	clearTimeout(progress_timeOuts[key]);  
   	}
	
	show_progressbar(unique_parent_id,progress_val);
}

function show_error_info(unique_parent_id, error){
	$(unique_parent_id+' .error_info .msg').html(error);
	$(unique_parent_id+' .error_info').fadeIn(300);
}

function show_error_msg(unique_parent_id, msg){
	var html = '<div class="ch_popup error_info">\
					<div class="overlay"></div>\
					<div class="pop_wr">\
						<div class="pop_cross" onclick="$(this).parent().parent().parent().html(\'\');"></div>\
						<div class="center">\
							<p class="f_bold msg">'+msg+'</p>\
						</div>\
					</div>\
				</div>';
	$(unique_parent_id+' .overlay_disp_wr').html(html);
}

function display_failed(unique_parent_id){
	var html = '<div class="global_error">\
					<div class="overlay"></div>\
					<div class="init_loader">\
						<img src="images/black/cross.png" class="fl_left" />\
						<span class="red_f f_bold msg">Failed</span> - <a href="javascript:void(0)" class="close_link f_bold f_underline" onclick="$(this).parent().parent().parent().html(\'\');" >Close</a>\
					</div>\
				</div>'
	$(unique_parent_id+' .overlay_disp_wr').html(html);
}

function display_success(unique_parent_id){
	var html = '<div class="global_sucess xanw_status">\
					<div class="overlay"></div>\
					<div class="init_loader">\
						<img src="images/black/tick.png" class="fl_left" />\
						<span class="green_f f_bold">Success</span> - <a href="javascript:void(0)" class="close_link f_bold f_underline" onclick="$(this).parent().parent().parent().html(\'\');" >Close</a>\
				</div>'
	$(unique_parent_id+' .overlay_disp_wr').html(html);
}

function digit_validate(element){
	var is_digit = /^\d+$/;	
	if (!is_digit.test($(element).val())) {
		$(element).val($(element).val().substring(0,$(element).val().length-1));
	}
	$(element).removeClass('error')
}

/*function integer_validate(element){
	var is_digit = /^\d+$/;	
	if (!is_digit.test($(element).val())) {
		$(element).val($(element).val().substring(0,$(element).val().length-1));
	}
	$(element).removeClass('error')
 }*/

 function layout_adjust(){
 	$('.initializer').fadeOut(500, function(){
		page_init();
	});
 }

function page_init(){
	var duration = 500;
	$('#header').animate({
		'top' : '0px'
	}, duration);
	$('#footer').animate({
		'bottom' : '0px'
	}, duration);
	
	if( $('#size-stylesheet').attr('href') == 'css/elastic.css' ){
		$('.left_col').animate({
			'left' : '2%'
		}, duration);
		$('.left_top_nav').animate({
			'left' : '24%'
		}, duration);
		$('#right_content').animate({
			'left' : '24%'
		}, duration);
		
	}
	
	if($.browser.msie){
		height = '300px';
	}
	else{
		height = '60%';
	}
	
	$('.menu_status_wrapper').animate({
		'height' : height
	}, duration);
	
	//$('#home_content .ch_fn1:first').trigger('click');
}

function enable_disable_btn(unique_id, color_class, action){
	if( action == 'enable' ){
		$(unique_id).removeClass('disabled').removeAttr('disabled').addClass(color_class);
	}
	else if( action == 'disable' ){
		$(unique_id).removeClass(color_class).attr('disabled','disabled').addClass('disabled');
	}
	else{
		return -1
	}
}

function show_help(element){
	var help_file = $(element).prev().attr('onclick').split(',')[1].split("'")[1];
	var os_link = 'linux';
	if ($('.details h1.show').length) {
		var ip_id = $('.details h1.show').attr('id').replace('rm_pc_', '');
		var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
		if( ostype == '1' ){
			os_link = 'windows'
		}
		else if( ostype == '2' ){
			os_link = 'linux'
		}
		else if( ostype == '4' ){
			os_link = 'freebsd'
		}
		else if( ostype == '8' ){
			os_link = 'xen'
		}
	}
	
	$.get('help/'+os_link+'/'+help_file, function(html) {
		$('.dummy').chLightbox('ajax', {
			lbTitle: 'Help',
			lbCancel: 'OK',
			lbWidth: '585',
			ajaxHtml : html,
			initFn : '$(".as_form_cancel").addClass("as_hide_imp")',
			top_extra: 50
		});	
	});
}

function capLock(e){
	kc = e.keyCode?e.keyCode:e.which;
	sk = e.shiftKey?e.shiftKey:((kc == 16)?true:false);
	if(((kc >= 65 && kc <= 90) && !sk)||((kc >= 97 && kc <= 122) && sk)){
		return true;
	}
	else{
	return false;	 	
	}
}
