function fill_port_settings_details(ip_id){
	var menu_id = 'ip_'+ip_id;
	var port_index = parseInt($.trim($('#'+menu_id+' .menu_port_li a.selected').attr('class').replace('selected','').split('port_')[1]))+1;
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	
	if( ostype == '4' ){
		var freebds_port_index = $.trim($('#'+menu_id+' .menu_port_li a.selected').attr('rel').split('freebsd_p_idx_')[1]);
		port_index = freebds_port_index;
	}
	
	var unique_inc = $('#m_tree_wrap .tree .tree_ul a.selected').attr('name')+'end';
	var unique_parent_id = '#port0_content__'+ unique_inc + '__' + ip_id+' .port_settings_tab';
	$(unique_parent_id +' .initializer:first').hide();
	
	var ip = replace_with(ip_id,'_','.');
	var loader_selector = unique_parent_id +' .default_loader';
	
	if( $(loader_selector).css('display') == 'block' || $(unique_parent_id +' .global_error').css('display') == 'block' || $(unique_parent_id + ' .from_server').length ){
		return
	}
	
	//Initializing
	$(unique_parent_id +' .discard_wr').attr('onclick','portsettings_discard_changes("'+ unique_parent_id +'","'+ ip_id +'")');
	$(unique_parent_id +' .save_changes_wr').attr('onclick','portsettings_save_changes("'+ unique_parent_id +'","'+ ip +'","'+ ip_id +'")');
	$(unique_parent_id +' .global_error .status_link').attr('onclick','$("'+unique_parent_id +' .global_error").hide();fill_port_settings_details("'+ ip_id +'")');
	
	$(loader_selector).show();
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid='+sid+'&ip='+ip+'&port_index='+port_index+'&ostype='+ostype;
	
	if (!$(unique_parent_id + ' .from_server').length) {
		var card_element = $('#ip_' + ip_id + ' .selected').parent().parent().prev();
		var chiptype = $.trim($(card_element).children('.chiptype').val());
		var pciloc = $.trim($(card_element).children('.pciloc').val());
		$(unique_parent_id+' .pciloc').val(pciloc);
		var portcount = $(card_element).next().children('.menu_port_li').length;
		var connector = $.trim($('#ip_' + ip_id + ' .selected').parent().parent().prev().children('.connector').val());
		var phy_idx = $.trim($('#ip_' + ip_id + ' .selected').parent().parent().prev().children('.phy_idx').val());
		card_port_settings(unique_parent_id, getdata, loader_selector, pciloc, chiptype, portcount, connector, phy_idx);
	}
	else{
		$(loader_selector).hide();
	}
}

function card_port_settings(unique_parent_id,getdata,loader_selector,pciloc, chiptype, portcount, connector, phy_idx){
	getdata += "&pciloc="+pciloc+'&cardtype='+chiptype+'&portcount='+portcount +'&action=get_details&connector='+encodeURIComponent(connector)+"&phy_idx="+phy_idx;
	$.ajax({
		url: '/python/port_settings.py',
		type: 'GET',
		cache: false,
		data: getdata,
		dataType : 'json',
		success: function(data){
			$(loader_selector).hide();
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data != '-1') {
				var height = 105;
				$(unique_parent_id).animate({
					'height': height+data.height
				},300);
				$(unique_parent_id+' .port_settings_main').html(data.html);
				$(unique_parent_id+' .port_settings_main').fadeIn(300);
			}
			else {
				$(unique_parent_id +' .global_error').fadeIn(300);
			}
		}
	});
}

function portsettings_discard_changes(unique_parent_id,ip_id){
	$(unique_parent_id+ ' ul').removeClass('from_server');
	fill_port_settings_details(ip_id);	
}

function portsettings_save_changes(unique_parent_id, ip, ip_id ){
	$(unique_parent_id+' .result,'+unique_parent_id+' .btn_wraper').hide();
	$(unique_parent_id+' .port_s_action_status').fadeIn(300);
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	var menu_id = 'ip_'+ip_id;
	var port_index = parseInt($.trim($('#'+menu_id+' .menu_port_li a.selected').attr('class').replace('selected','').split('port_')[1]))+1;
	
	if( ostype == '4' ){
		var menu_id = 'ip_'+ip_id;
		var freebds_port_index = $.trim($('#'+menu_id+' .menu_port_li a.selected').attr('rel').split('freebsd_p_idx_')[1]);
		port_index = freebds_port_index;
	}
	
	var postdata = 'sid='+GetCookie("chelsio_webgui_sid")+'&ip='+ip+'&pciloc='+$(unique_parent_id+' .pciloc').val()+'&pinstance='+port_index+'&ostype='+ostype;
	var properties_count = 0;
	$(unique_parent_id+' select').each(function(){
		if( parseInt($(this).attr('class').replace('value_','')) != parseInt($(this).val()) ){
			postdata += '&propname='+$(this).attr('title');
			postdata += '&value='+$(this).val();
			properties_count += 1;
		}
	});
	$(unique_parent_id+' .port_settings_main input').each(function(){
		if( $(this).attr('name').replace('value_','') != $(this).val() ){
			postdata += '&propname='+$(this).attr('title');
			postdata += '&value='+$(this).val();
			properties_count += 1;
		}
	});
	postdata += '&properties_count='+properties_count;
	
	if(!properties_count){
		$(unique_parent_id+' .result,'+unique_parent_id+' .btn_wraper').hide();
		$(unique_parent_id+' .port_s_success_status').fadeIn(300);
		return
	}
	
	postdata += '&action=set_properties'
	$.ajax({
		url: '/python/port_settings.py',
		type: 'POST',
		cache: false,
		data: postdata,
		success: function(status){
			if (status == '-2') {
				show_redirect_alert();
			}
			else if (status == '0') {
				$(unique_parent_id + ' .result,' + unique_parent_id + ' .btn_wraper').hide();
				$(unique_parent_id + ' .port_s_success_status').fadeIn(300);
				$(unique_parent_id + ' ul').removeClass('from_server');
				fill_port_settings_details(ip_id);
			}
			else{
				$(unique_parent_id + ' .result,' + unique_parent_id + ' .btn_wraper').hide();
				$(unique_parent_id + ' .port_s_error_status').fadeIn(300);
			}
		}
	});	
}