function fill_bulk_port_config(){
	var unique_parent_id = '#bulk_content .bulk_port_config_tab';
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid=' + sid + '&req_type=desktop';
	
	//initializing
	$(unique_parent_id +' .refresh').attr('onclick','fill_bulk_port_config()');
	$(unique_parent_id +' .blk_pc_set_port_props button').attr('onclick','blk_pc_set_port_props("'+unique_parent_id+'", "'+getdata+'", $(this) )');
	$(unique_parent_id +' .blk_pc_discard button').attr('onclick','blk_pc_discard_changes("'+unique_parent_id+'")');
	
	$(unique_parent_id+' .group_wr select').removeClass('error').val('');
	$(unique_parent_id+' .ostype_li').html('&nbsp;');
	$(unique_parent_id+' .gp_type').html('&nbsp;');
	$(unique_parent_id+' .row_div_wr .grid').html('');
	$(unique_parent_id+' .pnotes_wr').hide();
	$(unique_parent_id+' .row_div_wr').slideUp(300); 
	$(unique_parent_id+' .third_wr').slideUp(300);
	$(unique_parent_id).animate({
		'height' : '150px'
	},300);
	blk_pc_get_data(unique_parent_id, getdata);
}

function blk_pc_get_data(unique_parent_id, getdata){
	
	$(unique_parent_id + ' .initializer').show();
	getdata += '&action=get_initial_data';

	$.ajax({
		url: '/python/bulk_port_config.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			
			$(unique_parent_id + ' .initializer').hide();
			if( data.status == '-2' ){
				show_redirect_alert()
			}
			else if (data.status == '-1') {
				display_failed(unique_parent_id);
			}
			else if (data.status == '6') {
				show_error_msg(unique_parent_id, data.msg);
			}
			else if (data.status == '0') {
				$(unique_parent_id + ' .group_wr').html(data.html);
			}
		}
	});
}

function blk_pc_get_props(element){
	
	var unique_parent_id = '#bulk_content .bulk_port_config_tab ';
	if( $.trim(element.val()) == ''  ){
		$(unique_parent_id+' .ostype_li').html('&nbsp;');
		$(unique_parent_id+' .gp_type').html('&nbsp;');
		$(unique_parent_id+' .row_div_wr .grid').html('');
		$(unique_parent_id+' .pnotes_wr').hide();
		$(unique_parent_id+' .row_div_wr').slideUp(300); 
		$(unique_parent_id+' .third_wr').slideUp(300);
		$(unique_parent_id).animate({
			'height' : '150px'
		},300);
		return
	}
	else{
		var ostype = $(unique_parent_id+' .group_sel option:selected').attr('ostype');
		var gptype = $(unique_parent_id+' .group_sel option:selected').attr('gptype');
		$(unique_parent_id+' .ostype_li').html(ostype);
		$(unique_parent_id+' .gp_type').html(gptype);
	}
	
	$(unique_parent_id + ' .initializer').show();
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid=' + sid + '&req_type=desktop';
		getdata += '&action=get_props&ostype='+ostype+'&gptype='+gptype;

	$.ajax({
		url: '/python/bulk_port_config.py',
		dataType: 'json',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id + ' .initializer').hide();
			if (data.status == '-1') {
				display_failed(unique_parent_id);
			}
			else if( data.status == '0' ) {
				$(unique_parent_id + ' .grid').html(data.html);
				$(unique_parent_id+' .row_div_wr').show(); 
				$(unique_parent_id+' .pnotes_wr').show();
				$(unique_parent_id+' .third_wr').show();
				$(unique_parent_id).animate({
					'height' : data.height
				},300);
			}
			else if (data.status == '-6') {
				show_error_msg(unique_parent_id, data.error_msg);
				$(unique_parent_id+' .row_div_wr .grid').html('');
				$(unique_parent_id+' .pnotes_wr').hide();
				$(unique_parent_id+' .row_div_wr').slideUp(300); 
				$(unique_parent_id+' .third_wr').slideUp(300);
				$(unique_parent_id).animate({
					'height' : '150px'
				},300);
			}
		}
	});
}

function blk_pc_set_port_props(unique_parent_id, getdata, element){
	$(unique_parent_id +' .group_wr select').removeClass('error');
	$(unique_parent_id+' input').removeClass('error');
	
	var success = true;
	if( $.trim($(unique_parent_id +' .group_wr select').val()) == ''  ){
		$(unique_parent_id +' .group_wr select').addClass('error');
		success = false;	
	}
	
	if( !success ){
		show_error_msg(unique_parent_id, 'Please select a machine group.');
		$(unique_parent_id +' .group_wr select').focus();
		return false;
	}
	
	getdata += '&action=set_port_props&group_name='+$.trim($(unique_parent_id +' .group_wr select').val());
	
	var prop_str = '';
	$(unique_parent_id+' .grid input.text').each(function(){
		if( $.trim($(this).val()) != '' ){
			prop_str += $(this).attr('title')+'='+$.trim($(this).val())+',,';
		}
	});
	if( prop_str == '' ){
		show_error_msg(unique_parent_id, 'Please set atleast one property');
		return
	}
	
	if(!blk_gp_has_member({'unique_parent_id' : unique_parent_id, 'gp_class' : 'group_wr select'})){
		return false;
	}
	
	getdata += '&prop_str='+prop_str;
	$(unique_parent_id + ' .initializer').show();
	$.ajax({
		url: '/python/bulk_port_config.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			
			$(unique_parent_id + ' .initializer').hide();
			if( data.status == '-2' ){
				show_redirect_alert()
			}
			else if (data.status == '-1') {
				display_failed(unique_parent_id);
			}
			else if (data.status == '-6') {
				show_error_msg(unique_parent_id, data.error_msg);
			}
			else if (data.status == '100') {
				get_bulk_conf_status({
					'global_loader': 'show'
				});
			}
		}
	});
}

function blk_pc_discard_changes(unique_parent_id){
	if( $.trim($(unique_parent_id+ ' .group_sel').val()) != '' ){
		$(unique_parent_id+ ' .group_sel').trigger('change');
	}
	else{
		fill_bulk_port_config();
	}
}
