function fill_bulk_nw_config(){
	
	var unique_parent_id = '#bulk_content .bulk_nw_config_tab';
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid=' + sid + '&req_type=desktop';
	
	//initializing
	$(unique_parent_id +' .refresh').attr('onclick','fill_bulk_nw_config()');
	$(unique_parent_id +' .blk_nc_save button').attr('onclick','blk_nc_save("'+unique_parent_id+'", "'+getdata+'", $(this) )');
	
	$(unique_parent_id+' .group_wr select').removeClass('error').val('');
	$(unique_parent_id+' input').removeClass('error').val('');
	blk_nc_get_data(unique_parent_id, getdata);
}

function blk_nc_get_data(unique_parent_id, getdata){
	
	$(unique_parent_id + ' .initializer').show();
	getdata += '&action=get_initial_data';

	$.ajax({
		url: '/python/bulk_network_conf.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			
			$(unique_parent_id + ' .initializer').hide();
			if( data.status == '-2' ){
				show_redirect_alert()
			}
			else if (data.status == '-1') {
				display_failed(unique_parent_id);
			}
			else if (data.status == '6') {
				show_error_msg(unique_parent_id, data.msg);
			}
			else if (data.status == '0') {
				$(unique_parent_id + ' .group_wr').html(data.html);
			}
		}
	});
}

function blk_nc_save(unique_parent_id, getdata, element){
	$(unique_parent_id +' .group_wr select').removeClass('error');
	$(unique_parent_id+' input').removeClass('error');
	
	var success = true;
	if( $.trim($(unique_parent_id +' .group_wr select').val()) == ''  ){
		$(unique_parent_id +' .group_wr select').addClass('error');
		success = false;	
	}
	
	if( element.hasClass('blk_nc_set_mtu') ){
		if( $.trim($(unique_parent_id +' .mtu').val()) == '' ){
			$(unique_parent_id +' .mtu').addClass('error');
			success = false;
		}
		getdata += '&action_type=set_mtu';
	}
	else if( element.hasClass('blk_nc_set_vlan') ){
		if( $.trim($(unique_parent_id +' .vlan').val()) == '' ){
			$(unique_parent_id +' .vlan').addClass('error');
			success = false;
		}
		getdata += '&action_type=set_vlan';
	}
	else if( element.hasClass('blk_nc_set_dhcp') ){
		getdata += '&action_type=set_dhcp';
	}
	
	if( !success ){
		return false;
	}
	
	if(!blk_gp_has_member({'unique_parent_id' : unique_parent_id, 'gp_class' : 'group_wr select'})){
		return false;
	}
	
	$(unique_parent_id + ' .initializer').show();
	getdata += '&action=save_nw_conf&group_name='+$.trim($(unique_parent_id +' .group_wr select').val())+'&mtu='+$.trim($(unique_parent_id +' .mtu').val());
	getdata += '&vlan='+$.trim($(unique_parent_id +' .vlan').val());

	$.ajax({
		url: '/python/bulk_network_conf.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			
			$(unique_parent_id + ' .initializer').hide();
			if( data.status == '-2' ){
				show_redirect_alert()
			}
			else if (data.status == '-1') {
				display_failed(unique_parent_id);
			}
			else if (data.status == '-6') {
				show_error_msg(unique_parent_id, data.error_msg);
			}
			else if (data.status == '100') {
				get_bulk_conf_status({
					'global_loader': 'show'
				});
			}
		}
	});
}