function initialize_t4_option_rom(ip_id){
	
	var unique_parent_id = '#boot_content__incend__'+ ip_id+' .boot_t4_option_rom_tab';
	$(unique_parent_id+' .initializer:first').hide()
	var ip = replace_with(ip_id, '_', '.');
	
	var loader_selector = unique_parent_id + ' .boot_t4_option_processing';
	$(loader_selector).show();
	
	var file_id = 'boot_t4_option_'+ip_id+'_file';
	
	//initializing
	$(unique_parent_id +' .boot_t4_option_file_upload').attr('id',file_id);
	$(unique_parent_id +' .boot_t4_option_file_upload').attr('name',file_id);
	$(unique_parent_id +' input.boot_t4_option_input').attr('onclick','$("'+unique_parent_id+' .boot_t4_option_file_upload").trigger(\'click\');');
	$(unique_parent_id +' .boot_t4_option_file_upload').attr('onchange','$("'+unique_parent_id+' .boot_t4_option_input").val($(this).val());$("'+unique_parent_id+' .boot_iscsi_input").removeClass(\'error\')');
	$(unique_parent_id +' .boot_t4_option_write_rom').attr('onclick','boot_upload_t4_option_rom("'+unique_parent_id+'","'+file_id+'","'+ip+'")');
	$(unique_parent_id +' .erase_option_rom_wr').attr('onclick','boot_erase_t4_option_rom("'+unique_parent_id+'","'+ip+'")');
	
	var card_list = '';
	var total_cards = $('#ip_' + ip_id + ' .card').length-1;
	var card_list = '<select onchange="boot_t4_get_data($(this), \''+ unique_parent_id +'\',\''+ ip +'\')"><option value="null">Select One..</option>';
	$('#ip_' + ip_id + ' .card').each(function(i){
		var chiptype = $.trim($(this).children('.chiptype').val());
		if( chiptype == 'T4' ){
			card_list += '<option value="'+i+'__'+$(this).children('.pciloc').val()+'">'+$(this).children('.tree_cardname').html()+'</option>';	
		}
		
		if( i == total_cards ){
			card_list += '</select>';
			$(unique_parent_id+' .boot_cards_wr').html(card_list);
		}
	
	});
	
	$(loader_selector).hide();
}

function boot_upload_t4_option_rom(unique_parent_id, file_id, ip){
	
	var success = true;
	if( $.trim($(unique_parent_id +' input.boot_t4_option_input').val()) == ''  ){
		$(unique_parent_id +' .boot_t4_option_input').addClass('error');
		success = false;		
	}
	
	if( $.trim($(unique_parent_id +' .boot_cards_wr select').val()) == 'null'  ){
		$(unique_parent_id +' .boot_cards_wr select').addClass('error');
		success = false;		
	}
	
	if(!success){
		return false;
	}
	
	$(unique_parent_id+' .boot_t4_option_processing span').html('Uploading....');
	$(unique_parent_id+' .boot_t4_option_processing').show();
	var username = GetCookie("chelsio_webgui_user");
	var sid = GetCookie("chelsio_webgui_sid");
	var card_index = $(unique_parent_id+' .boot_cards_wr select').val().split('__')[0];
	var getdata = '?user='+username+'&name='+file_id+'&ip='+ip+'&sid='+sid+'&card_index='+card_index+'&action=upload_t4';
	jQuery.ajaxFileUpload({
		url: 'python/boot.py'+getdata,
		secureuri: true,
		fileElementId: file_id,
		dataType: 'xml',
		success: function(xml){
			$(unique_parent_id+' .file_input_main_wr input').val('');
			$(unique_parent_id+' .boot_t4_option_processing').hide();
			var status = $.trim($('status', xml).text());
			if (status == '-2') {
				show_redirect_alert();
			}
			else if (status == '0') {
				$(unique_parent_id+' .boot_t4_option_success').show();
				$(unique_parent_id+' .boot_cards_wr select').trigger('change');
			}
			else{
				$(unique_parent_id+' .boot_t4_option_error').show();
			}
		}
	});
}

function boot_t4_get_data(element, unique_parent_id, ip){
	if( $(element).val() == 'null' ){
		//iscsi_boot_make_default()
		$(unique_parent_id+' .rom_status').html('');
		$(unique_parent_id+' .boot_t4_option_write_rom button').removeClass('blue').addClass('disabled').attr('disabled','disabled');
		$(unique_parent_id+' .erase_option_rom_wr button').removeClass('blue').addClass('disabled').attr('disabled','disabled');
		enable_disable(unique_parent_id, 'disable', '.file_input_main_wr');
		return;
	}
	$(unique_parent_id+' .boot_t4_option_input').removeClass('error');
	$(element).removeClass('error');
	$(unique_parent_id+' .boot_t4_option_processing span').html('Loading....');
	$(unique_parent_id+' .boot_t4_option_processing').show();	
	var sid = GetCookie("chelsio_webgui_sid");
	var selected_val = $(unique_parent_id+' .boot_cards_wr select').val().split('__')
	var card_index = selected_val[0];
	var getdata = "sid="+sid+'&ip='+ip+'&action=get_t4_data&card_index='+card_index;
	
	$.ajax({
		url: '/python/boot.py',
		type: 'GET',
		cache: false,
		data: getdata,
		dataType: 'json',
		success: function(data){
			$(unique_parent_id+' .boot_t4_option_processing').hide();
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data == '-1') {
				$(unique_parent_id+' .boot_t4_option_error').show();
			}
			else{
				if( data.is_installed == 1 ){
					var version = '[ '+ data.version +' ]';
					$(unique_parent_id+' .rom_status').html('Option Rom is installed '+version);
					$(unique_parent_id+' .erase_option_rom_wr button').removeClass('disabled').addClass('blue').removeAttr('disabled');
					$(unique_parent_id+' .boot_t4_option_write_rom button').removeClass('blue').addClass('disabled').attr('disabled','disabled');
					enable_disable(unique_parent_id, 'disable', '.file_input_main_wr');
				}
				else{
					$(unique_parent_id+' .rom_status').html('No Option Rom is installed.');
					$(unique_parent_id+' .erase_option_rom_wr button').removeClass('blue').addClass('disabled').attr('disabled','disabled');
					$(unique_parent_id+' .boot_t4_option_write_rom button').removeClass('disabled').addClass('blue').removeAttr('disabled');
					enable_disable(unique_parent_id, 'enable', '.file_input_main_wr');
				}
			}	
		}
	});
}

function boot_erase_t4_option_rom(unique_parent_id, ip){
	
	if( $(unique_parent_id+' .erase_option_rom_wr button').hasClass('disabled') ){
		return;
	}	
	
	$(unique_parent_id+' .boot_t4_option_processing span').html('Erasing Option Rom....');
	$(unique_parent_id+' .boot_t4_option_processing').show();
	var sid = GetCookie("chelsio_webgui_sid");
	var card_index = $(unique_parent_id+' .boot_cards_wr select').val().split('__')[0]
	var getdata = 'sid='+sid+'&ip='+ip+'&action=erase_t4_rom&card_index='+card_index;
	$.ajax({
		url: '/python/boot.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(from_server){
			$(unique_parent_id+' .boot_t4_option_loader').hide();
			if (from_server == '-2') {
				show_redirect_alert();
			}
			else if (from_server == '-1') {
				$(unique_parent_id+' .boot_t4_option_error').show();
			}
			else{
				$(unique_parent_id+' .boot_cards_wr select').trigger('change');
				$(unique_parent_id+' .boot_t4_option_success').show();
			}	
		}
	});
}
function enable_disable(unique_parent_id, type, li_class){
	if( type == 'enable' ){
		$(unique_parent_id+' '+li_class+' input.text').removeAttr('disabled').removeClass('disabled');
		$(unique_parent_id+' '+li_class+' .file_input_wr').removeClass('disabled').addClass('yellow');
		$(unique_parent_id+' '+li_class+' .boot_t4_option_file_upload').removeAttr('disabled').addClass('file_enabled');
	}
	else{
		$(unique_parent_id+' '+li_class+' input.text').attr('disabled','disabled').addClass('disabled');
		$(unique_parent_id+' '+li_class+' .file_input_wr').addClass('disabled').removeClass('yellow');
		$(unique_parent_id+' '+li_class+' .boot_t4_option_file_upload').attr('disabled','disabled').removeClass('file_enabled');
	}
}
