function initialize_t4_bc(ip_id){
	var unique_parent_id = '#boot_content__incend__'+ ip_id+' .boot_t4_boot_config_tab';
	$(unique_parent_id + ' .initializer:first').hide();
	var ip = replace_with(ip_id, '_', '.');
	var sid = GetCookie("chelsio_webgui_sid");
	
	var loader_selector = unique_parent_id + ' .boot_t4_conf_processing';
	$(loader_selector).show();
	
	//initializing
	$(unique_parent_id +' .pxe_bt_fn_select').attr('onchange','boot_toggle_pxe_fn($(this),"'+ unique_parent_id +'")');
	$(unique_parent_id +' .bt_t4_options input').attr('onclick','boot_toggle_t4_option($(this),"'+ unique_parent_id +'")');
	$(unique_parent_id +' .bt_fcoe_options input').attr('onclick','boot_toggle_fcoe_option($(this),"'+ unique_parent_id +'")');
	$(unique_parent_id +' .bt_iscsi_options input').attr('onclick','boot_toggle_iscsi_option($(this),"'+ unique_parent_id +'")');
	$(unique_parent_id +' .bt_t4_cfg_discover_wr').attr('onclick','boot_discover_targets("'+ unique_parent_id +'","'+ sid +'","'+ ip +'")');
	$(unique_parent_id +' .bt_t4_adapter_cfg_save_wr').attr('onclick','boot_adapter_save_changes("'+ unique_parent_id +'","'+ sid +'","'+ ip +'")');
	$(unique_parent_id +' .bt_t4_pxe_save_wr').attr('onclick','boot_pxe_save_changes("'+ unique_parent_id +'","'+ sid +'","'+ ip +'")');
	$(unique_parent_id +' .bt_t4_fcoe_save_wr').attr('onclick','boot_fcoe_save_changes("'+ unique_parent_id +'","'+ sid +'","'+ ip +'")');
	$(unique_parent_id +' .bt_t4_iscsi_save_wr').attr('onclick','boot_iscsi_save_changes("'+ unique_parent_id +'","'+ sid +'","'+ ip +'")');
	$(unique_parent_id +' .bt_t4_cfg_discard_wr').attr('onclick','$(\''+unique_parent_id+' .b_conf_card_wr select\').trigger(\'change\');');
	$(unique_parent_id +' .bt_t4_fboot_discard_wr').attr('onclick','bt_t4_fboot_discard("'+ unique_parent_id +'")');
	$(unique_parent_id +' .bt_t4_iscsi_discard_wr').attr('onclick','bt_t4_iscsi_discard("'+ unique_parent_id +'")');
	//$(unique_parent_id +' .bt_iscsi_init_chap').attr('onchange','bt_toggle_i_init_chap("'+ unique_parent_id +'", $(this).val())');
	$(unique_parent_id +' .bt_iscsi_net_port_ipmethod').attr('onchange','bt_toggle_i_net_ipmethod("'+ unique_parent_id +'", $(this).val())');
	
	//Generate t4 card select box
	var card_list = '';
	var total_cards = $('#ip_' + ip_id + ' .card').length-1;
	var serial_input = '';
	var card_list = '<select class="mgn_l10" onchange="get_boot_t4_properties($(this), \''+ unique_parent_id +'\',\''+ ip +'\',\''+ sid +'\')"><option value="null">Select One..</option>';
	$('#ip_' + ip_id + ' .card').each(function(i){
		var chiptype = $.trim($(this).children('.chiptype').val());
		if( chiptype == 'T4' ){
			serial_input += '<input type="hidden" class="bcard_'+i+'" value="'+$(this).children('.serial_numb').val()+'">';
			var port_count = $(this).next().find('.menu_port_li').length;
			card_list += '<option value="'+i+'__'+$(this).children('.pciloc').val()+'" name="'+port_count+'">'+$(this).children('.tree_cardname').html()+'</option>';
		}
		
		if( i == total_cards ){
			card_list += '</select>';
			$(unique_parent_id+' .b_conf_card_wr').html(card_list+serial_input);
		}
	
	});
	
	//Generate PXE fun div's
	var pxe_fn_html = $(unique_parent_id+ ' .bt_conf_pxe_fun0').html();
	for( i = 1; i<=3; i++ ){
		$(unique_parent_id+' .bt_conf_pxe_fnwr').append('<div class="bt_conf_pxe_fun'+i+' bt_conf_pxe_fun as_hide">'+pxe_fn_html+'</div>');
	}
	
	//Generate fcoe timeout select box
	var bt_fcoe_timeout = '<select class="bt_fcoe_timeout">';
	for( i=0; i <=59; i++ ){
		bt_fcoe_timeout += '<option value="'+i+'">'+i+'</option>';
	}
	bt_fcoe_timeout += '</select>';
	$(unique_parent_id+' .select_50').html(bt_fcoe_timeout);

	//Generate iscsi timeout select box
	var bt_iscsi_fn_disc = '<select class="bt_iscsi_fn_disc">';
	for( i=0; i <=59; i++ ){
		bt_iscsi_fn_disc += '<option value="'+i+'">'+i+'</option>';
	}
	bt_iscsi_fn_disc += '</select>';
	$(unique_parent_id+' .select_50_iscsi').html(bt_iscsi_fn_disc);
	
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	if( ostype == '5' ){
		$(unique_parent_id+' .bt_t4_options').hide();		
	}
	var getdata = 'sid='+sid+'&ip='+ip+'&action=get_fcoe_driver_status&ostype='+ostype;
	$.ajax({
		url: '/python/boot.py',
		type: 'GET',
		cache: false,
		data: getdata,
		dataType: 'json',
		success: function(from_server){
			$(unique_parent_id+' .boot_t4_conf_loader').hide();
			if (from_server == '-2') {
				show_redirect_alert();
			}
			else if (from_server == '-1') {
				$(unique_parent_id+' .boot_t4_conf_error').show();
			}
			else if( from_server == '-6' || String(from_server.loaded) == '-6' ){
				$(unique_parent_id +' .bt_t4_cfg_discover_wr button').removeClass('blue').addClass('disabled').attr('disabled','disabled');	
			}
			else if( from_server.loaded == '0' ){
				$(unique_parent_id +' .bt_t4_cfg_discover_wr button').removeClass('disabled').addClass('blue').removeAttr('disabled');
			} 
		}
	});
		
	//if freebsd disable the save buttons
	if( ostype == '4' ){
		show_error_msg(unique_parent_id, 'Updation of T4 boot values of Freebsd agent are not supported by UM, However UM will display the current T4 boot values.');
		$(unique_parent_id +' button').removeClass('blue').addClass('disabled').attr('disabled','disabled');
	}
}

function get_boot_t4_properties(element, unique_parent_id, ip, sid){
	
	$(unique_parent_id+' .bt_Set_default_chk').removeAttr('checked');
	$(unique_parent_id+' .pxe_bt_fn_select').val('0').trigger('change');
	$(element).removeClass('error');
	if( $(element).val() == 'null' ){
		boot_make_default(unique_parent_id);
		return false;
	}

	$(unique_parent_id+' [type=checkbox]').removeAttr('checked');
	//$(unique_parent_id+' .bt_conf_pxe_port').val('14');
	$(unique_parent_id+' .bt_f_port_dd select').val('14');
	$(unique_parent_id+' .bt_clr').html('&nbsp;');
	$(unique_parent_id+' .bt_fcoe_options input[value=btb_fn]').trigger('click');
	$(unique_parent_id+' .bt_t4_options input[value=pxe]').trigger('click');
	$(unique_parent_id + ' .bt_fcoe_targets_wr').removeClass('error');
	$(unique_parent_id + ' .bt_fcoe_luns_wr').removeClass('error');
	$(unique_parent_id+' .bt_targets_ul').html('');
	$(unique_parent_id+' .bt_lun_ul').html('');
	
	var pciloc = element.val().split('__')[1];
	$(unique_parent_id+' .bt_adp_pci_bus').html(pciloc.split(':')[0]);
	$(unique_parent_id+' .bt_adp_pci_dev').html(pciloc.split(':')[1].split('.')[0]);
	
	$(unique_parent_id+' .boot_t4_conf_processing span').html('Loading....');
	$(unique_parent_id+' .boot_t4_conf_processing').show();
	var card_index = $(unique_parent_id+' .b_conf_card_wr select').val().split('__')[0]; 
	var getdata = 'sid='+sid+'&ip='+ip+'&card_index='+card_index+'&action=get_t4_conf_data';
	$.ajax({
		url: '/python/boot.py',
		type: 'GET',
		cache: false,
		data: getdata,
		dataType: 'json',
		success: function(from_server){
			$(unique_parent_id+' .boot_t4_conf_loader').hide();
			if (from_server == '-2') {
				show_redirect_alert();
			}
			else if (from_server == '-1') {
				$(unique_parent_id+' .boot_t4_conf_error').show();
			}
			else{
				//Adapter Configuration
				$(unique_parent_id+ ' [name=bt_bios_status][value='+String(from_server.biosStatus)+']').trigger('click');
				$(unique_parent_id+ ' [name=bt_bios_status]').attr('title',from_server.biosStatus_propname);
				$(unique_parent_id+' .bt_init_platform').val(from_server.init_platform);
				//$(unique_parent_id+' .bt_adp_pci_bus').html(from_server.pcibus);
				//$(unique_parent_id+' .bt_adp_pci_dev').html(from_server.dev);
				$(unique_parent_id+' .bt_mode').val(from_server.mode);
				$(unique_parent_id+' .bt_edd').val(from_server.edd);
				$(unique_parent_id+' .bt_ebda').val(from_server.ebda);
				
				//PXE Configuration
				$(unique_parent_id+' .bt_p_bios_st').html(from_server.biosVersion);
				if(from_server.biosVersion == ""){
					$(unique_parent_id +' .bt_t4_iscsi_save_wr button').removeClass('blue').addClass('disabled').attr('disabled','disabled');
					$(unique_parent_id +' .bt_t4_pxe_save_wr button').removeClass('blue').addClass('disabled').attr('disabled','disabled');
					$(unique_parent_id +' .bt_t4_fcoe_save_wr button').removeClass('blue').addClass('disabled').attr('disabled','disabled');
					$(unique_parent_id +' .bt_t4_adapter_cfg_save_wr button').removeClass('blue').addClass('disabled').attr('disabled','disabled');
				}else{
					$(unique_parent_id +' .bt_t4_pxe_save_wr button').removeClass('disabled').addClass('blue').removeAttr('disabled');
					$(unique_parent_id +' .bt_t4_iscsi_save_wr button').removeClass('disabled').addClass('blue').removeAttr('disabled');
					$(unique_parent_id +' .bt_t4_fcoe_save_wr button').removeClass('disabled').addClass('blue').removeAttr('disabled');
					$(unique_parent_id +' .bt_t4_adapter_cfg_save_wr button').removeClass('disabled').addClass('blue').removeAttr('disabled');

				}	
				/*if( eval('from_server.pxeBIOS_0') ){
					$(unique_parent_id+' .bt_p_bios_st').html('( Enabled )').addClass('green_f').removeClass('red_f');	
				}
				else if( !eval('from_server.pxeBIOS_0') ){
					$(unique_parent_id+' .bt_p_bios_st').html('( Disabled )').addClass('red_f').removeClass('green_f');
				}*/
				
				//Display only the available values for port order
				var port_count = parseInt($(unique_parent_id+' .b_conf_card_wr option:selected').attr('name'));
				var port_o_val = port_count - 1;
				for (i = 0; i <=3; i++) {
					if( i > port_o_val ){
						$(unique_parent_id+' .port_select' ).children("option[value="+i+"]").hide();
					}
					else{
						$(unique_parent_id+' .port_select' ).children("option[value="+i+"]").show()
					}
				}
				
				for (i = 0; i <= 3; i++) {
					$(unique_parent_id+' .bt_conf_pxe_fnwr .bt_conf_pxe_fun'+i+' .bt_conf_pxe_bios').val(eval('from_server.pxeBIOS_'+i));
					$(unique_parent_id+' .bt_conf_pxe_fnwr .bt_conf_pxe_fun'+i+' .bt_conf_pxe_bios').attr('title',eval('from_server.pxeBIOS_propname'+i));
					//$(unique_parent_id+' .bt_conf_pxe_fnwr .bt_conf_pxe_fun'+i+' .bt_conf_pxe_ipv6').val(eval('from_server.pxeIPv6_'+i));
					//$(unique_parent_id+' .bt_conf_pxe_fnwr .bt_conf_pxe_fun'+i+' .bt_conf_pxe_ipv6').attr('title',eval('from_server.pxeIPv6_propname'+i));
					//$(unique_parent_id+' .bt_conf_pxe_fnwr .bt_conf_pxe_fun'+i+' .bt_conf_pxe_vlan').val(eval('from_server.pxeVlan_'+i));
					//$(unique_parent_id+' .bt_conf_pxe_fnwr .bt_conf_pxe_fun'+i+' .bt_conf_pxe_vlan').attr('title',eval('from_server.pxeVlan_propname'+i));
					if( $.trim(eval('from_server.pxeVlanId'+i)) == '' || String($.trim(eval('from_server.pxeVlanId'+i))) == '255' || String($.trim(eval('from_server.pxeVlanId'+i))) == '65535' ){
						var vlan_id = 0;
					}
					else{
						var vlan_id = eval('from_server.pxeVlanId'+i);
					}
					$(unique_parent_id+' .bt_conf_pxe_fnwr .bt_conf_pxe_fun'+i+' .bt_conf_pxe_vlan_id').val(vlan_id);
					$(unique_parent_id+' .bt_conf_pxe_fnwr .bt_conf_pxe_fun'+i+' .bt_conf_pxe_vlan_id').attr('title',eval('from_server.pxeVlanId_propname'+i));
					//$(unique_parent_id+' .bt_conf_pxe_fnwr .bt_conf_pxe_fun'+i+' .bt_conf_pxe_vlan_prio').val(eval('from_server.pxeVlanPriority_'+i));
					//$(unique_parent_id+' .bt_conf_pxe_fnwr .bt_conf_pxe_fun'+i+' .bt_conf_pxe_vlan_prio').attr('title',eval('from_server.pxeVlanPriority_propname'+i));
					
					//var current_count = 0;
					//$(unique_parent_id+' .bt_conf_pxe_fnwr .bt_conf_pxe_fun'+i+' .bt_conf_pxe_port').each(function(j){
					//	$(this).val(eval('from_server.pxePort_'+i+''+j));
					//	$(this).attr('title',eval('from_server.pxePort_propname'+i+''+j));
						
						//Display only the available ports
						//if (j > port_o_val) {
						//	$(this).addClass('as_hide');
						//}
						//else {
						//	$(this).removeClass('as_hide');
						//}
					
					//});
				}
				
				//FCOE Function Configuration
				$(unique_parent_id+' .bt_fcoe_boot_target').html(from_server.target);
				$(unique_parent_id+' .bt_fcoe_boot_target').attr('title',from_server.target_propname);
				$(unique_parent_id+' .bt_fcoe_boot_lun').html(from_server.lun);
				$(unique_parent_id+' .bt_fcoe_boot_lun').attr('title',from_server.lun_propname);
				$(unique_parent_id+' .bt_f_dev').html(from_server.devid);
				var ip_id = replace_with(ip, '.', '_');
				var firmwareVersion = $('#ip_' + ip_id + ' .card_'+$(element).val().split('__')[0]).children('.firmwareVersion').val();
				$(unique_parent_id+' .bt_f_fw').html(firmwareVersion);
				$(unique_parent_id+' .bt_f_mac').html(from_server.mac);
				$(unique_parent_id+' .bt_f_ctrl').html(from_server.ctrl_name);
				$(unique_parent_id+ ' [name=bt_fc_bios_update][value='+String(from_server.fcoeBios)+']').trigger('click');
				$(unique_parent_id+ ' [name=bt_fc_bios_update]').attr('title',from_server.fcoeBios_propname);
				if( from_server.fcoeBios ){
					$(unique_parent_id+' .bt_f_bios_st').html('( Enabled )').addClass('green_f').removeClass('red_f');	
				}
				else if( !from_server.fcoeBios ){
					$(unique_parent_id+' .bt_f_bios_st').html('( Disabled )').addClass('red_f').removeClass('green_f');
				}
				
				$(unique_parent_id+ ' .bt_fcoe_timeout').val(String(from_server.DiscoverTimeout));
				$(unique_parent_id+ ' .bt_fcoe_timeout').attr('title',from_server.DiscoverTimeout_propname);
				var wwpn_list = from_server.fcoewwpn.split(",");
				var html_str = '<ul class="horizontal head_ul">';
				html_str += '<li><h2>Port</h2></li>';
				html_str += '<li><h2 class="bg_none" >WWPN</h2></li>';
				html_str += '</ul>';
				for (var i=0; i<wwpn_list.length; i++){
					html_str += '<ul class="horizontal content_tbl clear">';
					html_str += '<li class="label">'+i+'</li>';
					html_str +='<li class="bg_none" >'+wwpn_list[i]+'</li>'
					html_str += '</ul>'
				}
				$(unique_parent_id+' .bt_fcoe_wwpn').html(html_str);
				for (i = 0; i <= 3; i++) {
					if( i > port_o_val ){
						$(unique_parent_id+' .bt_fc_port'+i).hide();
					}else{
						$(unique_parent_id+' .bt_fc_port'+i).show();
						$(unique_parent_id+ ' .bt_fc_port'+i).val($.trim(String(eval('from_server.fcoeport_'+i))));
						$(unique_parent_id+ ' .bt_fc_port'+i).attr('title',$.trim(eval('from_server.fcoeport_propname'+i)));
					}
				}

				// iSCSI details
				if( eval(from_server.iscsibios) ){
					$(unique_parent_id+' .bt_i_bios_st').html('( Enabled )').addClass('green_f').removeClass('red_f');	
				}
				else{
					$(unique_parent_id+' .bt_i_bios_st').html('( Disabled )').addClass('red_f').removeClass('green_f');
				}
				$(unique_parent_id+' .bt_i_fw').html(firmwareVersion);
				$(unique_parent_id+' .bt_i_dev').html(from_server.dev);
				$(unique_parent_id+' .bt_i_mac').html(from_server.mac);
				$(unique_parent_id+' .bt_i_ctrl').html(from_server.ctrl_name);
				$(unique_parent_id+' .bt_i_ports').html(port_count);

				// iSCSI function 
				$(unique_parent_id+' .bt_iscsi_fn_bios').val($.trim(String(eval(from_server.iscsibios))));

				for (i = 0; i <=3; i++) {
					if( i > port_o_val ){
						$(unique_parent_id+' .bt_iscsi_fn_port'+i).hide();
					}
					else{
						$(unique_parent_id+' .bt_iscsi_fn_port'+i).show();
						$(unique_parent_id+' .bt_iscsi_fn_port'+i).val($.trim(String(eval('from_server.iscsiport'+(i+1)+'bootorder'))));
					}
				}

				//$(unique_parent_id+' .bt_iscsi_fn_port0').val($.trim(String(eval(from_server.iscsiport1bootorder))));
				//$(unique_parent_id+' .bt_iscsi_fn_port1').val($.trim(String(eval(from_server.iscsiport2bootorder))));
				//$(unique_parent_id+' .bt_iscsi_fn_port2').val($.trim(String(eval(from_server.iscsiport3bootorder))));
				//$(unique_parent_id+' .bt_iscsi_fn_port3').val($.trim(String(eval(from_server.iscsiport4bootorder))));



				$(unique_parent_id+' .bt_iscsi_fn_disc').val($.trim(String(eval(from_server.iscsidisctime))));
				$(unique_parent_id+' .bt_iscsi_fn_chap').val($.trim(String(eval(from_server.t4chapmethod))));

				// iSCSI initiator 
				$(unique_parent_id+' .bt_iscsi_init_iqn').val($.trim(from_server.t4ininame));
				$(unique_parent_id+' .bt_iscsi_init_ch_initiator').val($.trim(String(eval(from_server.t4oschelsioini))));
				$(unique_parent_id+' .bt_iscsi_init_hdr_dgst').val($.trim(String(eval(from_server.t4headerdigest))));
				$(unique_parent_id+' .bt_iscsi_init_data_dgst').val($.trim(String(eval(from_server.t4datadigest))));
				$(unique_parent_id+' .bt_iscsi_init_chap').val($.trim(String(eval(from_server.t4chaptype))));
				$(unique_parent_id+' .bt_iscsi_init_chap_user').val($.trim(from_server.t4inichapusername));
				$(unique_parent_id+' .bt_iscsi_init_chap_pass').val($.trim(from_server.t4inichapuserpasswd));
				$(unique_parent_id+' .bt_iscsi_init_immediatedata').val($.trim(String(eval(from_server.t4immediatedata))));
				$(unique_parent_id+' .bt_iscsi_init_initalr2t').val($.trim(String(eval(from_server.t4initialr2t))));
				
				$(unique_parent_id+' .bt_iscsi_init_disc_tout').val($.trim(from_server.t4iscsidiscovertimeout));
				$(unique_parent_id+' .bt_iscsi_init_maxoutstandingr2t').val($.trim(from_server.t4maxoutstandingr2t));
				$(unique_parent_id+' .bt_iscsi_init_maxBurstLength').val($.trim(from_server.t4maxburstlength));
				$(unique_parent_id+' .bt_iscsi_init_firstburstlength').val($.trim(from_server.t4firstburstlength));
				$(unique_parent_id+' .bt_iscsi_init_d_time2retain').val($.trim(from_server.t4defaulttime2retain));
				$(unique_parent_id+' .bt_iscsi_init_d_time2wait').val($.trim(from_server.t4defaulttime2wait));
				

				// iSCSI network
				var portConfig = new Array();
				portConfig[1] = [ from_server.iscsiport1ipv6, from_server.iscsiport1ipmethod, from_server.iscsiport1vlanid, from_server.iscsiport1ip, from_server.iscsiport1mask, from_server.iscsiport1gw ]; 
				portConfig[2] = [ from_server.iscsiport2ipv6, from_server.iscsiport2ipmethod, from_server.iscsiport2vlanid, from_server.iscsiport2ip, from_server.iscsiport2mask, from_server.iscsiport2gw ]; 
				portConfig[3] = [ from_server.iscsiport3ipv6, from_server.iscsiport3ipmethod, from_server.iscsiport3vlanid, from_server.iscsiport3ip, from_server.iscsiport3mask, from_server.iscsiport3gw ]; 
				portConfig[4] = [ from_server.iscsiport4ipv6, from_server.iscsiport4ipmethod, from_server.iscsiport4vlanid, from_server.iscsiport4ip, from_server.iscsiport4mask, from_server.iscsiport4gw ]; 
				for (i = 1; i <= 4; i++) {
					var itm = eval($(unique_parent_id +' .bt_iscsi_net_port_opts input[value='+i+']'));
					itm.attr('onclick','bt_toggle_iscsi_net_port("'+ i +'", "'+ unique_parent_id +'", "'+ portConfig[i] +'")');
				}
				$(unique_parent_id +' .bt_iscsi_net_port_opts input[value=1]').trigger('click');
				
				// iSCSI boot 
				$(unique_parent_id+' .bt_iscsi_boot_portal1_ip').val($.trim(from_server.t4targetportal1_IPAddress));
				$(unique_parent_id+' .bt_iscsi_boot_portal1_port').val($.trim(String(eval(from_server.t4targetportal1_TCPPort))));
				//$(unique_parent_id+' .bt_iscsi_boot_portal2_ip').val($.trim(from_server.t4targetportal2_IPAddress));
				//$(unique_parent_id+' .bt_iscsi_boot_portal2_port').val($.trim(String(eval(from_server.t4targetportal2_TCPPort))));
				//$(unique_parent_id+' .bt_iscsi_boot_portal_pref').val($.trim(String(eval(from_server.t4preferredportal))));
				$(unique_parent_id+' .bt_iscsi_boot_tgt_chap_user').val($.trim(from_server.t4targetchapuser));
				$(unique_parent_id+' .bt_iscsi_boot_tgt_chap_pass').val(from_server.t4targetchappass);
				$(unique_parent_id+' .bt_iscsi_boot_tgt_lun_no').val($.trim(from_server.t4targetlun));
				$(unique_parent_id+' .bt_iscsi_boot_tgt_iqn').val($.trim(from_server.t4targetname));
				//from_server.t4inichapuserpasswd
			}	
		}
	});	
	
}

function boot_toggle_pxe_fn(element, unique_parent_id){
	$(unique_parent_id+ ' .bt_conf_pxe_fnwr .bt_conf_pxe_fun').hide();
	$(unique_parent_id+ ' .bt_conf_pxe_fnwr .bt_conf_pxe_fun'+$(element).val()).show();
	$(unique_parent_id+ ' .bt_pxe_fn').html('0'+$(element).val());
	var bios_val = $(unique_parent_id+ ' .bt_conf_pxe_fnwr .bt_conf_pxe_fun'+$(element).val()+' .bt_conf_pxe_bios').val();
	/*if( bios_val == '0' ){
		var bios_str = '( Disabled )';
		var bios_class = 'red_f';
		$(unique_parent_id+ ' .bt_p_bios_st').removeClass('green_f');
	}
	else{
		var bios_str = '( Enabled )';
		var bios_class = 'green_f';
		$(unique_parent_id+ ' .bt_p_bios_st').removeClass('red_f');
	}
	$(unique_parent_id+ ' .bt_p_bios_st').html(bios_str).addClass(bios_class);*/
} 

function boot_toggle_t4_option(element, unique_parent_id){
	$(unique_parent_id+' .bt_options').hide();
	$(unique_parent_id+' .bt_t4_cfg_discover_wr').hide();
	$(unique_parent_id+' .bt_'+$(element).val()).fadeIn(300);
	if( $(element).val() == 'fcoe' ){
		$(unique_parent_id+ ' [name=bt_type][value=btb_fn]').trigger('click');
		$(unique_parent_id).animate({
			height: '780px'
		});
	}
	else if( $(element).val() == 'iscsi' ){
		$(unique_parent_id+ ' [name=bt_type][value=btb_iscsi_fn]').trigger('click');
		$(unique_parent_id).animate({
			height: '830px'
		});
	}
	else{
		$(unique_parent_id).animate({
			height: '765px'
		});
	}
}

function boot_toggle_fcoe_option(element, unique_parent_id){
	$(unique_parent_id+' .bt_fcoe_t4_tab').hide();
	$(unique_parent_id+' .bt_t4_fboot_discard_wr').show();	
	$(unique_parent_id+' .bt_t4_fcoe_save_wr').show();	
	$(unique_parent_id+' .bt_t4_cfg_discover_wr').hide();
	$(unique_parent_id+' .'+$(element).val()).fadeIn(300);
	if( $(element).val() == 'btb_fn' ){
		$(unique_parent_id).animate({
			height: '780px'
		});		
	}
	else if( $(element).val() == 'btb_show_wwpn' ){
		$(unique_parent_id).animate({
			height: '780px'
		});		
		$(unique_parent_id+' .bt_t4_fboot_discard_wr').hide();	
		$(unique_parent_id+' .bt_t4_fcoe_save_wr').hide();	
	}
	else{
		$(unique_parent_id).animate({
			height: '890px'
		});
		$(unique_parent_id+' .bt_t4_cfg_discover_wr').show();	
	}
}

function boot_toggle_iscsi_option(element, unique_parent_id){
	$(unique_parent_id+' .bt_iscsi_t4_tab').hide();
	$(unique_parent_id+' .'+$(element).val()).fadeIn(300);
	if( $(element).val() == 'btb_iscsi_fn' ){
		$(unique_parent_id).animate({
			height: '830px'
		});		
	}
	else if( $(element).val() == 'btb_iscsi_initiator' ){
		$(unique_parent_id).animate({
			height: '1250px'
		});		
	}
	else if( $(element).val() == 'btb_iscsi_network' ){
		$(unique_parent_id).animate({
			height: '960px'
		});
	}
	else{
		$(unique_parent_id).animate({
			height: '1020px'
		});
	}
}

function bt_toggle_iscsi_net_port(ele, unique_parent_id, tmp_arr){
	var conf_arr = tmp_arr.split(",");
	$(unique_parent_id+' .bt_iscsi_net_port_ipv6').val($.trim(String(eval(conf_arr[0]))));
	$(unique_parent_id+' .bt_iscsi_net_port_ipmethod').val($.trim(String(eval(conf_arr[1]))));
	$(unique_parent_id+' .bt_iscsi_net_port_vlan').val($.trim(String(eval(conf_arr[2]))));
	$(unique_parent_id+' .bt_iscsi_net_port_ipaddr').val($.trim(conf_arr[3]));
	$(unique_parent_id+' .bt_iscsi_net_port_mask').val($.trim(conf_arr[4]));
	$(unique_parent_id+' .bt_iscsi_net_port_gateway').val($.trim(conf_arr[5]));
	$(unique_parent_id +' .bt_iscsi_net_port_ipmethod').trigger('change');
}

function boot_discover_targets(unique_parent_id, sid, ip){
	
	var ip_id = replace_with(ip, '.', '_');
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	//if freebsd disable discovery
	if (ostype == '4') {
		return
	}
	
	if( $(unique_parent_id+' .bt_t4_cfg_discover_wr button').hasClass('disabled') ){
		return;
	}
	
	$(unique_parent_id + ' .bt_fcoe_targets_wr').removeClass('error');
	$(unique_parent_id + ' .bt_fcoe_luns_wr').removeClass('error');
	
	if( $(unique_parent_id+' .b_conf_card_wr select').val() == 'null' ){
		$(unique_parent_id+' .b_conf_card_wr select').addClass('error');
		$(unique_parent_id+' .b_conf_card_wr select').focus();
		return false
	}
	
	$(unique_parent_id+' .boot_t4_conf_processing span').html('Discovering....');
	$(unique_parent_id+' .boot_t4_conf_processing').show();
	
	//changing the card index to suit for the fcoe card index
	//This is required since the listadapters and fcoe listadpaters lists the cards in reverse order
	var card_index = parseInt($(unique_parent_id+' .b_conf_card_wr select').val().split('__')[0]);
	var fcard_serialnumb_class = '.fcard_serialnumb_'+$(unique_parent_id+' .bcard_'+card_index).val();
	card_index = $(fcard_serialnumb_class).children('.index').val();
	
	var getdata = 'sid='+sid+'&ip='+ip+'&action=discover_targets&card_index='+card_index+'&ostype='+ostype;
	$.ajax({
	url: '/python/boot.py',
	type: 'GET',
	cache: false,
	data: getdata,
	dataType: 'json',
	success: function(from_server){
			$(unique_parent_id+' .boot_t4_conf_loader').hide();
			if (from_server == '-2') {
				show_redirect_alert();
			}
			else if (from_server == '-1') {
				$(unique_parent_id+' .boot_t4_conf_error').show();
			}
			else{
				$(unique_parent_id+' .bt_targets_ul').html(from_server.target_html);
				$(unique_parent_id+' .bt_lun_ul').html(from_server.lun_html);
			}
		}
	});	
}

function boot_show_lun(element, unique_parent_id, lunclass){
	$(unique_parent_id+' .bt_targets_ul li').removeClass('selected');
	$(element).addClass('selected');
	$(unique_parent_id+' .bt_lun_ul li').hide();
	$(unique_parent_id+' .bt_lun_ul li.'+lunclass).fadeIn(300);
	$(unique_parent_id+' .bt_lun_vendor').html('None');
	$(unique_parent_id+' .bt_lun_size').html('None');
}

function boot_select_lun(element, unique_parent_id){
	$(unique_parent_id+' .bt_lun_ul li').removeClass('selected');
	$(element).addClass('selected');
	$(unique_parent_id+' .bt_lun_vendor').html($(element).children('.vendor').val());
	$(unique_parent_id+' .bt_lun_size').html($(element).children('.size').val());
}

function boot_adapter_save_changes(unique_parent_id, sid, ip){
	
	var ip_id = replace_with(ip, '.', '_'); 
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());  
	//if freebsd disable saving
	if( ostype == '4' ){
		return
	}
	
	if( $(unique_parent_id+' .b_conf_card_wr select').val() == 'null' ){
		$(unique_parent_id+' .b_conf_card_wr select').addClass('error');
		$(unique_parent_id+' .b_conf_card_wr select').focus();
		return false
	}
	
	if ($(unique_parent_id + ' .bt_Set_default_chk').is(':checked')) {
		boot_set_default_settings(unique_parent_id, sid, ip);
		return true;
	}
	
	$(unique_parent_id+' .boot_t4_conf_processing span').html('Saving Changes....');
	$(unique_parent_id+' .boot_t4_conf_processing').show();
	var bt_bios_status = $(unique_parent_id+' input[name=bt_bios_status]:checked').val();
	var propname = $(unique_parent_id+' input[name=bt_bios_status]').attr('title');
	var propname1 = $(unique_parent_id+' .bt_init_platform').attr('title');
	var value1 = $(unique_parent_id+' .bt_init_platform').val();
	var card_index = $(unique_parent_id+' .b_conf_card_wr select').val().split('__')[0];
	var getdata = 'sid='+sid+'&ip='+ip+'&card_index='+card_index+'&action=save_t4_adapter_config&propname='+propname+'&value='+bt_bios_status;
	getdata += '&propname='+propname1+'&value='+value1;
	var propname1 = $(unique_parent_id+' .bt_mode').attr('title');
	var value1 = $(unique_parent_id+' .bt_mode').val();
	getdata += '&propname='+propname1+'&value='+value1;
	var propname1 = $(unique_parent_id+' .bt_edd').attr('title');
	var value1 = $(unique_parent_id+' .bt_edd').val();
	getdata += '&propname='+propname1+'&value='+value1;
	var propname1 = $(unique_parent_id+' .bt_ebda').attr('title');
	var value1 = $(unique_parent_id+' .bt_ebda').val();
	getdata += '&propname='+propname1+'&value='+value1;
	getdata += '&properties_count=5&ostype='+ostype;;
	$.ajax({
	url: '/python/boot.py',
	type: 'GET',
	cache: false,
	data: getdata,
	dataType: 'json',
	success: function(from_server){
			$(unique_parent_id+' .boot_t4_conf_loader').hide();
			if (from_server == '-2') {
				show_redirect_alert();
			}
			else if (from_server == '-1') {
				$(unique_parent_id+' .boot_t4_conf_error').show();
			}
			else if (from_server == '0') {
				$(unique_parent_id+' .b_conf_card_wr select').trigger('change');
			}
		}
	});
}

function boot_pxe_save_changes(unique_parent_id, sid, ip){
	
	var ip_id = replace_with(ip, '.', '_');
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	//if freebsd disable saving
	if( ostype == '4' ){
		return
	}
	
	if( $(unique_parent_id+' .b_conf_card_wr select').val() == 'null' ){
		$(unique_parent_id+' .b_conf_card_wr select').addClass('error');
		$(unique_parent_id+' .b_conf_card_wr select').focus();
		return false
	}
	
	$(unique_parent_id+' .boot_t4_conf_processing span').html('Saving Changes....');
	$(unique_parent_id+' .boot_t4_conf_processing').show();
	
	var card_index = $(unique_parent_id+' .b_conf_card_wr select').val().split('__')[0];
	var getdata = 'sid='+sid+'&ip='+ip+'&card_index='+card_index+'&action=save_t4_pxe_config&ostype='+ostype;
	var selected_fn = unique_parent_id+' .bt_conf_pxe_fun'+$(unique_parent_id+' .pxe_bt_fn_select').val();
	
	getdata += '&propname='+$(selected_fn+' .bt_conf_pxe_bios').attr('title');
	getdata += '&value='+$(selected_fn+' .bt_conf_pxe_bios').val();

	/*getdata += '&propname='+$(selected_fn+' .bt_conf_pxe_ipv6').attr('title');
	getdata += '&value='+$(selected_fn+' .bt_conf_pxe_ipv6').val();*/
	
	/*getdata += '&propname='+$(selected_fn+' .bt_conf_pxe_vlan').attr('title');
	getdata += '&value='+$(selected_fn+' .bt_conf_pxe_vlan').val();*/
	
	getdata += '&propname='+$(selected_fn+' .bt_conf_pxe_vlan_id').attr('title');
	getdata += '&value='+$(selected_fn+' .bt_conf_pxe_vlan_id').val();
	
	//getdata += '&propname='+$(selected_fn+' .bt_conf_pxe_vlan_prio').attr('title');
	//getdata += '&value='+$(selected_fn+' .bt_conf_pxe_vlan_prio').val();
	
	var property_count = 2;
	
	//$(selected_fn+' .bt_conf_pxe_port').each(function(){
	//	getdata += '&propname='+$(this).attr('title');
	//	getdata += '&value='+$(this).val();
	//});
	
	getdata += '&properties_count='+property_count
	$.ajax({
	url: '/python/boot.py',
	type: 'GET',
	cache: false,
	data: getdata,
	dataType: 'json',
	success: function(from_server){
			$(unique_parent_id+' .boot_t4_conf_loader').hide();
			if (from_server == '-2') {
				show_redirect_alert();
			}
			else if (from_server == '-1') {
				$(unique_parent_id+' .boot_t4_conf_error').show();
			}
			else if (from_server == '0') {
				$(unique_parent_id+' .b_conf_card_wr select').trigger('change');
			}
		}
	});
}

function boot_fcoe_save_changes(unique_parent_id, sid, ip){
	
	var ip_id = replace_with(ip, '.', '_');
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	//if freebsd disable saving
	if( ostype == '4' ){
		return
	}
	
	var success= true;
	if( $(unique_parent_id+' .b_conf_card_wr select').val() == 'null' ){
		$(unique_parent_id+' .b_conf_card_wr select').addClass('error');
		$(unique_parent_id+' .b_conf_card_wr select').focus();
		success = false
	}
	
	$(unique_parent_id+' .boot_t4_conf_processing span').html('Saving Changes....');
	$(unique_parent_id+' .boot_t4_conf_processing').show();
	
	var card_index = $(unique_parent_id+' .b_conf_card_wr select').val().split('__')[0];
	var getdata = 'sid='+sid+'&ip='+ip+'&card_index='+card_index+'&action=save_t4_fcoe_config&ostype='+ostype;
	
	if ($(unique_parent_id + ' [name=bt_type]:checked').val() == 'btb_fn') {
		getdata += '&propname=' + $(unique_parent_id + ' [name=bt_fc_bios_update]').attr('title');
		getdata += '&value=' + $(unique_parent_id + ' [name=bt_fc_bios_update]:checked').val();
		getdata += '&propname=' + $(unique_parent_id + ' .bt_fcoe_timeout').attr('title');
		getdata += '&value=' + $(unique_parent_id + ' .bt_fcoe_timeout').val();
		var property_count = 2+$(unique_parent_id + ' .bt_f_port_dd select').length;
		$(unique_parent_id + ' .bt_f_port_dd select').each(function(){
			getdata += '&propname=' + $(this).attr('title');
			getdata += '&value=' + $(this).val();
		});
	}
	else if ($(unique_parent_id + ' [name=bt_type]:checked').val() == 'btb_boot_conf') {
		if( !$(unique_parent_id + ' .bt_targets_ul li.selected').length ){
			$(unique_parent_id + ' .bt_fcoe_targets_wr').addClass('error');
			success = false;
		}
		if( !$(unique_parent_id + ' .bt_lun_ul li.selected').length ){
			$(unique_parent_id + ' .bt_fcoe_luns_wr').addClass('error');
			success = false;
		}
		
		getdata += '&propname=' + $(unique_parent_id + ' .bt_fcoe_boot_target').attr('title');
		getdata += '&value=' + $(unique_parent_id + ' .bt_targets_ul li.selected').children('.portwwn').val();
		getdata += '&propname=' + $(unique_parent_id + ' .bt_fcoe_boot_lun').attr('title');
		getdata += '&value=' + $(unique_parent_id + ' .bt_lun_ul li.selected').children('.lunid').val();
		var property_count = 2;
	}
	
	if(!success){
		$(unique_parent_id+' .boot_t4_conf_loader').hide();
		return false
	}
	
	getdata += '&properties_count='+property_count
	
	$.ajax({
	url: '/python/boot.py',
	type: 'GET',
	cache: false,
	data: getdata,
	dataType: 'json',
	success: function(from_server){
			$(unique_parent_id+' .boot_t4_conf_loader').hide();
			if (from_server == '-2') {
				show_redirect_alert();
			}
			else if (from_server == '-1') {
				$(unique_parent_id+' .boot_t4_conf_error').show();
			}
			else if (from_server == '0') {
				$(unique_parent_id+' .b_conf_card_wr select').trigger('change');
				$(unique_parent_id+' .bt_t4_options [value=fcoe]').trigger('click');
				$(unique_parent_id+' .bt_fcoe_options input:checked').trigger('click');
			}
		}
	});
}

function boot_iscsi_save_changes(unique_parent_id, sid, ip){
	
	var ip_id = replace_with(ip, '.', '_');
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	//if freebsd disable saving
	if( ostype == '4' ){
		return
	}
	
	var success= true;
	if( $(unique_parent_id+' .b_conf_card_wr select').val() == 'null' ){
		$(unique_parent_id+' .b_conf_card_wr select').addClass('error');
		$(unique_parent_id+' .b_conf_card_wr select').focus();
		success = false
	}
	
	$(unique_parent_id+' .boot_t4_conf_processing span').html('Saving Changes....');
	$(unique_parent_id+' .boot_t4_conf_processing').show();
	
	var card_index = $(unique_parent_id+' .b_conf_card_wr select').val().split('__')[0];
	var getdata = 'sid='+sid+'&ip='+ip+'&card_index='+card_index+'&action=save_t4_iscsi_config&ostype='+ostype;
	var bt_checked = $(unique_parent_id + ' [name=bt_type]:checked').val();
	if (bt_checked == 'btb_iscsi_fn') {
		getdata += '&propname=iscsibios';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_fn_bios').val();
		getdata += '&propname=iscsidisctime';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_fn_disc').val();
		getdata += '&propname=t4chapmethod';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_fn_chap').val();
		getdata += '&propname=iscsiport1bootorder';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_fn_port0').val();
		getdata += '&propname=iscsiport2bootorder';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_fn_port1').val();
		getdata += '&propname=iscsiport3bootorder';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_fn_port2').val();
		getdata += '&propname=iscsiport4bootorder';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_fn_port3').val();
		var property_count = 7;
	}
	else if (bt_checked == 'btb_iscsi_initiator') {
		getdata += '&propname=t4iscsiosini';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_init_ch_initiator').val();
		getdata += '&propname=t4headerdigest';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_init_hdr_dgst').val();
		getdata += '&propname=t4datadigest';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_init_data_dgst').val();
		getdata += '&propname=t4immediatedata';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_init_immediatedata').val();
		getdata += '&propname=t4initalr2t';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_init_initalr2t').val();
		getdata += '&propname=t4iscsidiscovertimeout';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_init_disc_tout').val();
		getdata += '&propname=t4maxoutstandingr2t';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_init_maxoutstandingr2t').val();
		getdata += '&propname=t4maxburstlength';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_init_maxBurstLength').val();
		getdata += '&propname=t4firstburstlength';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_init_firstburstlength').val();
		getdata += '&propname=t4defaulttime2retain';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_init_d_time2retain').val();
		getdata += '&propname=t4defaulttime2wait';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_init_d_time2wait').val();
		getdata += '&propname=t4chaptype';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_init_chap').val();
		getdata += '&propname=t4ininame';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_init_iqn').val();
		getdata += '&propname=t4inichapusername';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_init_chap_user').val();
		getdata += '&propname=t4inichapuserpasswd';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_init_chap_pass').val();
		
		
		var property_count = 13;
		if( $(unique_parent_id + ' .bt_iscsi_init_chap').val() != '0' ){
			if( $(unique_parent_id + ' .bt_iscsi_init_chap_user').val() == '' ){
				$(unique_parent_id + ' .bt_iscsi_init_chap_user').addClass('error');
				success = false;
			}
			else if( $(unique_parent_id + ' .bt_iscsi_init_chap_pass').val() == '' ){
				$(unique_parent_id + ' .bt_iscsi_init_chap_pass').addClass('error');
				success = false;
			}
		}
	}
	else if (bt_checked == 'btb_iscsi_network') {
		var port_id = $(unique_parent_id +' .bt_iscsi_net_port_opts input').val();
		getdata += '&propname=iscsiport'+port_id+'ipmethod';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_net_port_ipmethod').val();
		getdata += '&propname=iscsiport'+port_id+'ipv6';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_net_port_ipv6').val();
		getdata += '&propname=iscsiport'+port_id+'vlanid';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_net_port_vlan').val();
		getdata += '&propname=iscsiport'+port_id+'ip';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_net_port_ipaddr').val();
		getdata += '&propname=iscsiport'+port_id+'mask';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_net_port_mask').val();
		getdata += '&propname=iscsiport'+port_id+'gw';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_net_port_gateway').val();
		var property_count = 6;
		// if static => IP, mask are must 
	}
	else if (bt_checked == 'btb_iscsi_boot') {
		getdata += '&propname=t4targetlun';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_boot_tgt_lun_no').val();
		getdata += '&propname=t4targetname';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_boot_tgt_iqn').val();
		getdata += '&propname=t4targetchapuser';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_boot_tgt_chap_user').val();
		getdata += '&propname=t4targetchappass';
		getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_boot_tgt_chap_pass').val();
		//getdata += '&propname=t4preferredportal';
		//getdata += '&value=' + $(unique_parent_id + ' .bt_iscsi_boot_portal_pref').val();

		var portal1 = '1@' + $(unique_parent_id + ' .bt_iscsi_boot_portal1_ip').val();
		if ($(unique_parent_id + ' .bt_iscsi_boot_portal1_port').val() != '')
			portal1  += ':' + $(unique_parent_id + ' .bt_iscsi_boot_portal1_port').val();
		//var portal2 = '2@' + $(unique_parent_id + ' .bt_iscsi_boot_portal2_ip').val();
		//if ($(unique_parent_id + ' .bt_iscsi_boot_portal2_port').val() != '')
		//	portal2  += ':' + $(unique_parent_id + ' .bt_iscsi_boot_portal2_port').val();
		getdata += '&propname=t4targetportal';
		getdata += '&value=' + portal1;
		//getdata += '&propname=t4targetportal';
		//getdata += '&value=' + portal2;
		var property_count =5 ;
	}
	
	if(!success){
		$(unique_parent_id+' .boot_t4_conf_loader').hide();
		return false
	}
	
	getdata += '&properties_count='+property_count
	
	$.ajax({
	url: '/python/boot.py',
	type: 'POST',
	cache: false,
	data: getdata,
	dataType: 'json',
	success: function(from_server){
			$(unique_parent_id+' .boot_t4_conf_loader').hide();
			if (from_server == '-2') {
				show_redirect_alert();
			}
			else if (from_server == '-1') {
				$(unique_parent_id+' .boot_t4_conf_error').show();
			}
			else if (from_server == '0') {
				$(unique_parent_id+' .b_conf_card_wr select').trigger('change');
				$(unique_parent_id+' .bt_t4_options [value=iscsi]').trigger('click');
				$(unique_parent_id+' .bt_iscsi_options input[value='+String(bt_checked)+']').trigger('click');
			}
		}
	});
}

function boot_set_default_settings(unique_parent_id, sid, ip){
	
	var ip_id = replace_with(ip, '.', '_');
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	//if freebsd disable saving
	if( ostype == '4' ){
		return
	}
	
	$(unique_parent_id+' .boot_t4_conf_processing span').html('Saving Changes....');
	$(unique_parent_id+' .boot_t4_conf_processing').show();
	var card_index = $(unique_parent_id+' .b_conf_card_wr select').val().split('__')[0]; 
	var getdata = 'sid='+sid+'&ip='+ip+'&card_index='+card_index+'&action=set_default_t4_settings';
	$.ajax({
	url: '/python/boot.py',
	type: 'GET',
	cache: false,
	data: getdata,
	dataType: 'json',
	success: function(from_server){
			$(unique_parent_id+' .boot_t4_conf_loader').hide();
			if (from_server == '-2') {
				show_redirect_alert();
			}
			else if (from_server == '-1') {
				$(unique_parent_id+' .boot_t4_conf_error').hide();
			}
			else if (from_server == '0') {
				$(unique_parent_id+' .b_conf_card_wr select').trigger('change');
			}
		}
	});		
}

function boot_make_default(unique_parent_id){
	$(unique_parent_id+' [type=checkbox]').removeAttr('checked');
	//$(unique_parent_id+' [type=radio]:not([name=bt_options]):not([name=bt_type])').removeAttr('checked');
	$(unique_parent_id+' select').val('0');
	//$(unique_parent_id+' input').val('');
	//$(unique_parent_id+' .bt_conf_pxe_port').val('14');
	$(unique_parent_id+' .bt_f_port_dd select').val('14');
	$(unique_parent_id+' .bt_clr').html('&nbsp;');
	$(unique_parent_id+' .bt_fcoe_options input[value=btb_fn]').trigger('click');
	$(unique_parent_id+' .bt_t4_options input[value=pxe]').trigger('click');
	$(unique_parent_id + ' .bt_fcoe_targets_wr').removeClass('error');
	$(unique_parent_id + ' .bt_fcoe_luns_wr').removeClass('error');
	$(unique_parent_id+' .bt_targets_ul').html('');
	$(unique_parent_id+' .bt_lun_ul').html('');
}

function bt_t4_fboot_discard(unique_parent_id){
	$(unique_parent_id + ' .bt_fcoe_targets_wr').removeClass('error');
	$(unique_parent_id + ' .bt_fcoe_luns_wr').removeClass('error');
	$(unique_parent_id+' .b_conf_card_wr select').trigger('change');
}

function bt_t4_iscsi_discard(unique_parent_id){
	$(unique_parent_id + ' .bt_iscsi_init_iqn').removeClass('error');
	$(unique_parent_id + ' .bt_iscsi_init_chap_user').removeClass('error');
	$(unique_parent_id + ' .bt_iscsi_init_chap_pass').removeClass('error');
	$(unique_parent_id+' .b_conf_card_wr select').trigger('change');
}

function bt_toggle_i_init_chap(unique_parent_id, val){
	if(eval(val)){
		$(unique_parent_id + ' .bt_iscsi_init_chap_user').removeClass('disabled').removeAttr('disabled');
		$(unique_parent_id + ' .bt_iscsi_init_chap_pass').removeClass('disabled').removeAttr('disabled');
	}else{
		$(unique_parent_id + ' .bt_iscsi_init_chap_user').addClass('disabled').attr('disabled','disabled');
		$(unique_parent_id + ' .bt_iscsi_init_chap_pass').addClass('disabled').attr('disabled','disabled');
	}
} 
function bt_toggle_i_net_ipmethod(unique_parent_id, val){
	//if( eval($(unique_parent_id + ' .bt_iscsi_net_port_ipmethod').val())){
	if(eval(val)){
		$(unique_parent_id + ' .bt_iscsi_net_port_ipaddr').addClass('disabled').attr('disabled','disabled');
		$(unique_parent_id + ' .bt_iscsi_net_port_mask').addClass('disabled').attr('disabled','disabled');
		$(unique_parent_id + ' .bt_iscsi_net_port_gateway').addClass('disabled').attr('disabled','disabled');
	}else{
		$(unique_parent_id + ' .bt_iscsi_net_port_ipaddr').removeClass('disabled').removeAttr('disabled');
		$(unique_parent_id + ' .bt_iscsi_net_port_mask').removeClass('disabled').removeAttr('disabled');
		$(unique_parent_id + ' .bt_iscsi_net_port_gateway').removeClass('disabled').removeAttr('disabled');
	}
} 
