function initialize_iscsi_boot(ip_id){
	
	var unique_parent_id = '#boot_content__incend__'+ ip_id+' .iscsi_boot_option_tab';
	var ip = replace_with(ip_id, '_', '.');
	
	var loader_selector = unique_parent_id + ' .initializer';
	$(loader_selector).show();
	
	var file_id = 'boot_iscsi_'+ip_id+'_file';
	
	//initializing
	$(unique_parent_id +' .second_wr .boot_iscsci_file_upload').attr('id',file_id);
	$(unique_parent_id +' .second_wr .boot_iscsci_file_upload').attr('name',file_id);
	$(unique_parent_id +' .second_wr input.text').attr('onclick','$("'+unique_parent_id+' .boot_iscsci_file_upload").trigger(\'click\');');
	$(unique_parent_id +' .second_wr .boot_iscsci_file_upload').attr('onchange','$("'+unique_parent_id+' .boot_iscsi_input").val($(this).val());$("'+unique_parent_id+' .boot_iscsi_input").removeClass(\'error\')');
	$(unique_parent_id +' .second_wr .boot_write_rom').attr('onclick','boot_upload_iscsi_option_rom("'+unique_parent_id+'","'+file_id+'","'+ip+'")');
	$(unique_parent_id +' .third_wr .erase_option_rom_wr').attr('onclick','boot_erase_option_rom("'+unique_parent_id+'","'+ip+'")');
	$(unique_parent_id +' .third_wr .erase_boot_settings_wr').attr('onclick','boot_erase_settings("'+unique_parent_id+'","'+ip+'")');
	$(unique_parent_id +' .boot_save_changes_wr').attr('onclick','boot_save_changes("'+unique_parent_id+'","'+ip+'")');
	$(unique_parent_id +' .discard_changes_wr').attr('onclick','boot_discard_changes("'+unique_parent_id+'")');
	
	var card_list = '';
	var total_cards = $('#ip_' + ip_id + ' .card').length-1;
	var card_list = '<select onchange="boot_get_data($(this), \''+ unique_parent_id +'\',\''+ ip +'\')"><option value="null">Select One..</option>';
	$('#ip_' + ip_id + ' .card').each(function(i){
		
		var chiptype = $.trim($(this).children('.chiptype').val());
		if( chiptype == 'T3' || $(this).children('.chiptype').hasClass('ncard') ){
			card_list += '<option value="'+i+'__'+$(this).children('.pciloc').val()+'">'+$(this).children('.tree_cardname').html()+'</option>';	
		}
		
		if( i == total_cards ){
			card_list += '</select>';
			$(unique_parent_id+' .boot_cards_wr').html(card_list);
		}
	
	});
	
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	if( ostype == '4' ){
		$(unique_parent_id+' .boot_save_changes_wr button').removeClass('blue').addClass('disabled').attr('disabled','disabled');
		//$(unique_parent_id+' .boot_discard_wr button').removeClass('blue').addClass('disabled').attr('disabled','disabled');
	}
	
	$(loader_selector).hide();
}

function boot_upload_iscsi_option_rom(unique_parent_id, file_id, ip){
	
	var success = true;
	if( $.trim($(unique_parent_id +' .second_wr input.text').val()) == ''  ){
		$(unique_parent_id +' .second_wr input.text').addClass('error');
		success = false;		
	}
	
	if( $.trim($(unique_parent_id +' .boot_cards_wr select').val()) == 'null'  ){
		$(unique_parent_id +' .boot_cards_wr select').addClass('error');
		success = false;		
	}
	
	if(!success){
		return false;
	}
	
	$(unique_parent_id+' .boot_iscsi_processing span').html('Uploading....');
	$(unique_parent_id+' .boot_iscsi_processing').show();
	var username = GetCookie("chelsio_webgui_user");
	var sid = GetCookie("chelsio_webgui_sid");
	var card_index = $(unique_parent_id+' .boot_cards_wr select').val().split('__')[0];
	var getdata = '?user='+username+'&name='+file_id+'&ip='+ip+'&sid='+sid+'&card_index='+card_index+'&action=upload';
	jQuery.ajaxFileUpload({
		url: 'python/boot.py'+getdata,
		secureuri: true,
		fileElementId: file_id,
		dataType: 'xml',
		success: function(xml){
			$(unique_parent_id+' .boot_iscsi_processing').hide();
			var status = $.trim($('status', xml).text());
			if (status == '-2') {
				show_redirect_alert();
			}
			else if (status == '0') {
				$(unique_parent_id+' .boot_iscsi_success').show();
				$(unique_parent_id+' .boot_cards_wr select').trigger('change');
			}
			else{
				$(unique_parent_id+' .boot_iscsi_error').show();
			}
		}
	});
}

function boot_get_data(element, unique_parent_id, ip){
	if( $(element).val() == 'null' ){
		//iscsi_boot_make_default()
		return;
	}
	$(unique_parent_id+' .boot_iscsi_processing span').html('Loading....');
	$(unique_parent_id+' .boot_iscsi_processing').show();	
	$(element).removeClass('error');
	var sid = GetCookie("chelsio_webgui_sid");
	var selected_val = $(unique_parent_id+' .boot_cards_wr select').val().split('__')
	var pciloc = selected_val[1];
	var card_index = selected_val[0];
	var getdata = "sid="+sid+'&ip='+ip+'&action=get_data&pciloc='+pciloc+'&card_index='+card_index;
	
	$.ajax({
		url: '/python/boot.py',
		type: 'GET',
		cache: false,
		data: getdata,
		dataType: 'json',
		success: function(from_server){
			$(unique_parent_id+' .boot_iscsi_loader').hide();
			if (from_server == '-2') {
				show_redirect_alert();
			}
			else if (from_server == '-1') {
				$(unique_parent_id+' .boot_iscsi_error').show();
			}
			else{
				var version = from_server.version;
				if (from_server.is_valid_rom && from_server.is_settings) {
					$(unique_parent_id + ' .rom_status').html('iSCSI option rom is installed '+version+' & iSCSI option rom settings are valid.');
				}
				else if (from_server.is_valid_rom && !from_server.is_settings) {
					$(unique_parent_id + ' .rom_status').html('iSCSI option rom is installed '+version+' & iSCSI option rom settings are invalid.');
				}
				else if ( !from_server.is_valid_rom ) {
					$(unique_parent_id + ' .rom_status').html('iSCSI option rom is not installed.');
				}
				
				if( from_server.is_valid_rom ){
					$(unique_parent_id+' .erase_option_rom_wr button').removeClass('disabled').addClass('blue').removeAttr('disabled');
					$(unique_parent_id).animate({
						height: '1145px'
					});
					$(unique_parent_id+' .boot_iscsi_grid_main').html(from_server.html).fadeIn(300);
					$(unique_parent_id+' .boot_props_btn_wr').fadeIn(300);
				}
				if ( from_server.is_settings ) {
					$(unique_parent_id + ' .erase_boot_settings_wr button').removeClass('disabled').addClass('blue').removeAttr('disabled');
				}
			}	
		}
	});
}

function boot_erase_option_rom(unique_parent_id, ip){
	
	if( $(unique_parent_id+' .erase_option_rom_wr button').hasClass('disabled') ){
		return;
	}

	$(unique_parent_id+' .boot_iscsi_processing span').html('Erasing Option Rom....');
	$(unique_parent_id+' .boot_iscsi_processing').show();
	var sid = GetCookie("chelsio_webgui_sid");
	var card_index = $(unique_parent_id+' .boot_cards_wr select').val().split('__')[0]
	var getdata = 'sid='+sid+'&ip='+ip+'&action=erase_rom&card_index='+card_index;
	$.ajax({
		url: '/python/boot.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(from_server){
			$(unique_parent_id+' .boot_iscsi_loader').hide();
			if (from_server == '-2') {
				show_redirect_alert();
			}
			else if (from_server == '-1') {
				$(unique_parent_id+' .boot_iscsi_error').show();
			}
			else{
				$(unique_parent_id+' .boot_cards_wr select').trigger('change');
				$(unique_parent_id+' .boot_iscsi_success').show();
			}	
		}
	});
}

function boot_erase_settings(unique_parent_id, ip){
	
	if( $(unique_parent_id+' .erase_boot_settings_wr button').hasClass('disabled') ){
		return;
	}
	
	$(unique_parent_id+' .boot_iscsi_processing span').html('Erasing settings....');
	$(unique_parent_id+' .boot_iscsi_processing').show();
	var sid = GetCookie("chelsio_webgui_sid");
	var card_index = $(unique_parent_id+' .boot_cards_wr select').val().split('__')[0]
	var getdata = 'sid='+sid+'&ip='+ip+'&action=erase_settings&card_index='+card_index;
	$.ajax({
		url: '/python/boot.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(from_server){
			$(unique_parent_id+' .boot_iscsi_loader').hide();
			if (from_server == '-2') {
				show_redirect_alert();
			}
			else if (from_server == '-1') {
				$(unique_parent_id+' .boot_iscsi_error').show();
			}
			else{
				$(unique_parent_id+' .boot_cards_wr select').trigger('change');
				$(unique_parent_id+' .boot_iscsi_success').show();
			}	
		}
	});
}

function boot_save_changes(unique_parent_id, ip){
	
	var ip_id = replace_with(ip, '.', '_');
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	if( ostype == '4' ){
		return
	}
	
	$(unique_parent_id+' .boot_iscsi_processing span').html('Saving Changes....');
	$(unique_parent_id+' .boot_iscsi_processing').show();
	var selected_val = $(unique_parent_id+' .boot_cards_wr select').val().split('__');
	var card_index = $(unique_parent_id+' .boot_cards_wr select').val().split('__')[0]
	var postdata = 'sid='+GetCookie("chelsio_webgui_sid")+'&ip='+ip+'&card_index='+card_index+'&ostype='+ostype;
	var properties_count = 0;
	$(unique_parent_id+' .boot_iscsi_grid_main select').each(function(){
		if( parseInt($(this).attr('class').replace('value_','')) != parseInt($(this).val()) ){
			postdata += '&propname='+$(this).attr('title');
			postdata += '&value='+$(this).val();
			properties_count += 1;
		}
	});
	$(unique_parent_id+' .boot_iscsi_grid_main input:not([title=targetportal])').each(function(){
		if($(this).attr('name').replace('value_','') != $.trim($(this).val()) ){
			postdata += '&propname='+$(this).attr('title');
			postdata += '&value='+$.trim($(this).val());
			properties_count += 1;
		}
	});
	
	/*if(!properties_count){
		$(unique_parent_id+' .boot_iscsi_loader').hide();
		$(unique_parent_id+' .boot_iscsi_success').show();
		return
	}*/
	
	var target_portal1 = '';
	var target_portal2 = '';
	$(unique_parent_id+' .boot_iscsi_grid_main [title=targetportal]').each(function(i){
		i = i+1;
		mode = i%2;
		
		if(!mode){
			var port = $(this).val();
			if( i <=2 ){
				target_portal1 += port;
			}
			else if( i <=4 ){
				target_portal2 += port;
			}
		}
		else{
			var ip = $(this).val();
			if( i <=2 ){
				target_portal1 = '1@'+ip+':';
			}
			else if( i <=4 ){
				target_portal2 = '2@'+ip+':';
			}
		}
	});
	
	properties_count += 2;
	postdata += '&propname=targetportal&value='+target_portal1;
	postdata += '&propname=targetportal&value='+target_portal2;
	postdata += '&properties_count='+properties_count;
	
	postdata += '&action=set_properties'
	$.ajax({
		url: '/python/boot.py',
		type: 'POST',
		cache: false,
		data: postdata,
		success: function(status){
			$(unique_parent_id+' .boot_iscsi_loader').hide();
			if (status == '-2') {
				show_redirect_alert();
			}
			else if (status == '0') {
				$(unique_parent_id+' .boot_iscsi_success').show();
				$(unique_parent_id+' .boot_cards_wr select').trigger('change');
			}
			else{
				$(unique_parent_id+' .boot_iscsi_error').show();
			}
		}
	});	
}

function boot_discard_changes(unique_parent_id){
	$(unique_parent_id+' .boot_cards_wr select').trigger('change');
}