Name:     libiwpm
Version:  1.0.3
Release:  1
Summary:  iWarp Port Mapper userspace daemon
Requires: libnl-devel

Group: System Environment/Daemons
License: GPL/BSD
Url: http://www.openfabrics.org/
Source: http://www.openfabrics.org/downloads/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%(%{__id_u} -n)

%define iwpmscript %{_builddir}/%{name}-%{version}/iwpm_script
%define systemdhere %(if (test -d "/lib/systemd/system" > /dev/null || test -d "%{_prefix}/lib/systemd/system" > /dev/null); then echo -n '1'; else echo -n '0'; fi)

%if %systemdhere
%global systemd  /usr/lib/systemd/system
%global systemctl %(test -e "%_bindir/systemctl" > /dev/null && echo "%_bindir/systemctl" || echo "/bin/systemctl")
%else
%global chkconfig %(test -e "%_sbindir/chkconfig" > /dev/null && echo "%_sbindir/chkconfig" || echo "/sbin/chkconfig")
%endif 

%description
libiwpm provides a userspace service for iWarp drivers to claim
tcp ports through the standard socket interface

%prep
%setup -q -n %{name}-%{version}

%build
%configure
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
make DESTDIR=%{buildroot} install
touch %iwpmscript
 %if %systemdhere
	install -Dp -m 0644 %{_builddir}/%{name}-%{version}/iwpmd.service %{buildroot}/%{systemd}/iwpmd.service
	echo "%{systemd}/iwpmd.service" >> %iwpmscript
 %else
	install -Dp -m 0755 %{_builddir}/%{name}-%{version}/iwpmd_init %{buildroot}%{_initrddir}/iwpmd
	echo "%{_initrddir}/iwpmd" >> %iwpmscript
 %endif

mkdir -p %{buildroot}%{_sysconfdir}
cp %{_builddir}/%{name}-%{version}/iwpmd.conf %{buildroot}%{_sysconfdir}/iwpmd.conf

%clean
rm -rf %{buildroot}

%post
 %if %systemdhere
	if [ $1 -eq 1 ]; then
		%systemctl enable iwpmd.service || exit 0
		%systemctl start iwpmd.service || exit 0
	elif [ $1 -gt 1 ]; then
		%systemctl reload iwpmd.service || exit 0
		%systemctl restart iwpmd.service || exit 0
	fi
 %else
	if [ $1 -eq 1 ]; then
		%chkconfig --add iwpmd
		%{_initrddir}/iwpmd start || exit 0
	elif [ $1 -gt 1 ]; then
		%{_initrddir}/iwpmd restart || exit 0
	fi
 %endif

%preun
if [ $1 -eq 0 ]; then 
 %if %systemdhere
	%systemctl stop iwpmd.service || exit 0
	%systemctl disable iwpmd.service || exit 0
 %else
	%{_initrddir}/iwpmd stop || exit 0
        %chkconfig --del iwpmd
 %endif	
fi

%postun
if [ $1 -ge 1 ]; then
 %if %systemdhere
	%systemctl reload iwpmd.service || exit 0
	%systemctl restart iwpmd.service || exit 0
 %else
	%{_initrddir}/iwpmd restart || exit 0
 %endif	
fi

%files -f %iwpmscript
%defattr(-,root,root,-) 
%_includedir/rdma/iwpm_netlink.h
%_includedir/rdma/iwarp_pm.h
%_bindir/iwpmd
%doc AUTHORS COPYING README
%config %_sysconfdir/iwpmd.conf

%changelog
*Wed Oct 14 2015 Tatyana Nikolova <tatyana.e.nikolova@intel.com> -  1.0.3
- Fix for the init script to enable the service to start automatically
  after boot on SLES11 SP4
- Releasing libiwpm-1.0.3 to be included in OFED-3.18-1
*Fri Aug 14 2015 Tatyana Nikolova <tatyana.e.nikolova@intel.com> -  1.0.3rc1
- Adding iwpmd.conf file to enable changing the size
  of the netlink socket receive buffer
- Including a fix for failing to send netlink messages
*Thu Jul 2 2015 Tatyana Nikolova <tatyana.e.nikolova@intel.com> -  1.0.2
- Fixes for the iwpmd start-up scripts with systemd
- A change to enable multi devices per port mapper client
- Releasing libiwpm-1.0.2 to be included in OFED-3.18
*Fri Oct 31 2014 Tatyana Nikolova <tatyana.e.nikolova@intel.com> - 1.0.1
- Releasing libiwpm-1.0.1 to be included in OFED-3.18
*Mon Jun 10 2013 Tatyana Nikolova <tatyana.e.nikolova@intel.com> - 1.0.0
- Releasing iWarp Port Mapper Version 1.0.0 
